/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.template;

import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement;
import com.tandbergtv.watchpoint.studio.ui.model.ProtectionKey;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectionKeyMatchRule
implements IValidationRule<WorkflowTemplate> {
    @Override
    public List<ValidationMessage> validateRule(WorkflowTemplate target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        Set<ProtectionKey> protectionKeys = target.getProtectionKeys();
        if (protectionKeys == null) {
            protectionKeys = new HashSet<ProtectionKey>();
        }
        HashSet<String> protectionKeyNames = new HashSet<String>();
        HashSet<String> duplicateNames = new HashSet<String>();
        for (ProtectionKey protectionKey : protectionKeys) {
            String name = protectionKey.getName();
            if (name == null) {
                name = "";
            }
            if (protectionKeyNames.contains(name)) {
                if (duplicateNames.contains(name)) continue;
                duplicateNames.add(name);
                this.validateDuplicateProtectionKey(name, messages, target);
                continue;
            }
            protectionKeyNames.add(name);
        }
        ServiceFactory factory = ServiceFactory.createFactory();
        IResourceGroupService service = factory.createResourceGroupService();
        HashMap<String, HashSet<NodeElement>> nodesUsingGroup = new HashMap<String, HashSet<NodeElement>>();
        NodeElement[] nodeElementArray = target.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            IResourceGroupElement element;
            ResourceGroup resourceGroupModel;
            NodeElement node = nodeElementArray[n2];
            if (node instanceof IResourceGroupElement && (resourceGroupModel = (element = (IResourceGroupElement)node).getResourceGroup()) != null && (name = resourceGroupModel.getName()) != null && name.length() != 0) {
                HashSet<NodeElement> nodes = (HashSet<NodeElement>)nodesUsingGroup.get(name);
                if (nodes == null) {
                    nodes = new HashSet<NodeElement>();
                    nodesUsingGroup.put(name, nodes);
                }
                nodes.add(node);
            }
            ++n2;
        }
        for (String groupName : nodesUsingGroup.keySet()) {
            String pkName = service.getProtectionKeyByResourceGroupName(groupName).getName();
            Set nodes = (Set)nodesUsingGroup.get(groupName);
            this.validateProtectionKeyForNodes(pkName, protectionKeyNames, messages, nodes);
        }
        return messages;
    }

    private void validateDuplicateProtectionKey(String name, List<ValidationMessage> messages, WorkflowTemplate template) {
        ValidationMessageCode code = ValidationMessageCode.DUPLICATE_TEMPLATE_PROTECTION_KEY;
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(name);
        messages.add(new ValidationMessage(template, ValidationMessageType.Error, code, parameters));
    }

    private void validateProtectionKeyForNodes(String keyName, Set<String> protectionKeyNames, List<ValidationMessage> messages, Set<NodeElement> nodes) {
        if (!protectionKeyNames.contains(keyName)) {
            ValidationMessageCode code = ValidationMessageCode.TEMPLATE_NODE_PROTECTION_KEY_MISMATCH;
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(keyName);
            for (NodeElement node : nodes) {
                messages.add(new ValidationMessage(node, ValidationMessageType.Error, code, parameters));
            }
        }
    }
}

