/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.template.graph;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import com.tandbergtv.watchpoint.studio.validation.graph.WorkflowTemplateGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.EndState;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.StartState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredTemplateNodesRule
implements IValidationRule<WorkflowTemplateGraph> {
    @Override
    public List<ValidationMessage> validateRule(WorkflowTemplateGraph graph) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        int startNodeCount = 0;
        int endNodeCount = 0;
        boolean otherNodesExist = false;
        Set vertices = graph.getVertices();
        for (Vertex vertex : vertices) {
            NodeElement node = WatchPointGraphUtils.getWTVertexElement(vertex);
            if (node instanceof StartState) {
                ++startNodeCount;
                continue;
            }
            if (node instanceof EndState) {
                ++endNodeCount;
                continue;
            }
            otherNodesExist = true;
        }
        Object graphElement = WatchPointGraphUtils.getElement((UserDataContainer)graph);
        this.validateStartNodeCount(startNodeCount, messages, graphElement);
        this.validateEndNodeCount(endNodeCount, messages, graphElement);
        this.validateNodeCount(otherNodesExist, messages, graphElement);
        return messages;
    }

    private void validateStartNodeCount(int count, List<ValidationMessage> messages, Object element) {
        if (count == 0) {
            ValidationMessageCode messageCode = ValidationMessageCode.TEMPLATE_MISSING_START_NODE;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, messageCode));
        } else if (count > 1) {
            ValidationMessageCode messageCode = ValidationMessageCode.TEMPLATE_EXTRA_START_NODE;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, messageCode));
        }
    }

    private void validateEndNodeCount(int count, List<ValidationMessage> messages, Object element) {
        if (count == 0) {
            ValidationMessageCode messageCode = ValidationMessageCode.TEMPLATE_MISSING_END_NODE;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, messageCode));
        }
    }

    private void validateNodeCount(boolean nodeExists, List<ValidationMessage> messages, Object element) {
        if (!nodeExists) {
            ValidationMessageCode messageCode = ValidationMessageCode.TEMPLATE_MISSING_NODE;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, messageCode));
        }
    }
}

