/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.template.graph;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.ForkPathLabeler;
import com.tandbergtv.watchpoint.studio.validation.graph.GraphFactory;
import com.tandbergtv.watchpoint.studio.validation.graph.IWatchPointGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointDecorator;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import com.tandbergtv.watchpoint.studio.validation.graph.WorkflowTemplateGraph;
import edu.uci.ics.jung.algorithms.connectivity.BFSDistanceLabeler;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateForkJoinValidationRule
implements IValidationRule<WorkflowTemplateGraph> {
    private static final int MAX_ALLOWED_FORK_NEST_LEVEL = 1;
    private static final String FORK_VALID_KEY = "fork.isValid";

    @Override
    public List<ValidationMessage> validateRule(WorkflowTemplateGraph graph) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        WorkflowTemplateGraph graphCopy = (WorkflowTemplateGraph)graph.copy();
        ForkPathLabeler forkLabeler = new ForkPathLabeler();
        forkLabeler.labelForkPaths(graphCopy);
        WatchPointDecorator<String, Boolean> validityDecorator = new WatchPointDecorator<String, Boolean>(FORK_VALID_KEY, UserData.SHARED);
        this.validateForkJoinCount(forkLabeler, messages);
        Set<Vertex> forkVertices = forkLabeler.getForkVertices();
        for (Vertex forkVertex : forkVertices) {
            validityDecorator.setValue(true, (UserDataContainer)forkVertex);
            this.validateForkNestLevel(forkVertex, forkLabeler, messages, validityDecorator);
            this.validateForkToSingleJoin(forkVertex, forkLabeler, messages, validityDecorator);
        }
        Set<Vertex> joinVertices = forkLabeler.getJoinVertices();
        for (Vertex joinVertex : joinVertices) {
            this.validateJoinFromSingleFork(joinVertex, forkLabeler, messages, validityDecorator);
        }
        for (Vertex forkVertex : forkVertices) {
            if (!validityDecorator.getValue((UserDataContainer)forkVertex).booleanValue()) continue;
            Vertex joinVertex = this.getJoinVertex(forkVertex, forkLabeler);
            Set<Vertex> vertices = this.getForkGraphVertices(forkVertex, forkLabeler);
            this.validateForkJoinReachability(forkVertex, joinVertex, vertices, forkLabeler, messages, validityDecorator);
            if (!validityDecorator.getValue((UserDataContainer)forkVertex).booleanValue()) continue;
            this.validateForkSubgraphDisjoint(forkVertex, joinVertex, vertices, forkLabeler, messages, validityDecorator);
            if (!validityDecorator.getValue((UserDataContainer)forkVertex).booleanValue()) continue;
            this.validateForkTransitionsDisjoint(forkVertex, forkLabeler, messages, validityDecorator);
        }
        return messages;
    }

    private void validateForkJoinCount(ForkPathLabeler labeler, List<ValidationMessage> messages) {
        int joinCount;
        int forkCount = labeler.getForkVertices().size();
        if (forkCount != (joinCount = labeler.getJoinVertices().size())) {
            Object element = WatchPointGraphUtils.getElement((UserDataContainer)labeler.getGraph());
            ValidationMessageCode code = ValidationMessageCode.TEMPLATE_FORK_JOIN_UNEQUAL;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, code));
        }
    }

    private void validateForkNestLevel(Vertex forkVertex, ForkPathLabeler labeler, List<ValidationMessage> messages, WatchPointDecorator<String, Boolean> decorator) {
        int nestLevel = labeler.getForkNestLevel(forkVertex);
        if (nestLevel > 1) {
            Object element = WatchPointGraphUtils.getElement((UserDataContainer)forkVertex);
            ValidationMessageCode code = ValidationMessageCode.INVALID_FORK_NEST_LEVEL;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, code));
            decorator.setValue(false, (UserDataContainer)forkVertex);
        }
    }

    private void validateForkToSingleJoin(Vertex forkVertex, ForkPathLabeler forkLabeler, List<ValidationMessage> messages, WatchPointDecorator<String, Boolean> decorator) {
        int joinVerticesCount;
        Set<Vertex> joinVertices = forkLabeler.getJoinVertices(forkVertex);
        int n = joinVerticesCount = joinVertices != null ? joinVertices.size() : 0;
        if (joinVerticesCount != 1) {
            Object element = WatchPointGraphUtils.getElement((UserDataContainer)forkVertex);
            ValidationMessageCode code = joinVerticesCount == 0 ? ValidationMessageCode.FORK_MISSING_JOIN_PAIR : ValidationMessageCode.FORK_MAPPED_TO_MANY_JOINS;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, code));
            decorator.setValue(false, (UserDataContainer)forkVertex);
        } else {
            for (Object edgeObject : forkVertex.getOutEdges()) {
                if (forkLabeler.getJoinVertices((Edge)edgeObject).size() != 0) continue;
                Object element = WatchPointGraphUtils.getElement((UserDataContainer)forkVertex);
                ValidationMessageCode code = ValidationMessageCode.FORK_TRANSITION_MISSING_JOIN_PAIR;
                messages.add(new ValidationMessage(element, ValidationMessageType.Error, code));
                decorator.setValue(false, (UserDataContainer)forkVertex);
                break;
            }
        }
    }

    private void validateJoinFromSingleFork(Vertex joinVertex, ForkPathLabeler forkLabeler, List<ValidationMessage> messages, WatchPointDecorator<String, Boolean> decorator) {
        int forkVerticesCount;
        Set<Vertex> forkVertices = forkLabeler.getForkVertices(joinVertex);
        int n = forkVerticesCount = forkVertices != null ? forkVertices.size() : 0;
        if (forkVerticesCount != 1) {
            Object element = WatchPointGraphUtils.getElement((UserDataContainer)joinVertex);
            ValidationMessageCode code = forkVerticesCount == 0 ? ValidationMessageCode.JOIN_MISSING_FORK_PAIR : ValidationMessageCode.JOIN_MAPPED_TO_MANY_FORKS;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, code));
            if (forkVerticesCount > 1) {
                for (Vertex forkVertex : forkVertices) {
                    decorator.setValue(false, (UserDataContainer)forkVertex);
                }
            }
        }
    }

    private void validateForkJoinReachability(Vertex forkVertex, Vertex joinVertex, Set<Vertex> forkGraphVertices, ForkPathLabeler labeler, List<ValidationMessage> messages, WatchPointDecorator<String, Boolean> decorator) {
        IWatchPointGraph graph = labeler.getGraph();
        IWatchPointGraph graphCopy = GraphFactory.createFactory().createReverseGraph(graph);
        for (Object vertexObject : graph.getVertices()) {
            Vertex vertex = (Vertex)vertexObject;
            if (forkGraphVertices.contains(vertex)) continue;
            Vertex equalVertex = (Vertex)vertex.getEqualVertex((ArchetypeGraph)graphCopy);
            graphCopy.removeVertex(equalVertex);
        }
        BFSDistanceLabeler distanceLabeler = new BFSDistanceLabeler("fork.subgraph.distance");
        distanceLabeler.labelDistances((Graph)graphCopy, (Vertex)joinVertex.getEqualVertex((ArchetypeGraph)graphCopy));
        if (distanceLabeler.getUnivistedVertices().size() > 0) {
            Object element = WatchPointGraphUtils.getElement((UserDataContainer)forkVertex);
            ValidationMessageCode code = ValidationMessageCode.FORK_PATH_MISSING_JOIN;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, code));
            decorator.setValue(false, (UserDataContainer)forkVertex);
        }
    }

    private void validateForkSubgraphDisjoint(Vertex forkVertex, Vertex joinVertex, Set<Vertex> forkGraphVertices, ForkPathLabeler labeler, List<ValidationMessage> messages, WatchPointDecorator<String, Boolean> decorator) {
        boolean isValid = true;
        for (Vertex vertex : forkGraphVertices) {
            boolean isFork = vertex.equals(forkVertex);
            boolean isJoin = vertex.equals(joinVertex);
            for (Object vertexObject : vertex.getPredecessors()) {
                ValidationMessageCode code;
                Object element;
                Vertex predecessor = (Vertex)vertexObject;
                boolean isInSubgraph = forkGraphVertices.contains(predecessor);
                if (isFork) {
                    if (!isInSubgraph || predecessor.equals(joinVertex)) continue;
                    element = WatchPointGraphUtils.getElement((UserDataContainer)forkVertex);
                    code = ValidationMessageCode.FORK_REACHED_FROM_FORK_SUBGRAPH;
                    messages.add(new ValidationMessage(element, ValidationMessageType.Error, code));
                    isValid = false;
                    break;
                }
                if (isJoin) {
                    if (predecessor.equals(forkVertex)) {
                        element = WatchPointGraphUtils.getElement((UserDataContainer)forkVertex);
                        code = ValidationMessageCode.FORK_JOIN_PATH_EMPTY;
                        messages.add(new ValidationMessage(element, ValidationMessageType.Error, code));
                        isValid = false;
                        break;
                    }
                    if (isInSubgraph) continue;
                    element = WatchPointGraphUtils.getElement((UserDataContainer)joinVertex);
                    code = ValidationMessageCode.JOIN_REACHED_OUTSIDE_FORK_SUBGRAPH;
                    messages.add(new ValidationMessage(element, ValidationMessageType.Error, code));
                    isValid = false;
                    break;
                }
                if (isInSubgraph) continue;
                element = WatchPointGraphUtils.getElement((UserDataContainer)forkVertex);
                code = ValidationMessageCode.FORK_SUBGRAPH_REACHED_OUTSIDE_FORK_SUBGRAPH;
                messages.add(new ValidationMessage(element, ValidationMessageType.Error, code));
                isValid = false;
                break;
            }
            if (isValid) continue;
            decorator.setValue(false, (UserDataContainer)forkVertex);
            break;
        }
    }

    private void validateForkTransitionsDisjoint(Vertex forkVertex, ForkPathLabeler labeler, List<ValidationMessage> messages, WatchPointDecorator<String, Boolean> decorator) {
        HashSet<Vertex> reachableVertices = new HashSet<Vertex>();
        boolean isValid = true;
        for (Object edgeObject : forkVertex.getOutEdges()) {
            Edge forkEdge = (Edge)edgeObject;
            Set<Vertex> edgeReachableVertices = labeler.getReachableVertices(forkEdge);
            if (reachableVertices.size() == 0) {
                reachableVertices.addAll(edgeReachableVertices);
            } else {
                for (Vertex vertex : edgeReachableVertices) {
                    if (reachableVertices.contains(vertex)) {
                        Object element = WatchPointGraphUtils.getElement((UserDataContainer)forkVertex);
                        ValidationMessageCode code = ValidationMessageCode.FORK_TRANSITIONS_OVERLAP_NODES;
                        messages.add(new ValidationMessage(element, ValidationMessageType.Error, code));
                        isValid = false;
                        break;
                    }
                    reachableVertices.add(vertex);
                }
            }
            if (isValid) continue;
            decorator.setValue(false, (UserDataContainer)forkVertex);
            break;
        }
    }

    private Vertex getJoinVertex(Vertex forkVertex, ForkPathLabeler labeler) {
        Vertex joinVertex = null;
        Set<Vertex> joinVertices = labeler.getJoinVertices(forkVertex);
        if (joinVertices != null && joinVertices.size() > 0) {
            joinVertex = joinVertices.iterator().next();
        }
        return joinVertex;
    }

    private Set<Vertex> getForkGraphVertices(Vertex forkVertex, ForkPathLabeler labeler) {
        HashSet<Vertex> forkGraphVertices = new HashSet<Vertex>();
        forkGraphVertices.add(forkVertex);
        forkGraphVertices.addAll(labeler.getJoinVertices(forkVertex));
        forkGraphVertices.addAll(labeler.getReachableVertices(forkVertex));
        return forkGraphVertices;
    }
}

