/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.watchfolder.core;

import com.tandbergtv.watchpoint.watchfolder.core.DirectoryMonitor;
import com.tandbergtv.watchpoint.watchfolder.core.FTPClientWrapper;
import com.tandbergtv.watchpoint.watchfolder.core.FileInfo;
import com.tandbergtv.watchpoint.watchfolder.core.Processor;
import com.tandbergtv.watchpoint.watchfolder.core.WPFileFilter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPDirectoryMonitor
extends DirectoryMonitor {
    private static Logger logger = Logger.getLogger(FTPDirectoryMonitor.class);
    private static final String FTP_PATH_PREFIX = "ftp://";
    private String dirPath;
    private String host;
    private String username;
    private String password;

    public FTPDirectoryMonitor(String path, Set<WPFileFilter> fileFilters, Processor processor) {
        super(fileFilters, processor);
        int colonInd = path.indexOf(":", 6);
        this.username = path.substring(6, colonInd);
        int atInd = path.indexOf("@");
        this.password = path.substring(colonInd + 1, atInd);
        int slashInd = path.indexOf("/", atInd);
        if (slashInd != -1) {
            this.host = path.substring(atInd + 1, slashInd);
            this.dirPath = path.substring(slashInd);
            if (!this.dirPath.endsWith("/")) {
                this.dirPath = this.dirPath + "/";
            }
        } else {
            this.host = path.substring(atInd + 1);
            this.dirPath = "/";
        }
    }

    @Override
    protected Map<String, FileInfo> getFiles() {
        HashMap<String, FileInfo> files = new HashMap<String, FileInfo>();
        FTPClientWrapper ftpClient = new FTPClientWrapper();
        FTPFile[] filesArray = null;
        try {
            if (ftpClient.connLogin(this.host, this.username, this.password)) {
                if (ftpClient.changeWorkingDirectory(this.dirPath)) {
                    filesArray = ftpClient.listFiles();
                } else {
                    logger.warn((Object)(this.dirPath + " on server " + this.host + " does not exist"));
                }
            } else {
                String errorMessage = "Cannot connect to ftp server: " + this.host;
                logger.error((Object)errorMessage);
                throw new RuntimeException(errorMessage);
            }
            ftpClient.logout();
            ftpClient.disconnect();
        }
        catch (UnknownHostException e) {
            logger.error((Object)"UnknownHostException Caught: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (FTPConnectionClosedException e) {
            logger.error((Object)"FTPConnectionClosedException Caught: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.error((Object)"IOException Caught: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (filesArray == null || filesArray.length == 0) {
            logger.debug((Object)(this.dirPath + " on server " + this.host + " does not exist or there are no files in directory"));
        } else {
            logger.debug((Object)("Files: " + filesArray));
            for (FTPFile file : filesArray) {
                logger.debug((Object)("File: " + file));
                if (file != null) {
                    files.put(file.getName(), this.getFileInfo(file));
                    continue;
                }
                logger.warn((Object)("Unrecognized file. File ignored. FTPFile object is null for server: " + this.host + " | path: " + this.dirPath + " | user: " + this.username));
            }
        }
        return files;
    }

    protected FileInfo getFileInfo(FTPFile file) {
        String absolutePath = FTP_PATH_PREFIX + this.host + this.dirPath + file.getName();
        return new FileInfo(file.getName(), file.getSize(), file.getTimestamp().getTimeInMillis(), absolutePath);
    }
}

