/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.security;

import com.n2bb.security.AreaPermissionList;
import com.n2bb.security.IdenticalPasswordException;
import com.n2bb.security.ModuleAreaList;
import com.n2bb.security.RoleBean;
import com.n2bb.security.RoleForm;
import com.n2bb.security.UserSecurityData;
import com.n2bb.user.UserBean;
import com.n2bb.util.DigestUtil;
import com.n2bb.util.N2bbException;
import com.n2bb.util.PropertyManager;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityManager {
    private static final String NO_ROLE_DEFINED = "no role defined";
    private static final String USER_TABLE = "users_realm";
    private static final String BIGROLE_TABLE = "bigRole";
    private static final String BIGROLE_ROLE_TABLE = "bigRole_role";
    private static final String BIGROLE_PERMISSION_TABLE = "TTV_BIGROLEPERMISSION";
    private static final String USER_BIGROLE_TABLE = "user_bigRole";
    private static final String USER_DATA = "user_data";
    private static Logger n2bbLog = Logger.getLogger(SecurityManager.class);
    private static SecurityManager secMgr;
    private static List moduleAreaLists;
    public static final String DEFAULT_SECURITY_FILE = "security.xml";
    private DataSource ds;

    private SecurityManager() {
    }

    private DataSource getDataSource() {
        return PropertyManager.getUIDataSource();
    }

    public static SecurityManager getInstance() {
        n2bbLog.debug((Object)"enter");
        if (secMgr == null) {
            n2bbLog.error((Object)"security manager not properly initialized");
            n2bbLog.error((Object)"  please call init(dataSource, securityConfig) to initialize");
            return null;
        }
        return secMgr;
    }

    public static void destroy() {
        n2bbLog.debug((Object)"enter");
        secMgr = null;
    }

    public static synchronized SecurityManager init(ServletContext servletContext, String securityDir) {
        n2bbLog.debug((Object)"enter");
        if (secMgr != null) {
            return secMgr;
        }
        secMgr = new SecurityManager();
        return secMgr;
    }

    private void createAdminRoleAndUser() throws N2bbException, SQLException {
        this.createAdminRole();
        this.createAdminUser();
    }

    private void createAdminRole() throws N2bbException {
        if (this.roleExists("Admin")) {
            return;
        }
        n2bbLog.info((Object)"admin role does not exist; creating...");
        this.saveRole("Admin", "Default System Administrator", new Vector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAdminUser() throws N2bbException, SQLException {
        if (this.userExists("admin")) {
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            n2bbLog.info((Object)"admin user does not exist; creating...");
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            this.createUser("admin", "administrator", "A", "Admin", con);
            pstmt = con.prepareStatement("insert into user_data (user_name, firstName, lastName, email, phone) values(?, ?, ?, ?, ?)");
            pstmt.setString(1, "admin");
            pstmt.setString(2, "Super");
            pstmt.setString(3, "User");
            pstmt.setString(4, "admin@n2bb.com");
            pstmt.setString(5, "");
            pstmt.executeUpdate();
            this.closeStatement(pstmt);
            this.closeConnection(con);
        }
        catch (Throwable throwable) {
            this.closeStatement(pstmt);
            this.closeConnection(con);
            throw throwable;
        }
    }

    private void insertAdminRoles() throws N2bbException {
        LinkedList<String> allWebXMLRoles = new LinkedList<String>();
        for (ModuleAreaList mal : moduleAreaLists) {
            List areaPermissions = mal.getAreaPermissionLists();
            for (AreaPermissionList apl : areaPermissions) {
                List permissions = apl.getPermissions();
                for (AreaPermissionList.Permission perm : permissions) {
                    n2bbLog.debug((Object)("xml role... " + perm.getWebXMLRole()));
                    allWebXMLRoles.add(perm.getWebXMLRole());
                }
            }
        }
        this.updateRole("Admin", "Default System Administrator", allWebXMLRoles);
    }

    private void loadRoles(InputStream securityConfigXml) throws ParserConfigurationException, SAXException, IOException, N2bbException {
        this.loadRoleDisplayList(this.getXMLDocument(securityConfigXml));
    }

    private Document getXMLDocument(InputStream xml) throws ParserConfigurationException, SAXException, IOException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xml);
    }

    private void loadRoleDisplayList(Document secDoc) throws N2bbException {
        n2bbLog.debug((Object)"enter");
        String module = null;
        try {
            Element security = secDoc.getDocumentElement();
            module = security.getAttribute("display");
            if (this.isEmpty(module)) {
                n2bbLog.warn((Object)"module has no display name in security xml file");
                module = "";
            } else {
                n2bbLog.info((Object)("processing module... '" + module + "'"));
            }
            NodeList areas = security.getChildNodes();
            List areaPermissions = this.getAreaPermissions(areas);
            n2bbLog.info((Object)("permissions list initialized for module... '" + module + "'"));
            moduleAreaLists.add(new ModuleAreaList(module, areaPermissions));
        }
        catch (Exception e) {
            n2bbLog.error((Object)("error loading permissions for module... '" + module + "'"));
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }

    private List getAreaPermissions(NodeList areas) {
        n2bbLog.debug((Object)"enter");
        LinkedList<AreaPermissionList> areaPermissions = new LinkedList<AreaPermissionList>();
        for (int i = 0; i < areas.getLength(); ++i) {
            String areaDis;
            if (!areas.item(i).hasChildNodes() || this.isEmpty(areaDis = ((Element)areas.item(i)).getAttribute("display"))) continue;
            n2bbLog.info((Object)("processing area... '" + areaDis + "'"));
            NodeList roles = areas.item(i).getChildNodes();
            AreaPermissionList permList = new AreaPermissionList(areaDis);
            for (int j = 0; j < roles.getLength(); ++j) {
                if (!(roles.item(j) instanceof Element)) continue;
                Element role = (Element)roles.item(j);
                String webXMLRole = role.getAttribute("webXMLRole");
                String roleDis = role.getAttribute("display");
                if (this.isEmpty(webXMLRole) || this.isEmpty(roleDis)) continue;
                n2bbLog.info((Object)("adding permission... " + roleDis + " with webXMLRole... " + webXMLRole));
                permList.addPermission(roleDis, webXMLRole);
            }
            if (permList.isEmpty()) continue;
            areaPermissions.add(permList);
        }
        return areaPermissions;
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().equals("");
    }

    public Vector getRoleMap() throws N2bbException {
        n2bbLog.debug((Object)"enter");
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        Vector<RoleBean> roles = new Vector<RoleBean>();
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            stmt = con.createStatement();
            String query = "select * from bigRole";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                RoleBean rb = new RoleBean();
                rb.setN2RoleName(rs.getString(1));
                rb.setDescription(rs.getString(2));
                rb.setUserCount(this.getUserCount(rb.getN2RoleName(), con));
                roles.add(rb);
            }
            rs.close();
            stmt.close();
            this.closeResultSet(rs);
            this.closeStatement(stmt);
            this.closeConnection(con);
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getUserCount(String bigRole, Connection con) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            String query = "select count(*)  from user_bigRole where bigRole = ?";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, bigRole);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            this.closeStatement(pstmt);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(pstmt);
            throw throwable;
        }
    }

    public void saveRole(String name, String description, List roles) throws N2bbException {
        n2bbLog.debug((Object)("enter n2 role... " + name));
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            if (this.roleExists(name)) {
                n2bbLog.warn((Object)("n2 role already exists... " + name));
                throw new N2bbException("error.securityManager.duplicateN2RoleName");
            }
            try {
                con.setAutoCommit(false);
                pstmt = con.prepareStatement("insert into  bigRole  (bigrole, description) values(?, ?)");
                pstmt.setString(1, name);
                pstmt.setString(2, description);
                pstmt.executeUpdate();
                pstmt.close();
                pstmt = con.prepareStatement("insert into  bigRole_role (bigrole, role) values(?,?)");
                pstmt.setString(1, name);
                for (String role : roles) {
                    n2bbLog.debug((Object)("role... " + role));
                    pstmt.setString(2, role);
                    pstmt.executeUpdate();
                }
                n2bbLog.debug((Object)"base role... Base Role");
                pstmt.setString(2, "Base Role");
                pstmt.executeUpdate();
                pstmt.close();
                con.commit();
                con.setAutoCommit(true);
            }
            catch (Exception e) {
                n2bbLog.error((Object)e.getMessage(), (Throwable)e);
                con.rollback();
                con.setAutoCommit(true);
                throw new N2bbException("error.other");
            }
            this.closeStatement(pstmt);
            this.closeConnection(con);
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    public void deleteRole(String n2RoleName) throws N2bbException {
        n2bbLog.debug((Object)("n2 role... " + n2RoleName));
        Connection con = null;
        PreparedStatement pstmt = null;
        String query = null;
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            try {
                con.setAutoCommit(false);
                query = "delete from TTV_BIGROLEPERMISSION where bigRole=?";
                pstmt = con.prepareStatement(query);
                pstmt.setString(1, n2RoleName);
                pstmt.executeUpdate();
                pstmt.close();
                n2bbLog.debug((Object)"deleted from TTV_BIGROLEPERMISSION");
                query = "delete from bigRole where bigRole=?";
                pstmt = con.prepareStatement(query);
                pstmt.setString(1, n2RoleName);
                pstmt.executeUpdate();
                pstmt.close();
                n2bbLog.debug((Object)"deleted from BIGROLE");
                con.commit();
                con.setAutoCommit(true);
            }
            catch (Exception e) {
                n2bbLog.error((Object)e.getMessage(), (Throwable)e);
                con.rollback();
                con.setAutoCommit(true);
                throw new N2bbException("error.other");
            }
            this.closeStatement(pstmt);
            this.closeConnection(con);
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    public void updateRole(String name, String description, List roles) throws N2bbException {
        n2bbLog.debug((Object)("role... " + name));
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            try {
                con.setAutoCommit(false);
                String query = "update bigRole set description=? where bigRole=?";
                pstmt = con.prepareStatement(query);
                pstmt.setString(1, description);
                pstmt.setString(2, name);
                pstmt.executeUpdate();
                pstmt.close();
                query = "delete from bigRole_role where bigRole=?";
                pstmt = con.prepareStatement(query);
                pstmt.setString(1, name);
                pstmt.executeUpdate();
                pstmt.close();
                roles = new ArrayList<String>(roles);
                roles.add("Base Role");
                query = "insert into bigRole_role (bigrole, role)values (?,?)";
                pstmt = con.prepareStatement(query);
                pstmt.setString(1, name);
                for (String role : roles) {
                    n2bbLog.info((Object)("mapping " + name + " to " + role));
                    pstmt.setString(2, role);
                    pstmt.executeUpdate();
                }
                con.commit();
                con.setAutoCommit(true);
            }
            catch (Exception e) {
                n2bbLog.error((Object)e.getMessage(), (Throwable)e);
                con.rollback();
                con.setAutoCommit(true);
                throw new N2bbException("error.other");
            }
            this.closeStatement(pstmt);
            this.closeConnection(con);
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    public RoleForm getRole(String name) throws N2bbException {
        n2bbLog.debug((Object)("enter n2 role... " + name));
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            String query = "select description from bigRole where bigRole=?";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            String description = "";
            if (rs.next()) {
                description = rs.getString(1);
            }
            rs.close();
            pstmt.close();
            query = "select role from bigRole_role where bigRole=?";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            Vector<String> permissions = new Vector<String>();
            while (rs.next()) {
                permissions.add(rs.getString(1));
            }
            rs.close();
            pstmt.close();
            RoleForm form = new RoleForm();
            form.setN2RoleName(name);
            form.setDescription(description);
            form.setPermissions(permissions.toArray(new String[0]));
            RoleForm roleForm = form;
            this.closeResultSet(rs);
            this.closeStatement(pstmt);
            this.closeConnection(con);
            return roleForm;
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    private boolean roleExists(String name) throws N2bbException {
        n2bbLog.debug((Object)("enter n2 role... " + name));
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean bExists = false;
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            String query = "select * from bigRole where bigRole=?";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            bExists = rs.next();
            rs.close();
            pstmt.close();
            boolean bl = bExists;
            this.closeResultSet(rs);
            this.closeStatement(pstmt);
            this.closeConnection(con);
            return bl;
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    public List getModuleAreaLists() {
        return moduleAreaLists;
    }

    public Vector getRoleNames() throws N2bbException {
        n2bbLog.debug((Object)"enter");
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        Vector<String> n2RoleVector = new Vector<String>();
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            stmt = con.createStatement();
            String query = "select bigRole from bigRole";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                n2RoleVector.addElement(rs.getString(1));
            }
            rs.close();
            stmt.close();
            Vector<String> vector = n2RoleVector;
            this.closeResultSet(rs);
            this.closeStatement(stmt);
            this.closeConnection(con);
            return vector;
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    public void createUser(String name, String pass, String status, String n2Role, Connection con) throws N2bbException {
        n2bbLog.debug((Object)("enter user... " + name));
        PreparedStatement pstmt = null;
        try {
            n2bbLog.debug((Object)"insert user, password, and status");
            pstmt = con.prepareStatement("insert into users_realm (user_name, user_pass, password_modified_date, status)values(?, ?, ?, ?)");
            pstmt.setString(1, name);
            pstmt.setString(2, DigestUtil.Digest(pass, "SHA"));
            pstmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            int istat = 0;
            if (status.equalsIgnoreCase("Active") || status.equalsIgnoreCase("A")) {
                istat = 1;
            }
            pstmt.setInt(4, istat);
            pstmt.executeUpdate();
            pstmt.close();
            n2bbLog.debug((Object)"insert user and n2 role");
            pstmt = con.prepareStatement("insert into user_bigRole(user_name, bigrole) values(?, ?)");
            pstmt.setString(1, name);
            pstmt.setString(2, n2Role);
            pstmt.executeUpdate();
            pstmt.close();
            this.closeStatement(pstmt);
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                throw throwable;
            }
        }
    }

    public void updateUser(String username, String status, String n2Role, Connection con) throws N2bbException {
        UserSecurityData securityData = this.getUserSecurityData(username);
        String password = securityData.getPassword();
        this.updateUser(username, "temp", status, n2Role, con);
        this.setPassword(username, password, false, con);
    }

    public void updateUser(String name, String pass, String status, String n2Role, Connection con) throws N2bbException {
        this.deleteUser(name, con);
        this.createUser(name, pass, status, n2Role, con);
    }

    public void deleteUser(String name, Connection con) throws N2bbException {
        n2bbLog.debug((Object)("enter user... " + name));
        PreparedStatement pstmt = null;
        try {
            n2bbLog.debug((Object)"delete user role mappings");
            String query = "delete from user_bigRole where user_name=?";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, name);
            pstmt.executeUpdate();
            pstmt.close();
            n2bbLog.debug((Object)"delete user");
            pstmt = con.prepareStatement("delete from users_realm where user_name=?");
            pstmt.setString(1, name);
            pstmt.executeUpdate();
            pstmt.close();
            this.closeStatement(pstmt);
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                throw throwable;
            }
        }
    }

    public UserSecurityData getUserSecurityData(String name) throws N2bbException {
        n2bbLog.debug((Object)"enter");
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            String query = "select user_pass, status from users_realm";
            query = query + " where user_name = ?";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                n2bbLog.error((Object)"user not found");
                throw new N2bbException("error.securityManager.userNotFound");
            }
            UserSecurityData userSecurityData = new UserSecurityData(name, rs.getString(1), SecurityManager.getStatusString(rs.getInt(2)));
            rs.close();
            pstmt.close();
            query = "select bigRole from user_bigRole";
            query = query + " where user_name = ?";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            userSecurityData.setRole(rs.next() ? rs.getString(1) : NO_ROLE_DEFINED);
            if (rs.next()) {
                n2bbLog.warn((Object)("more than one n2 role assigned to user... " + name));
            }
            UserSecurityData userSecurityData2 = userSecurityData;
            this.closeResultSet(rs);
            this.closeStatement(pstmt);
            this.closeConnection(con);
            return userSecurityData2;
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    public boolean userExists(String name) throws N2bbException {
        n2bbLog.debug((Object)("enter user... " + name));
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean bExists = false;
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            String query = "select * from users_realm where user_name = ?";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            bExists = rs.next();
            rs.close();
            pstmt.close();
            boolean bl = bExists;
            this.closeResultSet(rs);
            this.closeStatement(pstmt);
            this.closeConnection(con);
            return bl;
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    public boolean userExistsForRole(String roleName) throws N2bbException {
        n2bbLog.debug((Object)("userExistsForRole enter " + roleName));
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean bExists = false;
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            String query = "select * from user_bigRole where bigrole = ?";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, roleName);
            rs = pstmt.executeQuery();
            bExists = rs.next();
            rs.close();
            pstmt.close();
            boolean bl = bExists;
            this.closeResultSet(rs);
            this.closeStatement(pstmt);
            this.closeConnection(con);
            return bl;
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    public Set<UserBean> getUserData(String roleName) throws N2bbException {
        n2bbLog.debug((Object)("enter user... " + roleName));
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        HashSet<UserBean> userBeanSet = new HashSet<UserBean>();
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            String query = "SELECT  USER_BIGROLE.USER_NAME,FIRSTNAME,LASTNAME,EMAIL,PHONE,USER_DATA.CREATEDATE,USER_DATA.UPDATEDATE,EMPLOYEEID,DEPARTMENT,LOCATION,EXTENSION FROM USER_BIGROLE , USER_DATA WHERE BIGROLE =? AND USER_BIGROLE.USER_NAME = USER_DATA.USER_NAME ORDER BY UPPER(FIRSTNAME)";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, roleName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                UserBean userBean = new UserBean();
                userBean.setUserName(rs.getString("USER_NAME"));
                userBean.setFirstName(rs.getString("FIRSTNAME"));
                userBean.setLastName(rs.getString("LASTNAME"));
                userBean.setEmail(rs.getString("EMAIL"));
                userBeanSet.add(userBean);
            }
            rs.close();
            pstmt.close();
            this.closeResultSet(rs);
            this.closeStatement(pstmt);
            this.closeConnection(con);
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        return userBeanSet;
    }

    public void toggleUserStatus(String userName) throws N2bbException {
        n2bbLog.debug((Object)("enter user... " + userName));
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            String query = "select status from users_realm where user_name = ?";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, userName);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                n2bbLog.error((Object)"user not found");
                throw new N2bbException("error.securityManager.userNotFound");
            }
            int newStatus = rs.getInt(1) == 1 ? 0 : 1;
            query = "update users_realm set status = ? where user_name = ?";
            pstmt = con.prepareStatement(query);
            pstmt.setInt(1, newStatus);
            pstmt.setString(2, userName);
            pstmt.executeUpdate();
            this.closeStatement(pstmt);
            this.closeConnection(con);
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    public void setPassword(String userName, String pass, boolean encrypt) throws N2bbException {
        n2bbLog.debug((Object)("enter user... " + userName));
        Connection con = null;
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            this.setPassword(userName, pass, encrypt, con);
        }
        catch (Exception e) {
            throw this.wrappedException(e);
        }
        finally {
            this.closeConnection(con);
        }
    }

    public void changeExpiredPassword(String username, String newPassword) throws IdenticalPasswordException, N2bbException {
        Connection con = null;
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            if (this.isPasswordSame(username, newPassword, con)) {
                throw new IdenticalPasswordException();
            }
            this.setPassword(username, newPassword, true, con);
        }
        catch (SQLException e) {
            throw this.wrappedException(e);
        }
        finally {
            this.closeConnection(con);
        }
    }

    private boolean isPasswordSame(String userName, String password, Connection con) throws N2bbException {
        String query = "select USER_NAME from users_realm where user_name = ?  and   user_pass = ?";
        PreparedStatement pstmt = null;
        boolean different = false;
        try {
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, userName);
            pstmt.setString(2, DigestUtil.Digest(password, "SHA"));
            different = pstmt.executeQuery().next();
        }
        catch (SQLException e) {
            throw this.wrappedException(e);
        }
        finally {
            this.closeStatement(pstmt);
        }
        return different;
    }

    public void setPassword(String userName, String pass, boolean encrypt, Connection con) throws N2bbException {
        n2bbLog.debug((Object)("enter user... " + userName));
        PreparedStatement pstmt = null;
        try {
            String query = "update users_realm set user_pass = ?,     PASSWORD_MODIFIED_DATE = ?  where user_name = ?";
            pstmt = con.prepareStatement(query);
            if (encrypt) {
                pstmt.setString(1, DigestUtil.Digest(pass, "SHA"));
            } else {
                pstmt.setString(1, pass);
            }
            pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(3, userName);
            pstmt.executeUpdate();
            pstmt.close();
            this.closeStatement(pstmt);
        }
        catch (Exception e) {
            try {
                throw this.wrappedException(e);
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                throw throwable;
            }
        }
    }

    private N2bbException wrappedException(Exception e) {
        if (e instanceof N2bbException) {
            n2bbLog.error((Object)("n2bb exception - message... " + e.getMessage()), (Throwable)e);
            return (N2bbException)e;
        }
        if (e instanceof SQLException) {
            n2bbLog.error((Object)("SQLException - message... " + e.getMessage()), (Throwable)e);
            return new N2bbException("error.userManager.databaseAccessError");
        }
        n2bbLog.error((Object)e.getMessage(), (Throwable)e);
        return new N2bbException("error.other");
    }

    private static String getStatusString(int statusCode) {
        return statusCode == 1 ? "A" : "I";
    }

    private void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    static {
        moduleAreaLists = Collections.synchronizedList(new LinkedList());
    }
}

