/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.sysmonui.alerts;

import com.n2bb.AlertsModule.Action;
import com.n2bb.AlertsModule.ActionType;
import com.n2bb.AlertsModule.Alert;
import com.n2bb.AlertsModule.AlertData;
import com.n2bb.AlertsModule.AlertHelper;
import com.n2bb.AlertsModule.AlertHistory;
import com.n2bb.AlertsModule.AlertHistoryFilter;
import com.n2bb.AlertsModule.AlertName;
import com.n2bb.AlertsModule.DuplicateAlert;
import com.n2bb.AlertsModule.DuplicateAlertName;
import com.n2bb.AlertsModule.Hertz;
import com.n2bb.AlertsModule.InUse;
import com.n2bb.AlertsModule.NotFound;
import com.n2bb.AlertsModule.UnspecifiedException;
import com.n2bb.sysmonui.alerts.AlertDataBean;
import com.n2bb.sysmonui.alerts.AlertHistoryBean;
import com.n2bb.sysmonui.alerts.AlertPatternBean;
import com.n2bb.util.ClientTimeoutException;
import com.n2bb.util.N2bbException;
import com.n2bb.util.OrbManager;
import java.text.Collator;
import java.util.Date;
import java.util.Locale;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;

public class AlertManager {
    private static Log n2bbLog = LogFactory.getLog(AlertManager.class);
    private static Alert alertFactory = null;

    private static Alert getAlertFactory() throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        if (alertFactory == null) {
            Object obj = null;
            try {
                NameComponent[] nc = new NameComponent[]{new NameComponent("Alerts", "")};
                obj = OrbManager.getInstance().getRootLevelObject(nc);
            }
            catch (N2bbException e) {
                n2bbLog.error((java.lang.Object)("failed to get alert factory - message... " + e.getMessage()), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("failed to get alert factory - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.corba.findFactory");
            }
            if (obj != null) {
                try {
                    alertFactory = AlertHelper.narrow((Object)obj);
                }
                catch (Exception e) {
                    alertFactory = null;
                    n2bbLog.error((java.lang.Object)("failed to narrow alert factory - message... " + e.getMessage()), (Throwable)e);
                    throw new N2bbException("error.corba.narrowFactory");
                }
            } else {
                throw new N2bbException("error.corba.findFactory");
            }
            if (alertFactory == null) {
                n2bbLog.error((java.lang.Object)"alertFactory is null");
                throw new N2bbException("error.corba.factoryNotInitialized");
            }
        }
        return alertFactory;
    }

    public static Vector listAlerts() throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        Vector<AlertDataBean> alertVector = new Vector<AlertDataBean>();
        try {
            AlertData[] alertList = null;
            try {
                alertList = AlertManager.getAlertFactory().listAlerts();
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (NotFound nf) {
                return alertVector;
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("failed to list alerts exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.retrieveList");
            }
            if (alertList.length == 1 && alertList[0] == null) {
                return alertVector;
            }
            for (int j = 0; j < alertList.length; ++j) {
                if (alertList[j] != null) {
                    try {
                        alertVector.add(AlertManager.convertDataToBean(alertList[j]));
                    }
                    catch (N2bbException e) {
                        n2bbLog.error((java.lang.Object)("failed to get an alert exception - message... " + e.getMessage()), (Throwable)e);
                        n2bbLog.error((java.lang.Object)"  skipping this alert");
                    }
                    continue;
                }
                n2bbLog.error((java.lang.Object)("alertData is null at position... " + j));
                n2bbLog.error((java.lang.Object)"  skipping this alert");
            }
        }
        catch (N2bbException e) {
            n2bbLog.error((java.lang.Object)("n2bb exception - message... " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
        return alertVector;
    }

    public static TreeMap getAlertPatternMap() throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        Collator collatorApp = Collator.getInstance(Locale.US);
        TreeMap<java.lang.Object, String> map = new TreeMap<java.lang.Object, String>(collatorApp);
        try {
            AlertName[] names;
            try {
                names = AlertManager.getAlertFactory().getAlertNames();
            }
            catch (NotFound nf) {
                return map;
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (Exception e) {
                throw new N2bbException("error.genericManager.retrieveList");
            }
            if (names.length == 1 && names[0] == null) {
                return map;
            }
            for (int j = 0; j < names.length; ++j) {
                map.put(names[j].name, names[j].type);
            }
        }
        catch (N2bbException e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
        return map;
    }

    public static Vector getAlertPatterns() throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        Vector<AlertPatternBean> namesV = new Vector<AlertPatternBean>();
        try {
            AlertName[] names;
            try {
                names = AlertManager.getAlertFactory().getAlertNames();
            }
            catch (NotFound nf) {
                return namesV;
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("failed to list alert patterns exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.retrieveList");
            }
            if (names.length == 1 && names[0] == null) {
                return namesV;
            }
            for (int j = 0; j < names.length; ++j) {
                namesV.add(new AlertPatternBean(names[j].name, names[j].type));
            }
        }
        catch (N2bbException e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
        return namesV;
    }

    public static void saveAlert(AlertDataBean bean) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            AlertData aData = new AlertData();
            if (bean != null) {
                aData = AlertManager.convertBeanToData(bean);
            } else {
                n2bbLog.error((java.lang.Object)"alertBean is null");
                throw new N2bbException("error.alertManager.nullData");
            }
            try {
                AlertManager.getAlertFactory().defineAlertConfiguration(aData);
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (DuplicateAlert e) {
                n2bbLog.debug((java.lang.Object)("duplicate alert identifier exception - message... " + e.getMessage()));
                throw new N2bbException("error.alertManager.dupAlert");
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("failed to add alert exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.persistItem");
            }
        }
        catch (N2bbException e) {
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }

    public static AlertDataBean getAlert(String alertIdentifier) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        AlertDataBean bean = null;
        try {
            AlertData aData = new AlertData();
            try {
                aData = AlertManager.getAlertFactory().getAlertDetail(alertIdentifier);
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("getAlertDetail failed exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.persistedVersion");
            }
            bean = AlertManager.convertDataToBean(aData);
        }
        catch (N2bbException e) {
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
        return bean;
    }

    public static void updateAlert(AlertDataBean bean) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            AlertData aData = new AlertData();
            try {
                aData = AlertManager.getAlertFactory().getAlertDetail(bean.getAlertIdentifier());
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("getAlertDetail failed exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.persistedVersion");
            }
            if (bean != null) {
                aData = AlertManager.convertBeanToData(bean);
            } else {
                n2bbLog.error((java.lang.Object)"alertBean is null");
                throw new N2bbException("error.alertManager.nullData");
            }
            try {
                AlertManager.getAlertFactory().updateAlertConfiguration(aData);
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("failed to update alert exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.persistItem");
            }
        }
        catch (N2bbException e) {
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }

    public static void deleteAlert(String alertIdentifier) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            try {
                AlertManager.getAlertFactory().deleteAlertConfiguration(alertIdentifier);
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("failed to update alert exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.deleteItem");
            }
        }
        catch (N2bbException e) {
            n2bbLog.error((java.lang.Object)("n2bb exception - message... " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }

    private static AlertDataBean convertDataToBean(AlertData aData) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        AlertDataBean bean = new AlertDataBean();
        try {
            bean.setAlertIdentifier(aData.identifier);
            bean.setAlertPattern(aData.name.name);
            bean.setThresholdCount(aData.threshold.count);
            bean.setThresholdSecs(aData.threshold.seconds);
            bean.setFrequencyCount(aData.frequency.count);
            bean.setFrequencySecs(aData.frequency.seconds);
            String[] actionArray = AlertManager.getAction(aData.action);
            if (actionArray[0] != null) {
                bean.setEmail(actionArray[0]);
            }
            if (actionArray[1] != null) {
                bean.setSNMP(actionArray[1]);
            }
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
        return bean;
    }

    private static AlertData convertBeanToData(AlertDataBean bean) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        AlertData aData = new AlertData();
        try {
            Action action;
            ActionType actionType;
            aData.identifier = bean.getAlertIdentifier();
            AlertName alertName = new AlertName();
            alertName.name = bean.getAlertPattern();
            alertName.type = "";
            aData.name = alertName;
            n2bbLog.debug((java.lang.Object)("Threshold Count... " + bean.getThresholdCount()));
            n2bbLog.debug((java.lang.Object)("Threshold Secs... " + bean.getThresholdSecs()));
            Hertz thresHertz = new Hertz();
            thresHertz.count = bean.getThresholdCount();
            thresHertz.seconds = bean.getThresholdSecs();
            aData.threshold = thresHertz;
            n2bbLog.debug((java.lang.Object)("Frequency Count... " + bean.getFrequencyCount()));
            n2bbLog.debug((java.lang.Object)("Frequency Secs... " + bean.getFrequencySecs()));
            Hertz freqHertz = new Hertz();
            freqHertz.count = bean.getFrequencyCount();
            freqHertz.seconds = bean.getFrequencySecs();
            aData.frequency = freqHertz;
            String email = bean.getEmail();
            String snmp = bean.getSNMP();
            Vector<Action> actions = new Vector<Action>();
            if (email != null && !email.trim().equals("")) {
                n2bbLog.debug((java.lang.Object)("email... '" + email + "'"));
                actionType = ActionType.from_int((int)0);
                action = new Action();
                action.type = actionType;
                action.detail = email;
                actions.addElement(action);
            }
            if (snmp != null && !snmp.trim().equals("")) {
                n2bbLog.debug((java.lang.Object)("snmp... '" + snmp + "'"));
                actionType = ActionType.from_int((int)1);
                action = new Action();
                action.type = actionType;
                action.detail = snmp;
                actions.addElement(action);
            }
            n2bbLog.debug((java.lang.Object)("actions vector... " + actions));
            Action[] actionArray = new Action[actions.size()];
            actionArray = actions.toArray(actionArray);
            n2bbLog.debug((java.lang.Object)("actions array... " + actionArray));
            aData.action = actionArray;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
        return aData;
    }

    private static String[] getAction(Action[] actions) throws N2bbException {
        String email = null;
        String snmp = null;
        try {
            for (int i = 0; i < actions.length; ++i) {
                if (actions[i].type.value() == 0) {
                    email = actions[i].detail;
                    continue;
                }
                if (actions[i].type.value() != 1) continue;
                snmp = actions[i].detail;
            }
            String[] actionArray = new String[]{email, snmp};
            return actionArray;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }

    public static Vector listAlertHistory(Date start, Date end, String identifier, String alertPattern, String action) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        n2bbLog.debug((java.lang.Object)("start... " + start));
        n2bbLog.debug((java.lang.Object)("end... " + end));
        n2bbLog.debug((java.lang.Object)("identifier... " + identifier));
        n2bbLog.debug((java.lang.Object)("alertPattern... " + alertPattern));
        n2bbLog.debug((java.lang.Object)("action... " + action));
        if (start == null && end == null && identifier == null && alertPattern == null && action == null) {
            return AlertManager.listAlertHistory();
        }
        try {
            AlertHistory[] alertList = null;
            AlertHistoryFilter ahf = new AlertHistoryFilter();
            ahf.start = start == null ? -1L : start.getTime();
            ahf.end = end == null ? -1L : end.getTime();
            if (identifier != null) {
                ahf.identifier = identifier;
            }
            if (alertPattern != null) {
                ahf.name = alertPattern;
            }
            if (action != null) {
                ahf.action = action;
            }
            try {
                n2bbLog.debug((java.lang.Object)"getting alert history");
                alertList = AlertManager.getAlertFactory().getAlertHistoryWithFilter(ahf);
                n2bbLog.debug((java.lang.Object)"got alert history");
            }
            catch (N2bbException e) {
                n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (NotFound nf) {
                n2bbLog.debug((java.lang.Object)"no alert history");
                return new Vector();
            }
            catch (NO_RESPONSE e) {
                n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
                throw new N2bbException("error.corba.timeout");
            }
            catch (IMP_LIMIT e) {
                if (e.getMessage() != null && e.getMessage().toLowerCase().indexOf("timeout") != -1) {
                    throw new ClientTimeoutException();
                }
                throw new N2bbException("error.genericManager.retrieveList", (Exception)((java.lang.Object)e));
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("failed to list history exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.retrieveList");
            }
            n2bbLog.debug((java.lang.Object)"populating alert history vector");
            return AlertManager.populateHistoryVector(alertList);
        }
        catch (N2bbException e) {
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }

    public static Vector listAlertHistory() throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            AlertHistory[] alertList = null;
            try {
                alertList = AlertManager.getAlertFactory().getAlertHistory();
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (NotFound nf) {
                return new Vector();
            }
            catch (NO_RESPONSE e) {
                n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
                throw new N2bbException("error.corba.timeout");
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("failed to list history exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.retrieveList");
            }
            return AlertManager.populateHistoryVector(alertList);
        }
        catch (N2bbException e) {
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }

    private static Vector populateHistoryVector(AlertHistory[] alertList) throws Exception {
        n2bbLog.debug((java.lang.Object)"enter");
        Vector<AlertHistoryBean> history = new Vector<AlertHistoryBean>();
        if (alertList.length == 1 && alertList[0] == null) {
            return history;
        }
        for (int j = 0; j < alertList.length; ++j) {
            if (alertList[j] != null) {
                AlertHistoryBean bean = new AlertHistoryBean();
                bean.setAlertIdentifier(alertList[j].identifier);
                bean.setAlertPattern(alertList[j].name.name);
                bean.setTimeLogged(new Date(alertList[j].timestamp));
                String[] actionArray = AlertManager.getAction(alertList[j].action);
                if (actionArray[0] != null) {
                    bean.setEmail(actionArray[0]);
                }
                if (actionArray[1] != null) {
                    bean.setSNMP(actionArray[1]);
                }
                bean.setDescription(alertList[j].detail);
                history.add(bean);
                continue;
            }
            n2bbLog.error((java.lang.Object)("list is null at position... " + j));
            n2bbLog.error((java.lang.Object)"  skipping this alert");
        }
        return history;
    }

    public static TreeSet getAlertHistoryIdentifiers() throws N2bbException {
        Collator collator = Collator.getInstance(Locale.US);
        TreeSet<java.lang.Object> identifiers = new TreeSet<java.lang.Object>(collator);
        try {
            String[] ids = null;
            try {
                ids = AlertManager.getAlertFactory().getAlertHistoryIdentifiers();
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (NotFound nf) {
                return identifiers;
            }
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] == null) continue;
                identifiers.add(ids[i]);
            }
        }
        catch (N2bbException e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
        return identifiers;
    }

    public static TreeSet getAlertHistoryPatterns() throws N2bbException {
        Collator collator = Collator.getInstance(Locale.US);
        TreeSet<java.lang.Object> names = new TreeSet<java.lang.Object>(collator);
        try {
            String[] ids = null;
            try {
                ids = AlertManager.getAlertFactory().getAlertHistoryNames();
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (NotFound nf) {
                return names;
            }
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] == null) continue;
                names.add(ids[i]);
            }
        }
        catch (N2bbException e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
        return names;
    }

    public static void saveAlertPattern(AlertPatternBean bean) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            try {
                AlertManager.getAlertFactory().defineAlertName(new AlertName(bean.getName(), bean.getPattern()));
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (DuplicateAlertName e) {
                n2bbLog.debug((java.lang.Object)("duplicate pattern name exception - message... " + e.getMessage()));
                throw new N2bbException("error.alertManager.dupAlertPattern");
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("failed to add alert exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.persistItem");
            }
        }
        catch (N2bbException e) {
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }

    public static AlertPatternBean getAlertPattern(String name) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        AlertPatternBean bean = null;
        try {
            AlertName aData = new AlertName();
            try {
                aData = AlertManager.getAlertFactory().getAlertName(name);
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("getAlertPattern failed exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.persistedVersion");
            }
            bean = new AlertPatternBean(aData.name, aData.type);
        }
        catch (N2bbException e) {
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
        return bean;
    }

    public static void updateAlertPattern(AlertPatternBean bean) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            AlertName aData = new AlertName();
            try {
                aData = AlertManager.getAlertFactory().getAlertName(bean.getName());
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("getAlertName failed exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.persistedVersion");
            }
            if (bean == null) {
                n2bbLog.error((java.lang.Object)"alertNameBean is null");
                throw new N2bbException("error.alertManager.nullData");
            }
            aData = new AlertName(bean.getName(), bean.getPattern());
            try {
                AlertManager.getAlertFactory().updateAlertName(aData);
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("failed to update alert pattern exception - message... " + e.getMessage()), (Throwable)e);
                throw new N2bbException("error.genericManager.persistItem");
            }
        }
        catch (N2bbException e) {
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }

    public static void deleteAlertPattern(String name) throws N2bbException, InUse, NotFound, UnspecifiedException {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            AlertManager.getAlertFactory().deleteAlertName(name);
        }
        catch (UnspecifiedException e) {
            n2bbLog.error((java.lang.Object)"UnspecifiedException in deleteAlertName", (Throwable)e);
            throw e;
        }
    }

    public static void main(String[] a) {
        try {
            new AlertManager();
            Alert alert = AlertManager.getAlertFactory();
            AlertName[] names = alert.getAlertNames();
            for (int i = 0; i < names.length; ++i) {
                System.out.println(names[i].name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

