/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.sysmonui.alerts;

import com.n2bb.action.AbstractAction;
import com.n2bb.sysmonui.alerts.ListAlertHistoryAction;
import com.n2bb.web.util.ListFilter;
import com.n2bb.web.util.ListPage;
import com.n2bb.web.util.ListPager;
import com.n2bb.web.util.ReportUtil;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ReportAlertHistoryAction
extends AbstractAction {
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)"enter");
        try {
            ListPager pager = ListAlertHistoryAction.getAlertHistoryListPager(request);
            Date startDate = null;
            Date endDate = null;
            String identifier = null;
            String pattern = null;
            String actionTaken = null;
            ListFilter filter = pager.getFilter();
            if (filter != null) {
                startDate = (Date)filter.get("startDate");
                endDate = (Date)filter.get("endDate");
                identifier = (String)filter.get("identifier");
                pattern = (String)filter.get("pattern");
                actionTaken = (String)filter.get("actionTaken");
            }
            if (this.isEmpty(identifier)) {
                identifier = "All";
            }
            if (this.isEmpty(pattern)) {
                pattern = "All";
            }
            if (this.isEmpty(actionTaken)) {
                actionTaken = "All";
            }
            pager.setShowWholeList(true);
            ListPage page = pager.getPage(1);
            List packages = page.getPageData();
            pager.setShowWholeList(false);
            DateFormat dateFormat = DateFormat.getDateInstance();
            String[][] filteredBy = new String[][]{{"Start Date", startDate == null ? "None" : dateFormat.format(startDate)}, {"End Date", endDate == null ? "None" : dateFormat.format(endDate)}, {"Alert Indentifier", identifier}, {"Alert Pattern", pattern}, {"Action Taken", actionTaken}};
            String[] columnDisplayNames = new String[]{"Time Logged", "Alert Identifier", "Alert Pattern", "Action Taken"};
            String[] columnNames = new String[]{"timeLogged", "alertIdentifier", "alertPattern", "actions"};
            String headerName = "Alert History";
            String sort = pager.getSortColumn();
            for (int i = 0; i < columnNames.length; ++i) {
                if (!sort.equals(columnNames[i])) continue;
                sort = columnDisplayNames[i];
            }
            String outputType = request.getParameter("outputType");
            if (outputType == null) {
                outputType = "Excel";
            }
            ReportUtil.generateReport(response, outputType, headerName, filteredBy, sort, columnDisplayNames, columnNames, packages);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().equals("");
    }
}

