/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.AbstractTaskNode;
import com.tandbergtv.workflow.core.ActionDelegation;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.exe.ExecutionContext;

public class AutomaticTaskNode
extends AbstractTaskNode {
    private static final long serialVersionUID = 4614455101092538306L;
    private static final Logger logger = Logger.getLogger(AutomaticTaskNode.class);

    public AutomaticTaskNode() {
    }

    public AutomaticTaskNode(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext executionContext) {
        CustomToken token = (CustomToken)executionContext.getToken();
        WorkflowProcess process = token.getProcessInstance();
        logger.info((Object)(token + " (" + this.name + ")"));
        if (this.action != null) {
            try {
                if (this.action.getActionDelegation() != null) {
                    ActionDelegation delegation = new ActionDelegation(this.action.getActionDelegation());
                    ActionHandler handler = (ActionHandler)delegation.instantiate();
                    if (handler == null) {
                        throw new RuntimeException(token + ", cannot instantiate action");
                    }
                    token.setActionHandler(handler);
                    handler.execute(executionContext);
                } else {
                    this.action.execute(executionContext);
                }
            }
            catch (Throwable t) {
                try {
                    this.raiseException(t, executionContext);
                }
                catch (DelegationException e) {
                    logger.warn((Object)(token + ", no exception handler defined for template - " + process.getProcessDefinition().getName()));
                    token.fail();
                }
            }
            finally {
                token.setActionHandler(null);
            }
        }
        if (token.getStatus() != ProcessStatus.ERROR) {
            super.leave(executionContext);
        }
    }
}

