/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.WFSInterpreter;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.TokenTimer;
import com.tandbergtv.workflow.driver.service.ITimerService;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.DurationUtility;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.scheduler.def.CreateTimerAction;
import org.jbpm.scheduler.exe.Timer;

public class WFSCreateTimerAction
extends CreateTimerAction {
    private Long MIN_TIMEOUT;
    private static final long serialVersionUID = -5891512481051475508L;
    private static final Logger logger = Logger.getLogger(WFSCreateTimerAction.class);

    public WFSCreateTimerAction() {
        try {
            String value = (String)ApplicationProperties.getInstance().get("process.timeout");
            this.MIN_TIMEOUT = Long.parseLong(value) * 1000L;
        }
        catch (Exception e) {
            this.MIN_TIMEOUT = 120000L;
        }
        logger.debug((Object)("Min timeout is " + this.MIN_TIMEOUT));
    }

    public void execute(ExecutionContext context) throws Exception {
        Timer timer = this.createTimer(context);
        ServiceRegistry.getDefault().lookup(ITimerService.class).addTimer(new TokenTimer(timer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Timer createTimer(ExecutionContext context) {
        Token token = context.getToken();
        Timer timer = new Timer(token);
        timer.setName(this.getTimerName());
        timer.setRepeat(this.getRepeat());
        long dueDateinMillisecs = this.getDurationInMillis(this.getDueDate(), context);
        Date timerDueDate = new Date(new Date().getTime() + dueDateinMillisecs);
        logger.info((Object)(token + ", timer due date: " + timerDueDate + ", duration: " + dueDateinMillisecs / 1000L + " sec"));
        timer.setDueDate(timerDueDate);
        timer.setAction(this.getTimerAction());
        timer.setTransitionName(this.getTransitionName());
        timer.setGraphElement(context.getEventSource());
        timer.setTaskInstance(context.getTaskInstance());
        if (this.getEvent() != null && this.getEvent().getGraphElement() != null) {
            GraphElement graphElement = this.getEvent().getGraphElement();
            try {
                context.setTimer(timer);
                graphElement.fireEvent("timer-create", context);
            }
            finally {
                context.setTimer(null);
            }
        }
        return timer;
    }

    private long getDurationInMillis(String duration, ExecutionContext context) {
        long time = 0L;
        try {
            time = new DurationUtility().getDurationInMillis(duration, new WFSInterpreter(context));
        }
        catch (Exception e) {
            logger.warn((Object)(context.getToken() + " could not parse " + duration + " as a valid date."));
        }
        return time < this.MIN_TIMEOUT ? this.MIN_TIMEOUT : time;
    }
}

