/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.Graph;
import com.tandbergtv.workflow.driver.DurationAggregator;
import com.tandbergtv.workflow.driver.IProgressTrackingStrategy;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jbpm.graph.exe.Token;

public final class DefaultProgressTrackingStrategy
implements IProgressTrackingStrategy {
    private Map<Token, String> completion = new WeakHashMap<Token, String>();
    private static IProgressTrackingStrategy instance;
    private static final Lock lock;

    private DefaultProgressTrackingStrategy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IProgressTrackingStrategy getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new DefaultProgressTrackingStrategy();
            }
        }
        finally {
            lock.unlock();
        }
        return instance;
    }

    public Date calculateTime(WorkflowProcess process) {
        Date end = process.getEnd();
        if (end != null) {
            return new Date(end.getTime() - process.getStart().getTime());
        }
        if (process.getProcessDefinition() instanceof Graph) {
            WorkflowTemplate graph = process.getProcessDefinition();
            DurationAggregator visitor = new DurationAggregator(process.getRootToken());
            graph.depthFirstTraversal(visitor);
            return visitor.getDuration();
        }
        return new Date();
    }

    public Date calculateTime(Token token) {
        throw new UnsupportedOperationException();
    }

    public Date calculateMinimumTime(WorkflowProcess instance) {
        return this.calculateTime(instance);
    }

    public Date calculateMinimumTime(Token token) {
        return this.calculateTime(token);
    }

    public Date calculateMaximumTime(WorkflowProcess instance) {
        return this.calculateTime(instance);
    }

    public Date calculateMaximumTime(Token token) {
        return this.calculateTime(token);
    }

    public Date calculateRemainingTime(WorkflowProcess instance) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Date calculateRemainingTime(Token token) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String calculatePercentComplete(Token token) {
        WorkflowProcess process = (WorkflowProcess)token.getProcessInstance();
        if (process.hasEnded()) {
            return "100";
        }
        return this.completion.get(token);
    }

    public void setPercentComplete(Token token, String percent) {
        this.completion.put(token, percent);
    }

    public void setComplete(Token token) {
        this.completion.remove(token);
    }

    static {
        lock = new ReentrantLock();
    }
}

