/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class RangeParameter
extends SearchParameterBase {
    private String from = null;
    private String to = null;

    public RangeParameter(String name) {
        super(name);
    }

    public RangeParameter(String name, SearchType fieldType) {
        super(name, fieldType);
    }

    public RangeParameter(String name, SearchType fieldType, boolean varInstance) {
        super(name, fieldType, varInstance);
    }

    public RangeParameter(String name, SearchType fieldType, String from) {
        this(name, fieldType);
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getPredicate() {
        if (this.getFieldType() == SearchType.STRING) {
            if (this.from == null || this.from.equals("")) {
                return " <= '" + this.to + "'";
            }
            if (this.to == null || this.to.equals("")) {
                return " >= '" + this.from + "'";
            }
            return " between '" + this.from + "' AND '" + this.to + "'";
        }
        if (this.getFieldType() == SearchType.DATE) {
            if (this.from == null || this.from.equals("")) {
                return " < to_date('" + this.getModifiedToDate() + "','" + "yyyy-MM-dd" + "' )";
            }
            if (this.to == null || this.to.equals("")) {
                return " >= to_date('" + this.from + "','" + "yyyy-MM-dd" + "' )";
            }
            return " between to_date('" + this.from + "','" + "yyyy-MM-dd" + "' ) AND to_date('" + this.getModifiedToDate() + "','" + "yyyy-MM-dd" + "' )";
        }
        if (this.from == null || this.from.equals("")) {
            return " <= " + this.to;
        }
        if (this.to == null || this.to.equals("")) {
            return " >= " + this.from;
        }
        return " between " + this.from + " AND " + this.to;
    }

    private String getModifiedToDate() {
        if (this.to == null || this.to.equals("")) {
            return this.to;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        GregorianCalendar c = new GregorianCalendar();
        try {
            c.setTimeInMillis(format.parse(this.to).getTime());
            c.add(5, 1);
            return format.format(c.getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException("Could not evaluate the 'to' date" + this.to, e);
        }
    }
}

