/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.log.events.LogEventWrapper;
import com.tandbergtv.workflow.log.loggers.IWorkflowLogger;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class LogQueueDrainer
implements Runnable {
    private static final Logger appLogger = Logger.getLogger(LogQueueDrainer.class);
    private BlockingQueue<WorkflowEvent> queue = new LinkedBlockingQueue<WorkflowEvent>();
    private List<IWorkflowLogger> loggers;
    private boolean stop;
    private long saved;
    private long delay;
    private long queueDelay;
    private long added;

    public LogQueueDrainer(IWorkflowLogger ... loggers) {
        this.loggers = Arrays.asList(loggers);
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public long getAverageDelay() {
        if (this.saved == 0L) {
            return 0L;
        }
        return this.delay / this.saved;
    }

    public long getAverageQueueDelay() {
        if (this.added == 0L) {
            return 0L;
        }
        return this.queueDelay / this.added;
    }

    public long getAdded() {
        return this.added;
    }

    public void drainEvent(WorkflowEvent event) {
        boolean match = false;
        for (IWorkflowLogger logger : this.loggers) {
            match = match || logger.match(event);
        }
        if (match) {
            this.queue.offer(new LogEventWrapper(new Date(), event));
            ++this.added;
        }
    }

    public void run() {
        appLogger.debug((Object)"Log queue drainer started");
        while (!this.isStop() || !this.queue.isEmpty()) {
            try {
                LogEventWrapper logEvent = (LogEventWrapper)this.queue.take();
                WorkflowEvent event = logEvent.getEvent();
                appLogger.debug((Object)("Log event: " + event));
                this.queueDelay += System.currentTimeMillis() - logEvent.getQueuedDate().getTime();
                this.executeLoggers(event);
            }
            catch (InterruptedException e) {
                appLogger.error((Object)"Interruped exception caught", (Throwable)e);
            }
        }
        appLogger.debug((Object)"Log queue drainer stopped");
    }

    private void executeLoggers(WorkflowEvent logEvent) {
        long start = System.currentTimeMillis();
        for (IWorkflowLogger logger : this.loggers) {
            try {
                appLogger.debug((Object)("Executing logger " + logger.getClass().getSimpleName()));
                logger.execute(logEvent);
                appLogger.debug((Object)("Executed logger " + logger.getClass().getSimpleName()));
            }
            catch (Throwable t) {
                appLogger.error((Object)("Throwable caught in executing the logger: " + logger.getClass().getSimpleName() + " for event: " + logEvent), t);
            }
        }
        ++this.saved;
        long diff = System.currentTimeMillis() - start;
        this.delay += diff;
        appLogger.debug((Object)("Saved " + logEvent.getClass().getSimpleName() + " event in " + (double)diff / 1000.0 + " seconds"));
    }

    public synchronized void stop() {
        this.stop = true;
    }

    public synchronized boolean isStop() {
        return this.stop;
    }
}

