/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message;

import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.message.IMessageRegistry;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.pluginmanager.WatchPointPluginManager;
import com.tandbergtv.workflow.pluginmanager.entities.MessageDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class MessageRegistry
implements IMessageRegistry,
IColleague {
    private Map<String, String> messages = new HashMap<String, String>();
    private static MessageRegistry instance;
    private static final Lock lock;
    private static final Logger logger;

    private MessageRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageRegistry getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new MessageRegistry();
            }
        }
        finally {
            lock.unlock();
        }
        return instance;
    }

    public void initialize() {
        List<ResourceTypeDescriptor> descriptors = WatchPointPluginManager.getInstance().getResourceTypeDescriptors();
        for (ResourceTypeDescriptor descriptor : descriptors) {
            Map<String, MessageDescriptor> messages = descriptor.getMessages();
            Iterator<String> iterator = messages.keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                MessageDescriptor messageDesciptor = messages.get(key);
                this.addMessage(messageDesciptor.getUID(), messageDesciptor.getName());
            }
        }
        logger.info((Object)"Message Registry Initialized successfully.");
    }

    public void destroy() {
        logger.info((Object)"Message Registry destroyed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(String uid, String name) {
        lock.lock();
        try {
            logger.debug((Object)("Adding message with uid " + uid + " and name " + name));
            this.messages.put(uid, name);
        }
        finally {
            lock.unlock();
        }
    }

    public IMessageUID getMessageUID(String uid) {
        if (this.messages.get(uid) == null) {
            return null;
        }
        return new MessageUIDImpl(uid, this.messages.get(uid));
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
    }

    static {
        lock = new ReentrantLock();
        logger = Logger.getLogger(MessageRegistry.class);
    }
}

