/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.messageprocessor;

import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.messageprocessor.CommandException;
import com.tandbergtv.workflow.messageprocessor.ICommand;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class CommandManager {
    private static Logger logger = Logger.getLogger(CommandManager.class);
    private static final String BUNDLE_NAME = CommandManager.class.getPackage().getName() + ".command";

    public static WorkflowMessage createAndExecute(WorkflowMessage message) {
        WorkflowMessage response = null;
        WPCLCommand command = WPCLCommand.NULL;
        if (message.getCommand() != null) {
            command = message.getCommand();
        }
        try {
            String className = ResourceBundle.getBundle(BUNDLE_NAME).getString(command.getName().toLowerCase());
            logger.debug((Object)("Executing command : " + className));
            response = ((ICommand)Class.forName(className).newInstance()).execute(message);
        }
        catch (Exception ex) {
            throw new CommandException("Error executing command " + command + " for message " + message.getMessageUID(), ex);
        }
        return response;
    }
}

