/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.messageprocessor;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.log.events.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.messageprocessor.AbstractCommand;
import com.tandbergtv.workflow.messageprocessor.templateselector.IPrioritySelector;
import com.tandbergtv.workflow.messageprocessor.templateselector.ITemplateSelector;
import com.tandbergtv.workflow.messageprocessor.templateselector.SelectorOutput;
import com.tandbergtv.workflow.messageprocessor.templateselector.TemplateSelectionException;
import com.tandbergtv.workflow.messageprocessor.templateselector.TemplateSelectorFactory;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.ClientExtensionClassLoader;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreateCommand
extends AbstractCommand {
    private static final Logger logger = Logger.getLogger(CreateCommand.class);
    private static final String NEW_LINE = System.getProperty("line.separator");

    public WorkflowMessage execute(WorkflowMessage message) {
        TemplateSelectorFactory factory = TemplateSelectorFactory.createInstance();
        String className = message.getCommand().getParameterValue("selector");
        List<SelectorOutput> selections = null;
        try {
            ITemplateSelector selector = factory.getTemplateSelector(className);
            logger.debug((Object)("Template selector class name: " + selector.getClass().getName()));
            selections = selector.selectTemplates(message);
            if (selections == null) {
                throw new TemplateSelectionException("No templates were selected");
            }
        }
        catch (TemplateSelectionException e) {
            logger.error((Object)("Failed to instantiate Work Order for message [" + message.getMessageUID() + "]"), (Throwable)e);
            return this.createErrorResponse("Failed to create work order(s): " + e.getMessage(), message);
        }
        String errors = "Failed to create work order for key(s):" + NEW_LINE;
        boolean failed = false;
        for (SelectorOutput selection : selections) {
            try {
                this.create(selection, message);
            }
            catch (Exception t) {
                failed = true;
                errors = errors + selection.getSelectionKey() + " - " + t.getMessage() + NEW_LINE;
                logger.error((Object)("Failed to instantiate Work Order for message [" + message.getMessageUID() + "]"), (Throwable)t);
            }
        }
        if (failed) {
            return this.createErrorResponse(errors, message);
        }
        WorkflowMessage response = this.createSuccessResponse(message);
        response.setPayload(message.getPayload());
        return response;
    }

    private void create(SelectorOutput selection, WorkflowMessage message) throws Exception {
        String key = selection.getSelectionKey();
        if (key == null) {
            throw new TemplateSelectionException("Template selector did not specify a key");
        }
        logger.debug((Object)("Selection key: " + key));
        ServiceRegistry registry = ServiceRegistry.getDefault();
        IProcessManagerService service = registry.lookup(IProcessManagerService.class);
        WorkflowTemplate definition = registry.lookup(ITemplateLoaderService.class).getTemplateBySelectorKey(key);
        ProcessPriority priority = this.getPriority(selection, message);
        Map<String, Object> variables = selection.getTemplateVariables();
        CustomToken token = service.create(definition, priority, variables);
        logger.info((Object)("Auto-started Work Order " + token + " for template selection key: " + key));
        DefaultMediator.getInstance().send(new WorkflowMessageLogEvent(token, definition.getStartState(), true, message));
        service.start(token);
    }

    private ProcessPriority getPriority(SelectorOutput selection, WorkflowMessage message) {
        ProcessPriority priority = null;
        String priorityValue = message.getCommand().getParameterValue("priority");
        String className = message.getCommand().getParameterValue("prioritySelector");
        logger.debug((Object)("Priority value from message: " + priorityValue));
        logger.debug((Object)("Priority selector class name: " + className));
        if (priorityValue != null && !priorityValue.trim().equals("")) {
            try {
                priority = ProcessPriority.valueOf(priorityValue.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)("Failed to get priority - " + priorityValue + " is not a valid priority"));
            }
        } else if (className != null && !className.trim().equals("")) {
            try {
                priority = this.getPrioritySelector(className).getPriority(selection, message);
                logger.debug((Object)("Priority selected by " + className + ": " + (Object)((Object)priority)));
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to get priority - " + e.getMessage()), (Throwable)e);
            }
        }
        if (priority == null) {
            logger.debug((Object)"Defaulting to normal priority");
            priority = ProcessPriority.NORMAL;
        }
        return priority;
    }

    private IPrioritySelector getPrioritySelector(String className) throws Exception {
        String dir = ApplicationProperties.getInstance().getProperty("clientClassesDirectory");
        ClientExtensionClassLoader loader = new ClientExtensionClassLoader(dir, this.getClass().getClassLoader());
        Class<?> clazz = loader.loadClass(className);
        Object obj = clazz.newInstance();
        return (IPrioritySelector)obj;
    }
}

