/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceManagerContext;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import org.apache.log4j.Logger;

final class ResourceStateManager {
    private static final Logger logger = Logger.getLogger(ResourceStateManager.class);
    private ResourceManagerContext context;

    ResourceStateManager(ResourceManagerContext context) {
        this.context = context;
    }

    boolean initializeResource(ResourceContainer container) {
        boolean stateChanged = false;
        Resource resource = container.getResource();
        ResourceState opState = resource.getOperationalState();
        ResourceState adminState = resource.getAdministrationState();
        if (!(ResourceState.ONLINE != adminState && resource.getUserCount() <= 0 || ResourceState.OFFLINE != opState && ResourceState.HEARTBEAT_ERROR != opState)) {
            this.logStateChange(resource, ResourceState.INITIALIZING);
            resource.setOperationalState(ResourceState.INITIALIZING);
            stateChanged = true;
            if (container.getInitializationStrategy() != null) {
                container.getInitializationStrategy().initializeResource();
            } else {
                this.completeInitialization(container);
            }
        }
        return stateChanged;
    }

    private boolean completeInitialization(ResourceContainer container) {
        boolean stateChanged = false;
        Resource resource = container.getResource();
        if (container.getInitializationStrategy() != null) {
            container.getInitializationStrategy().stopInitializingResource();
        }
        if (ResourceState.INITIALIZING == resource.getOperationalState()) {
            this.logStateChange(resource, ResourceState.ONLINE);
            resource.setOperationalState(ResourceState.ONLINE);
            stateChanged = true;
            if (container.getHeartBeatStrategy() != null) {
                container.getHeartBeatStrategy().startHeartBeatMonitor();
            }
            this.context.queueManager.notifyQueuesByResource(resource.getId());
        }
        return stateChanged;
    }

    boolean tryTakeResourceOffline(ResourceContainer container) {
        boolean stateChanged = false;
        Resource resource = container.getResource();
        if (ResourceState.OFFLINE == resource.getAdministrationState() && ResourceState.OFFLINE != resource.getOperationalState() && ResourceState.INACTIVE != resource.getOperationalState() && ResourceState.INVALID != resource.getOperationalState() && resource.getUserCount() == 0) {
            stateChanged = this.takeResourceOffline(container);
        }
        return stateChanged;
    }

    boolean takeResourceOffline(ResourceContainer container) {
        Resource resource = container.getResource();
        if (container.getInitializationStrategy() != null && container.getInitializationStrategy().isInitializing()) {
            container.getInitializationStrategy().stopInitializingResource();
        }
        if (container.getHeartBeatStrategy() != null && container.getHeartBeatStrategy().isMonitoringHeartBeats()) {
            container.getHeartBeatStrategy().stopHeartBeatMonitor();
        }
        this.logStateChange(resource, ResourceState.OFFLINE);
        resource.setOperationalState(ResourceState.OFFLINE);
        return true;
    }

    boolean handleInitializationSuccess(ResourceContainer container) {
        boolean stateChanged = false;
        if (container != null) {
            stateChanged = this.completeInitialization(container);
        }
        return stateChanged;
    }

    boolean handleInitializationFailure(ResourceContainer container) {
        boolean stateChanged = false;
        if (container != null) {
            Resource resource;
            if (container.getInitializationStrategy() != null) {
                container.getInitializationStrategy().stopInitializingResource();
            }
            if (ResourceState.INITIALIZING == (resource = container.getResource()).getOperationalState()) {
                this.logStateChange(resource, ResourceState.INITIALIZATION_ERROR);
                resource.setOperationalState(ResourceState.INITIALIZATION_ERROR);
                stateChanged = true;
            }
        }
        return stateChanged;
    }

    boolean handleHeartBeatSuccess(ResourceContainer container) {
        Resource resource;
        boolean stateChanged = false;
        if (container != null && ResourceState.HEARTBEAT_ERROR == (resource = container.getResource()).getOperationalState()) {
            if (container.getHeartBeatStrategy() != null && container.getHeartBeatStrategy().isMonitoringHeartBeats()) {
                container.getHeartBeatStrategy().stopHeartBeatMonitor();
            }
            stateChanged = this.initializeResource(container);
        }
        return stateChanged;
    }

    boolean handleHeartBeatFailure(ResourceContainer container) {
        Resource resource;
        boolean stateChanged = false;
        if (container != null && ResourceState.ONLINE == (resource = container.getResource()).getOperationalState()) {
            this.logStateChange(resource, ResourceState.HEARTBEAT_ERROR);
            resource.setOperationalState(ResourceState.HEARTBEAT_ERROR);
            stateChanged = true;
        }
        return stateChanged;
    }

    boolean failResource(ResourceContainer container) {
        Resource resource;
        boolean stateChanged = false;
        if (container != null && (resource = container.getResource()).getOperationalState() != ResourceState.OFFLINE) {
            this.logStateChange(resource, ResourceState.ERROR);
            resource.setOperationalState(ResourceState.ERROR);
            stateChanged = true;
        }
        return stateChanged;
    }

    private void logStateChange(Resource resource, ResourceState newState) {
        if (resource.getOperationalState() == newState) {
            return;
        }
        logger.info((Object)("[Resource #" + resource.getId() + "]: " + resource.getName() + ": " + resource.getOperationalState().getStateName() + " -> " + newState.getStateName()));
    }
}

