/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.entities;

import com.tandbergtv.workflow.resourcemanager.entities.ResourceEntity;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueueItem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroupQueue
implements ResourceEntity {
    private static final long serialVersionUID = -5418538065738959637L;
    private ResourceGroup parentGroup;
    private List<ResourceGroupQueueItem> queue = new ArrayList<ResourceGroupQueueItem>();

    public ResourceGroupQueue() {
    }

    public ResourceGroupQueue(ResourceGroup parent) {
        this.parentGroup = parent;
    }

    public ResourceGroup getResourceGroup() {
        return this.parentGroup;
    }

    public void setResourceGroup(ResourceGroup resourceGroup) {
        this.parentGroup = resourceGroup;
        if (this.queue != null) {
            for (ResourceGroupQueueItem item : this.queue) {
                item.setResourceGroup(resourceGroup);
            }
        }
    }

    public List<ResourceGroupQueueItem> getQueuedItems() {
        return this.queue;
    }

    public void setQueuedItems(List<ResourceGroupQueueItem> queuedItems) {
        this.queue = queuedItems;
    }

    @Override
    public Object clone() {
        ResourceGroupQueue clone = null;
        try {
            clone = (ResourceGroupQueue)super.clone();
            if (this.queue != null) {
                clone.queue = new ArrayList<ResourceGroupQueueItem>();
                for (ResourceGroupQueueItem item : this.queue) {
                    ResourceGroupQueueItem cloneItem = (ResourceGroupQueueItem)item.clone();
                    clone.queue.add(cloneItem);
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

