/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ApplicationProperties
extends Properties {
    private static final long serialVersionUID = -2440412148987996833L;
    private static final Logger logger = Logger.getLogger(ApplicationProperties.class);
    private static final String PROPERTIES_FILE_PATH = "/application.properties";
    private static ApplicationProperties m_Instance;

    private ApplicationProperties() throws InvalidPropertiesFormatException, IOException {
        this.loadProperties();
        this.createConfigPathFolder();
    }

    public static synchronized ApplicationProperties getInstance() throws InvalidPropertiesFormatException, IOException {
        if (m_Instance == null) {
            m_Instance = new ApplicationProperties();
        }
        return m_Instance;
    }

    private void loadProperties() throws InvalidPropertiesFormatException, IOException {
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE_PATH);
        this.loadFromXML(inStream);
    }

    private void createConfigPathFolder() {
        String configPath = this.getProperty("WorkflowApp.ConfigPath");
        if (configPath != null && configPath.trim().length() > 0) {
            File file = new File(configPath);
            try {
                if (!file.exists()) {
                    file.mkdirs();
                }
                logger.debug((Object)("The Workflow System configuration folder: " + file.getAbsolutePath() + " exists."));
            }
            catch (Exception ex) {
                String msg = "Failed to create the Workflow System configuration folder: " + file.getAbsolutePath();
                logger.error((Object)msg, (Throwable)ex);
            }
        } else {
            String msg = "The Workflow System configuration folder is not configured in the Application Properties, please enter a value for key: WorkflowApp.ConfigPath";
            logger.warn((Object)msg);
        }
    }
}

