/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientExtensionClassLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(ClientExtensionClassLoader.class);
    private String dir;

    public ClientExtensionClassLoader(String dir, ClassLoader parent) {
        super(parent);
        this.dir = dir;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.dir == null || this.dir.trim().equals("")) {
            String errorMessage = "Invalid directory. | Dir: [" + this.dir + "]";
            logger.error((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        if (!new File(this.dir.trim()).isDirectory()) {
            String errorMessage = "Not a directory or Directory does not exist. | Dir: [" + this.dir + "]";
            logger.error((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        this.dir = this.dir.trim();
        byte[] data = this.getClassData(this.dir, name);
        if (data == null) {
            throw new ClassNotFoundException(name);
        }
        Class<?> c = this.defineClass(name, data, 0, data.length);
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    private byte[] getClassData(String dir, String className) {
        className = className.replace('.', '/') + ".class";
        logger.debug((Object)("Dir: " + dir + " | Class: " + className));
        File[] jarFiles = this.getJarFiles(dir);
        if (jarFiles != null) {
            for (File jarFile : jarFiles) {
                JarFile jf;
                logger.debug((Object)("Examining file: " + jarFile));
                try {
                    jf = new JarFile(jarFile);
                }
                catch (IOException e) {
                    logger.warn((Object)("Ignoring file: " + jarFile), (Throwable)e);
                    continue;
                }
                logger.debug((Object)("Jar File Name: " + jf.getName()));
                JarEntry jarEntry = jf.getJarEntry(className);
                if (jarEntry == null) continue;
                long size = jarEntry.getSize();
                if (size == -1L) {
                    logger.error((Object)("Size not obtainable | Jar File Name: " + jf.getName() + " | Jar File Entry: " + jarEntry));
                    return null;
                }
                logger.debug((Object)("Jar File Entry: " + jarEntry + " | Size: " + size));
                byte[] data = null;
                try {
                    data = this.getBytes(jf.getInputStream(jarEntry), size);
                }
                catch (IOException e) {
                    logger.error((Object)("Error in getting data from jar entry. Jar File Name: " + jf.getName() + " | Jar File Entry: " + jarEntry), (Throwable)e);
                }
                return data;
            }
        } else {
            logger.warn((Object)("Dir: " + dir + " does not exist or No files with extension \".jar\" found in the directory"));
        }
        return null;
    }

    private File[] getJarFiles(String dir) {
        File f = new File(dir);
        return f.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
    }

    private byte[] getBytes(InputStream is, long size) throws IOException {
        if (size > Integer.MAX_VALUE) {
            logger.error((Object)"File Too Big | Size of the file is larger than Integer.MAX_VALUE [2147483647]");
            return null;
        }
        byte[] buffer = new byte[(int)size];
        new DataInputStream(is).readFully(buffer);
        return buffer;
    }
}

