/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueManager<O> {
    private static final Logger logger = Logger.getLogger(QueueManager.class);
    private final LinkedList<O> queue = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(O o) {
        LinkedList<O> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(o);
            logger.debug((Object)("After pushing queue size: " + this.queue.size()));
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public O pop() throws InterruptedException {
        LinkedList<O> linkedList = this.queue;
        synchronized (linkedList) {
            logger.debug((Object)("Is queue empty: " + this.queue.isEmpty()));
            while (this.queue.isEmpty()) {
                this.queue.wait();
            }
            return this.queue.removeFirst();
        }
    }

    public int size() {
        return this.queue.size();
    }
}

