/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.actions;

import com.tandbergtv.workflow.sanmanager.SANManagement;
import com.tandbergtv.workflow.sanmanager.SANManagementException;
import com.tandbergtv.workflow.sanmanager.SANManager;
import com.tandbergtv.workflow.sanmanager.dto.SANFile;
import com.tandbergtv.workflow.sanmanager.dto.SANFolder;
import com.tandbergtv.workflow.sanmanager.entities.SANDrive;
import com.tandbergtv.workflow.web.actions.BaseDispatchAction;
import com.tandbergtv.workflow.web.entities.santree.ISANTreeNode;
import com.tandbergtv.workflow.web.entities.santree.SANTreeNode;
import com.tandbergtv.workflow.web.formbeans.RepositoryFile;
import com.tandbergtv.workflow.web.formbeans.RepositoryForm;
import com.tandbergtv.workflow.web.repositorybrowser.RepositoryBrowserConfig;
import com.tandbergtv.workflow.web.util.CommonUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.webtree.TreeData;
import org.webtree.TreeNode;
import org.webtree.TreeView;
import org.webtree.data.SimpleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryBrowsingDispatchAction
extends BaseDispatchAction {
    private static final Logger logger = Logger.getLogger(RepositoryBrowsingDispatchAction.class);
    private static final String FORWARD_TO_REPOSITORY_BROWSING = "repositoryBrowsing";
    private SANManagement sanManagement = SANManager.getInstance();

    public ActionForward getRepository(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TreeNode rootNode;
        RepositoryForm repositoryForm = (RepositoryForm)actionForm;
        HttpSession session = request.getSession();
        String strSelectedNodeId = "";
        ArrayList<RepositoryFile> files = new ArrayList();
        TreeData rootData = (TreeData)session.getAttribute("data");
        TreeView treeView = (TreeView)session.getAttribute("view");
        TreeNode treeNode = rootNode = rootData != null ? rootData.getRoot() : null;
        if (request.getParameter("expand") != null) {
            strSelectedNodeId = request.getParameter("expand");
            logger.debug((Object)("User selected 'Expand' operation for SAN Tree Node: " + strSelectedNodeId));
            if (!this.isRootNode(strSelectedNodeId)) {
                ISANTreeNode node = (ISANTreeNode)this.getNode(rootNode, strSelectedNodeId);
                if (!this.isNodeOpen(request, strSelectedNodeId) && node != null) {
                    this.setSelectedNode(request, node.getId());
                    node = this.getTree(node);
                }
                if (!this.isRootNode(node)) {
                    files = this.getFiles(node);
                    repositoryForm.setFiles(files);
                }
            } else {
                rootNode = this.getRootNode();
                rootData = new SimpleData(rootNode);
                strSelectedNodeId = rootNode.getId();
                this.setSelectedNode(request, rootNode.getId());
            }
            session.setAttribute("data", (Object)rootData);
        } else if (request.getParameter("collapse") != null) {
            strSelectedNodeId = request.getParameter("collapse");
            logger.debug((Object)("User selected 'Collapse' operation for SAN Tree Node: " + strSelectedNodeId));
            ISANTreeNode node = (ISANTreeNode)this.getNode(rootNode, strSelectedNodeId);
            if (node != null) {
                this.removeOpenNodesFromView(node, treeView);
                node.removeAllSANChildren();
                this.setSelectedNode(request, node.getId());
                if (!this.isRootNode(node)) {
                    files = this.getFiles(node);
                    repositoryForm.setFiles(files);
                }
            }
            session.setAttribute("view", (Object)treeView);
            session.setAttribute("data", (Object)rootData);
        } else if (request.getParameter("select") != null) {
            strSelectedNodeId = request.getParameter("select");
            ISANTreeNode node = (ISANTreeNode)this.getNode(rootNode, strSelectedNodeId);
            if (node != null) {
                if (!this.isRootNode(node)) {
                    files = this.getFiles(node);
                    repositoryForm.setFiles(files);
                    if (!this.isNodeOpen(request, strSelectedNodeId)) {
                        this.setSelectedNode(request, node.getId());
                        node = this.getTree(node);
                        treeView.addOpenNode(node.getId());
                    }
                } else if (!this.isNodeOpen(request, strSelectedNodeId)) {
                    rootNode = this.getRootNode();
                    rootData = new SimpleData(rootNode);
                    strSelectedNodeId = rootNode.getId();
                    this.setSelectedNode(request, rootNode.getId());
                    treeView.addOpenNode(node.getId());
                }
            }
            session.setAttribute("data", (Object)rootData);
            session.setAttribute("view", (Object)treeView);
        } else {
            if (rootData != null) {
                if (rootNode != null) {
                    this.removeOpenNodesFromView(rootNode, treeView);
                    ((ISANTreeNode)rootNode).removeAllSANChildren();
                }
                session.setAttribute("view", (Object)treeView);
            }
            rootNode = this.getRootNode();
            SimpleData data = new SimpleData(rootNode);
            strSelectedNodeId = rootNode.getId();
            this.setSelectedNode(request, rootNode.getId());
            session.setAttribute("data", (Object)data);
        }
        repositoryForm.setCurrentPath(strSelectedNodeId);
        return actionMapping.findForward(FORWARD_TO_REPOSITORY_BROWSING);
    }

    private ISANTreeNode getRootNode() throws SANManagementException {
        List<SANDrive> sanDrives = this.sanManagement.getAllSANDrives();
        SANTreeNode rootNode = new SANTreeNode("Content Repository", "Content Repository", sanDrives.size());
        String msg = "Browser Repository - SAN Drive Listing: ";
        for (SANDrive drive : sanDrives) {
            msg = msg + "\n\tSAN Drive Name && Path: " + drive.getName() + "::" + drive.getPath();
            SANTreeNode driveNode = new SANTreeNode(drive.getPath(), drive.getName(), 1);
            rootNode.addSANChildNode(driveNode);
        }
        logger.debug((Object)msg);
        return rootNode;
    }

    private ISANTreeNode getTree(ISANTreeNode treeNode) throws SANManagementException {
        List<SANFolder> folders = this.sanManagement.getFolderListing(treeNode.getId());
        treeNode.removeAllSANChildren();
        for (SANFolder folder : folders) {
            SANTreeNode childNode = new SANTreeNode(folder.getAbsolutePath(), folder.getName(), folder.getChildFolderCount());
            treeNode.addSANChildNode(childNode);
        }
        return treeNode;
    }

    private TreeNode getNode(TreeNode treeNode, String nodeId) {
        if (treeNode.getId().equals(nodeId)) {
            return treeNode;
        }
        TreeNode[] children = treeNode.getChildren();
        for (int i = 0; i < children.length; ++i) {
            TreeNode childMatch = this.getNode(children[i], nodeId);
            if (childMatch == null) continue;
            return childMatch;
        }
        return null;
    }

    private void removeOpenNodesFromView(TreeNode treeNode, TreeView treeView) {
        int i;
        TreeNode[] children = treeNode.getChildren();
        for (i = 0; i < children.length; ++i) {
            treeView.removeOpenNode(children[i].getId());
        }
        for (i = 0; i < children.length; ++i) {
            this.removeOpenNodesFromView(children[i], treeView);
        }
    }

    private List<RepositoryFile> getFiles(TreeNode treeNode) throws Exception {
        List<SANFile> files = this.sanManagement.getFileListing(treeNode.getId());
        boolean linkEnabled = RepositoryBrowserConfig.getInstance().isLinkEnabled(treeNode.getId());
        ArrayList<RepositoryFile> repositoryFiles = new ArrayList<RepositoryFile>();
        for (SANFile file : files) {
            RepositoryFile repositoryFile = new RepositoryFile();
            repositoryFile.setName(file.getName());
            repositoryFile.setSize(file.getLength());
            repositoryFile.setModifiedDate(CommonUtils.formatTime(new Date(file.getLastModified())));
            if (linkEnabled) {
                repositoryFile.setSearchURL(RepositoryBrowserConfig.getInstance().getSearchURL(file.getAbsolutePath()));
            }
            repositoryFiles.add(repositoryFile);
        }
        return repositoryFiles;
    }

    private boolean isNodeOpen(HttpServletRequest request, String nodeId) {
        String[] openNodeIds;
        boolean isOpen = false;
        if (nodeId == null) {
            return isOpen;
        }
        TreeView treeView = (TreeView)request.getSession().getAttribute("view");
        for (String openNodeId : openNodeIds = treeView.getOpenNodes()) {
            if (!openNodeId.equals(nodeId)) continue;
            isOpen = true;
            break;
        }
        return isOpen;
    }

    private void setSelectedNode(HttpServletRequest request, String nodeId) {
        HttpSession session = request.getSession();
        TreeView treeView = (TreeView)session.getAttribute("view");
        if (treeView != null) {
            treeView.removeSelectedNodes();
            treeView.addSelectedNode(nodeId);
            session.setAttribute("view", (Object)treeView);
        }
    }

    private boolean isRootNode(TreeNode node) {
        String nodeId = node != null ? node.getId() : null;
        return this.isRootNode(nodeId);
    }

    private boolean isRootNode(String nodeId) {
        return nodeId != null && nodeId.equalsIgnoreCase("Content Repository");
    }
}

