/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.actions;

import com.n2bb.security.SecurityManager;
import com.n2bb.security.UserSecurityData;
import com.n2bb.util.N2bbException;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.EngineDriver;
import com.tandbergtv.workflow.driver.IProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueueItem;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import com.tandbergtv.workflow.web.actions.BaseDispatchAction;
import com.tandbergtv.workflow.web.entities.QueuedWorkOrderDisplay;
import com.tandbergtv.workflow.web.entities.ResourceDisplay;
import com.tandbergtv.workflow.web.entities.ResourceFormComparator;
import com.tandbergtv.workflow.web.entities.ResourceGroupDisplay;
import com.tandbergtv.workflow.web.entities.ResourceUsageDisplay;
import com.tandbergtv.workflow.web.entities.ResourceUsageDisplayComparator;
import com.tandbergtv.workflow.web.formbeans.AllResourcesForm;
import com.tandbergtv.workflow.web.formbeans.ResourceForm;
import com.tandbergtv.workflow.web.formbeans.ResourceGroupQueueForm;
import com.tandbergtv.workflow.web.formbeans.ResourceUsageForm;
import com.tandbergtv.workflow.web.formbeans.ResourcesListForm;
import com.tandbergtv.workflow.web.table.TableConfig;
import com.tandbergtv.workflow.web.util.CommonUtils;
import com.tandbergtv.workflow.web.util.ExportUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class ResourceDispatchAction
extends BaseDispatchAction {
    private static final Logger logger = Logger.getLogger(ResourceDispatchAction.class);
    private static final String DISPLAY_MESSAGE = "resource.update.messages";
    private static final String DISPLAY_ERRORS = "resource.update.errors";
    private static final String QUEUE_TABLE_ID = "ResourceGroupQueueTable";
    private static final String USER_INACTIVE_STATUS = "I";
    private static final String RG_Q_SHOWINDASHBOARD_CHECKED = "resourceGroupQueue.showInDashboard.checked";
    private static final String RG_Q_SHOWINDASHBOARD_UNCHECKED = "resourceGroupQueue.showInDashboard.unChecked";
    private ResourceManagement resourceManager;
    private ResourceGroupQueueForm resourceGroupQueueForm = new ResourceGroupQueueForm();

    public ResourceDispatchAction() {
        this.resourceManager = ResourceManager.getInstance();
    }

    public ActionForward createResource(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block7: {
            logger.debug((Object)"Starting------>");
            try {
                ResourceForm resourceForm = (ResourceForm)actionForm;
                ResourceType resourceType = this.resourceManager.getResourceType(Long.parseLong(resourceForm.getResourceTypeId()));
                if ("04".equals(resourceType.getSystemId())) {
                    String userName = resourceForm.getUserName();
                    try {
                        SecurityManager securityManager = SecurityManager.getInstance();
                        UserSecurityData userData = securityManager.getUserSecurityData(userName);
                        if (USER_INACTIVE_STATUS.equals(userData.getStatus())) {
                            resourceForm.setAdminStatus(ResourceState.OFFLINE.getStateName());
                        }
                    }
                    catch (N2bbException ex) {
                        String msg = "Failed to get information for the user: " + userName;
                        throw new RuntimeException(msg, ex);
                    }
                }
                Resource resource = new Resource();
                resource = this.prepareResource(resourceForm, resource, request);
                resource = this.resourceManager.createResource(resource);
                resourceForm.setId(String.valueOf(resource.getId()));
                request.setAttribute("resourceCreated", (Object)"resourceCreated");
                request.setAttribute("OUTPUT", (Object)resourceForm);
            }
            catch (ValidationException validationException) {
                List<String> alErrorCodes = validationException.getErrorCodes();
                if (alErrorCodes == null || alErrorCodes.size() <= 0) break block7;
                ActionMessages actionMessages = new ActionMessages();
                for (String errorCode : alErrorCodes) {
                    actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(errorCode, true));
                }
                this.saveMessages(request, actionMessages);
                return actionMapping.findForward("createResource");
            }
        }
        logger.debug((Object)"Ending------>");
        return actionMapping.findForward("postCreateResource");
    }

    public ActionForward updateResource(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block3: {
            try {
                ResourceForm resourceForm = (ResourceForm)actionForm;
                Resource resource = new Resource(Long.parseLong(resourceForm.getId()));
                this.prepareResource(resourceForm, resource, request);
                resource = this.resourceManager.updateResource(resource);
                resourceForm.setId(String.valueOf(resource.getId()));
                request.setAttribute("resourceUpdated", (Object)"resourceUpdated");
                request.setAttribute("OUTPUT", (Object)resourceForm);
            }
            catch (ValidationException validationException) {
                ArrayList alErrorCodes = (ArrayList)validationException.getErrorCodes();
                logger.debug((Object)("Error codes-->" + alErrorCodes));
                if (alErrorCodes == null || alErrorCodes.size() <= 0) break block3;
                ActionMessages actionMessages = new ActionMessages();
                for (String errorCode : alErrorCodes) {
                    actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(errorCode, true));
                }
                this.saveMessages(request, actionMessages);
                return actionMapping.findForward("createResource");
            }
        }
        return actionMapping.findForward("postCreateResource");
    }

    public ActionForward deleteResources(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceForm resourceForm = (ResourceForm)actionForm;
        String[] strResourceIds = resourceForm.getSelectedResources();
        logger.debug((Object)("Total Resources selected for delete --> " + strResourceIds.length));
        ActionMessages messages = new ActionMessages();
        for (int i = 0; i < strResourceIds.length; ++i) {
            Resource resource = this.resourceManager.getResource(Long.parseLong(strResourceIds[i]));
            try {
                boolean isDeleted = this.resourceManager.deleteResource(Long.parseLong(strResourceIds[i]));
                logger.debug((Object)("The resource [" + strResourceIds[i] + "] is deleted -->" + isDeleted));
                messages.add("infoMessages", new ActionMessage(DISPLAY_MESSAGE, (Object)("Resource [" + resource.getId() + "] name: [" + resource.getName() + "] deleted successfully")));
                continue;
            }
            catch (Exception exception) {
                messages.add("errorMessages", new ActionMessage(DISPLAY_ERRORS, (Object)("Resource [" + resource.getId() + "] name: [" + resource.getName() + "] cannot be deleted")));
            }
        }
        this.saveErrors(request, messages);
        this.saveMessages(request, messages);
        return actionMapping.findForward("deleteResources");
    }

    public ActionForward getResourcesList(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean exportFlag = false;
        exportFlag = request.getParameter("exportData") != null && request.getParameter("exportData").toString().equals("export");
        ResourcesListForm resourcesListForm = (ResourcesListForm)actionForm;
        SearchCriteria searchCriteria = resourcesListForm.getSearchCriteria();
        logger.debug((Object)("The Search Criteria--->" + searchCriteria));
        ArrayList<ResourceForm> resources = new ArrayList<ResourceForm>();
        if (exportFlag) {
            searchCriteria.setStartingRecordNumber(0);
            searchCriteria.setRecordsCount(Integer.MAX_VALUE);
        }
        List<Resource> lsResources = this.resourceManager.getResourcesBySearchCriteria(searchCriteria);
        ResourceForm resourceForm = null;
        for (Resource resource : lsResources) {
            logger.debug((Object)("Resource Name is---->" + resource.getName()));
            resourceForm = new ResourceForm();
            resourceForm = this.prepareResourceForm(resource, resourceForm);
            resources.add(resourceForm);
        }
        int iTotalRecords = this.resourceManager.getActiveResourcesCount();
        logger.debug((Object)("Total number of records -->" + iTotalRecords));
        resourcesListForm.setTotalRecords(iTotalRecords);
        resourcesListForm.setResourcesList(resources);
        if (exportFlag) {
            ExportUtility exportUtility = new ExportUtility();
            exportUtility.exportDataToExcel(request, response, resourcesListForm, resources);
            return null;
        }
        ResourcesListForm paginationAndSortingForm = resourcesListForm;
        request.setAttribute("Search_Criteria", (Object)paginationAndSortingForm);
        return actionMapping.findForward("resourcesList");
    }

    public ActionForward setResourceOffline(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.debug((Object)"makeResourceOffline()----> Starting");
        ResourceForm resourceForm = (ResourceForm)actionForm;
        this.resourceManager.setResourceOffline(Long.parseLong(resourceForm.getId()));
        request.setAttribute("Offline", (Object)"Offline");
        request.setAttribute("OUTPUT", (Object)resourceForm);
        logger.debug((Object)"makeResourceOffline()----> Ending");
        return actionMapping.findForward("postCreateResource");
    }

    private ResourceForm prepareResourceForm(Resource resource, ResourceForm resourceForm) {
        logger.debug((Object)"Starting----->");
        ResourceType resourceType = null;
        resourceForm.setId(String.valueOf(resource.getId()));
        resourceForm.setName(resource.getName());
        resourceForm.setConnectionString(resource.getConnectionString());
        resourceForm.setFunctionalType(resource.getFunctionalType() != null ? resource.getFunctionalType() : "");
        resourceForm.setOperationalStatus(resource.getOperationalState().getStateName());
        resourceForm.setHeartBeatConnectionString(resource.getHeartbeatConnectionString());
        resourceForm.setHeartBeatFrequency(String.valueOf(resource.getHeartbeatFrequency() == null ? "" : resource.getHeartbeatFrequency()));
        resourceForm.setMaxConcurrentUsage(String.valueOf(resource.getMaxConcurrentUsers()));
        resourceForm.setOperationalStatusId(String.valueOf(resource.getOperationalState().getId()));
        resourceForm.setAdminStatus(resource.getAdministrationState().getStateName());
        resourceForm.setAdminStatusId(String.valueOf(resource.getAdministrationState().getId()));
        resourceType = resource.getResourceType();
        resourceForm.setResourceTypeId(String.valueOf(resourceType.getId()));
        resourceForm.setResourceTypeName(resourceType.getName());
        TreeSet<ResourceGroup> set = new TreeSet<ResourceGroup>(new Comparator<ResourceGroup>(){

            @Override
            public int compare(ResourceGroup lhs, ResourceGroup rhs) {
                return lhs.getName().toUpperCase().compareTo(rhs.getName().toUpperCase());
            }
        });
        set.addAll(resource.getResourceGroups());
        resourceForm.setResourceGroups(set);
        Iterator<ResourceGroup> iteratorRG = resource.getResourceGroups().iterator();
        String[] strRG = new String[resource.getResourceGroups().size()];
        int i = 0;
        while (iteratorRG.hasNext()) {
            strRG[i] = String.valueOf(iteratorRG.next().getId());
            ++i;
        }
        resourceForm.setResourceGroupIds(strRG);
        logger.debug((Object)"prepareResourceForm()-->Ending");
        return resourceForm;
    }

    private Resource prepareResource(ResourceForm resourceForm, Resource resource, HttpServletRequest request) throws FinderException {
        logger.debug((Object)((Object)((Object)this) + "prepareResource()---->Starting"));
        resource.setName(resourceForm.getName());
        resource.setConnectionString(resourceForm.getConnectionString());
        resource.setFunctionalType(resourceForm.getFunctionalType());
        resource.setHeartbeatConnectionString(resourceForm.getHeartBeatConnectionString().trim().equals("") ? null : resourceForm.getHeartBeatConnectionString());
        if (resourceForm.getHeartBeatFrequency() != null && !resourceForm.getHeartBeatFrequency().trim().equals("")) {
            resource.setHeartbeatFrequency(Long.parseLong(resourceForm.getHeartBeatFrequency()));
        } else {
            resource.setHeartbeatFrequency(null);
        }
        resource.setMaxConcurrentUsers(Integer.parseInt(resourceForm.getMaxConcurrentUsage()));
        resource.setCreateDate(new Date());
        if (resourceForm.getAdminStatus().equals(ResourceState.ONLINE.getStateName())) {
            resource.setAdministrationState(ResourceState.ONLINE);
        } else if (resourceForm.getAdminStatus().equals(ResourceState.OFFLINE.getStateName())) {
            resource.setAdministrationState(ResourceState.OFFLINE);
        }
        ResourceType resourceType = this.resourceManager.getResourceType(Long.parseLong(resourceForm.getResourceTypeId()));
        resource.setResourceType(resourceType);
        if ("04".equals(resourceType.getSystemId())) {
            resource.setUserName(resourceForm.getName());
        }
        String[] resourceGroupIds = resourceForm.getResourceGroupIds();
        HashSet<ResourceGroup> setResourceGroups = new HashSet<ResourceGroup>();
        for (int i = 0; i < resourceGroupIds.length; ++i) {
            setResourceGroups.add(this.resourceManager.getResourceGroup(Long.parseLong(resourceGroupIds[i])));
        }
        resource.setResourceGroups(setResourceGroups);
        return resource;
    }

    public ActionForward getResourceDetails(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.debug((Object)"Starting---->");
        String strId = null;
        ResourceForm resourceForm = (ResourceForm)actionForm;
        strId = resourceForm.getId();
        logger.debug((Object)("Resource Id------->" + strId));
        Resource resource = this.resourceManager.getResource(Long.parseLong(strId));
        resourceForm = this.prepareResourceForm(resource, resourceForm);
        this.getResourceTypeDetails(actionMapping, actionForm, request, response);
        request.setAttribute("TabbedModify", (Object)"TabbedModify");
        request.setAttribute("OUTPUT", (Object)resourceForm);
        logger.debug((Object)"Ending---->");
        return actionMapping.findForward("resourceDetails");
    }

    public ActionForward bringResourceOnline(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceForm resourceForm;
        block3: {
            logger.debug((Object)"Starting---->");
            String strId = null;
            resourceForm = (ResourceForm)actionForm;
            strId = resourceForm.getId();
            logger.debug((Object)("Resource Id------->" + strId));
            try {
                this.resourceManager.setResourceOnline(Long.parseLong(strId));
            }
            catch (ValidationException validationException) {
                ArrayList alErrorCodes = (ArrayList)validationException.getErrorCodes();
                if (alErrorCodes == null || alErrorCodes.size() <= 0) break block3;
                ActionMessages actionMessages = new ActionMessages();
                for (String errorCode : alErrorCodes) {
                    actionMessages.add(errorCode, new ActionMessage(errorCode, true));
                }
                this.saveMessages(request, actionMessages);
                return this.getResourceDetails(actionMapping, actionForm, request, response);
            }
        }
        request.setAttribute("Online", (Object)"Online");
        request.setAttribute("OUTPUT", (Object)resourceForm);
        logger.debug((Object)"Ending---->");
        return actionMapping.findForward("postCreateResource");
    }

    public ActionForward moveToTop(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceGroupQueueForm rgQueueStatus = (ResourceGroupQueueForm)form;
        String targetQueueItemId = rgQueueStatus.getTargetQueueItemId();
        String strId = rgQueueStatus.getId();
        logger.debug((Object)("queueID= " + strId + ", targetQueueItemID= " + targetQueueItemId));
        ResourceGroup resourceGroup = this.resourceManager.moveQueueItemToTop(Long.parseLong(strId), Long.parseLong(targetQueueItemId));
        this.populateForm(rgQueueStatus, strId, resourceGroup, request);
        return mapping.findForward("resourceGroupDetails");
    }

    public ActionForward moveToBottom(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceGroupQueueForm rgQueueStatus = (ResourceGroupQueueForm)form;
        String targetQueueItemId = rgQueueStatus.getTargetQueueItemId();
        String strId = rgQueueStatus.getId();
        logger.debug((Object)("queueID= " + strId + ", targetQueueItemID= " + targetQueueItemId));
        ResourceGroup resourceGroup = this.resourceManager.moveQueueItemToBottom(Long.parseLong(strId), Long.parseLong(targetQueueItemId));
        this.populateForm(rgQueueStatus, strId, resourceGroup, request);
        return mapping.findForward("resourceGroupDetails");
    }

    public ActionForward moveUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceGroupQueueForm rgQueueStatus = (ResourceGroupQueueForm)form;
        String targetQueueItemId = rgQueueStatus.getTargetQueueItemId();
        String neighborQueueItemId = rgQueueStatus.getNeighborQueueItemId();
        String strId = rgQueueStatus.getId();
        logger.debug((Object)("queueID= " + strId + ", targetQueueItemID= " + targetQueueItemId + ", neighborQueueItemID= " + neighborQueueItemId));
        ResourceGroup resourceGroup = this.resourceManager.moveQueueItemUp(Long.parseLong(strId), Long.parseLong(targetQueueItemId), Long.parseLong(neighborQueueItemId));
        this.populateForm(rgQueueStatus, strId, resourceGroup, request);
        return mapping.findForward("resourceGroupDetails");
    }

    public ActionForward moveDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceGroupQueueForm rgQueueStatus = (ResourceGroupQueueForm)form;
        String targetQueueItemId = rgQueueStatus.getTargetQueueItemId();
        String neighborQueueItemId = rgQueueStatus.getNeighborQueueItemId();
        String strId = rgQueueStatus.getId();
        logger.debug((Object)("queueID= " + strId + ", targetQueueItemID= " + targetQueueItemId + ", neighborQueueItemID= " + neighborQueueItemId));
        ResourceGroup resourceGroup = this.resourceManager.moveQueueItemDown(Long.parseLong(strId), Long.parseLong(targetQueueItemId), Long.parseLong(neighborQueueItemId));
        this.populateForm(rgQueueStatus, strId, resourceGroup, request);
        return mapping.findForward("resourceGroupDetails");
    }

    public ActionForward getResourceGroupQueue(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean exportFlag = false;
        exportFlag = request.getParameter("exportData") != null && request.getParameter("exportData").toString().equals("export");
        ResourceGroupQueueForm rgQueueStatus = (ResourceGroupQueueForm)form;
        String strId = rgQueueStatus.getId();
        logger.debug((Object)("Resource Group Id------->" + strId));
        ResourceGroup resourceGroup = this.resourceManager.getResourceGroup(Long.parseLong(strId));
        this.populateForm(rgQueueStatus, strId, resourceGroup, request);
        if (exportFlag) {
            ExportUtility exportUtility = new ExportUtility();
            exportUtility.exportDataToExcel(request, response, this.resourceGroupQueueForm, this.resourceGroupQueueForm.getResourcesList());
            this.resourceGroupQueueForm = null;
            return null;
        }
        return mapping.findForward("resourceGroupDetails");
    }

    public ActionForward updateUIVisibility(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceGroupQueueForm rgqForm = (ResourceGroupQueueForm)form;
        String resourceGroupIDStr = rgqForm.getId();
        long resourceGroupID = Long.parseLong(resourceGroupIDStr);
        try {
            this.resourceManager.setResourceGroupQueueUIVisibility(resourceGroupID, rgqForm.isVisibleInUI());
        }
        catch (Exception e) {
            String message = "Exception while setting resource group queue visibility. | Resource Group ID: " + resourceGroupIDStr + " | Reason: " + e.getMessage();
            logger.error((Object)message, (Throwable)e);
            throw e;
        }
        ActionMessages messages = new ActionMessages();
        ActionMessage message = rgqForm.isVisibleInUI() ? new ActionMessage(RG_Q_SHOWINDASHBOARD_CHECKED) : new ActionMessage(RG_Q_SHOWINDASHBOARD_UNCHECKED);
        messages.add("infoMessages", message);
        this.saveMessages(request, messages);
        ResourceGroup resourceGroup = this.resourceManager.getResourceGroup(resourceGroupID);
        this.populateForm(rgqForm, resourceGroupIDStr, resourceGroup, request);
        return mapping.findForward("resourceGroupDetails");
    }

    private void populateForm(ResourceGroupQueueForm rgQueueStatus, String strId, ResourceGroup resourceGroup, HttpServletRequest request) throws Exception {
        SortingOrder sortType;
        logger.debug((Object)"Populating RGForm...");
        EngineDriver engineDriver = EngineDriver.getInstance();
        rgQueueStatus = this.prepareResourceGroupQueueForm(resourceGroup, rgQueueStatus);
        ResourceGroupDisplay rgDisplay = new ResourceGroupDisplay(resourceGroup);
        TableConfig tableConfig = TableConfig.getInstance();
        rgQueueStatus.setQueueTable(tableConfig.getTable(QUEUE_TABLE_ID));
        ArrayList<ResourceForm> resources = new ArrayList<ResourceForm>();
        long resGrpId = Long.parseLong(rgQueueStatus.getId());
        List<Resource> allResPerGroup = this.resourceManager.getResourcesByGroup(resGrpId);
        AllResourcesForm allResourcesForm = new AllResourcesForm();
        String sortKey = rgQueueStatus.getSortingColumnName();
        if (sortKey == null || sortKey.trim().length() == 0) {
            sortKey = allResourcesForm.getTable().getDefaultSortingColumn();
        }
        if ((sortType = this.getSortingOrder(rgQueueStatus.getSortingOrder())) == null) {
            sortType = this.getSortingOrder(allResourcesForm.getTable().getDefaultSortingOrder());
        }
        ArrayList<ResourceDisplay> allResList = new ArrayList<ResourceDisplay>();
        ResourceForm resourceForm = null;
        for (Resource resource : allResPerGroup) {
            logger.debug((Object)("Resource Name is---->" + resource.getName()));
            resourceForm = new ResourceForm();
            resourceForm = this.prepareResourceForm(resource, resourceForm);
            resources.add(resourceForm);
            ResourceDisplay resDisplay = new ResourceDisplay(resource);
            allResList.add(resDisplay);
        }
        ResourceFormComparator resourceFormComparator = new ResourceFormComparator();
        resourceFormComparator.setSortKey(sortKey);
        resourceFormComparator.setSortType(sortType);
        Collections.sort(resources, resourceFormComparator);
        allResourcesForm.setSortingColumnName(sortKey);
        allResourcesForm.setSortingOrder(sortType.toString());
        allResourcesForm.setTotalRecords(resources.size());
        rgQueueStatus.setResourcesList(resources);
        allResourcesForm.setResourceDisplayList(allResList);
        rgQueueStatus.setAllResourcesForm(allResourcesForm);
        this.resourceGroupQueueForm = rgQueueStatus;
        logger.debug((Object)("All resources in group " + rgQueueStatus.getName() + " are: " + allResList));
        IPersistenceService service = ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        IProgressTrackingStrategy progressTracker = engineDriver.getProgressTrackingStrategy();
        ArrayList<ResourceUsageDisplay> resourceUsageList = new ArrayList<ResourceUsageDisplay>();
        ArrayList<ResourceUsageDisplay> usageList = new ArrayList<ResourceUsageDisplay>();
        for (Resource resource : resourceGroup.getResources()) {
            for (ResourceUser user : resource.getUsers()) {
                CustomToken token;
                if (user.getResourceGroupId() != resourceGroup.getId() || (token = service.getToken(Long.valueOf(user.getId()))).getStatus() != ProcessStatus.BUSY) continue;
                String percentComplete = progressTracker.calculatePercentComplete(token);
                ResourceUsageDisplay ruDisplay = new ResourceUsageDisplay(resource, token);
                ruDisplay.setProgressStatus(percentComplete);
                usageList.add(ruDisplay);
                logger.debug((Object)("added resource " + resource.getName()));
            }
        }
        resourceUsageList.addAll(usageList);
        rgDisplay.setResourceUsageList(usageList);
        ResourceUsageForm usageForm = new ResourceUsageForm();
        ResourceUsageDisplayComparator comparator = new ResourceUsageDisplayComparator();
        sortKey = rgQueueStatus.getSortingColumnName();
        if (sortKey == null || sortKey.trim().length() == 0) {
            sortKey = usageForm.getTable().getDefaultSortingColumn();
        }
        if ((sortType = this.getSortingOrder(rgQueueStatus.getSortingOrder())) == null) {
            sortType = this.getSortingOrder(usageForm.getTable().getDefaultSortingOrder());
        }
        comparator.setSortKey(sortKey);
        comparator.setSortType(sortType);
        Collections.sort(resourceUsageList, comparator);
        usageForm.setSortingColumnName(sortKey);
        usageForm.setSortingOrder(sortType.toString());
        usageForm.setResourceUsageDisplayList(resourceUsageList);
        rgQueueStatus.setResourceUsageForm(usageForm);
        ArrayList<QueuedWorkOrderDisplay> queuedItems = new ArrayList<QueuedWorkOrderDisplay>();
        for (ResourceGroupQueueItem queueItem : resourceGroup.getQueue().getQueuedItems()) {
            long tokenId = queueItem.getTokenId();
            CustomToken token = service.getToken(Long.valueOf(tokenId));
            if (token.getStatus() != ProcessStatus.QUEUED) continue;
            QueuedWorkOrderDisplay qwoDisplay = new QueuedWorkOrderDisplay(queueItem, token);
            queuedItems.add(qwoDisplay);
        }
        ArrayList neighborsDown = new ArrayList(queuedItems);
        if (neighborsDown.size() > 0) {
            neighborsDown.remove(0);
        }
        neighborsDown.add(null);
        ArrayList neighborsUp = new ArrayList(queuedItems);
        neighborsUp.add(0, null);
        neighborsUp.remove(queuedItems.size());
        for (int i = 0; i < queuedItems.size(); ++i) {
            if (neighborsDown.get(i) != null) {
                ((QueuedWorkOrderDisplay)queuedItems.get(i)).setNeighborItemDownId(((QueuedWorkOrderDisplay)neighborsDown.get(i)).getQueueItemId());
            } else {
                ((QueuedWorkOrderDisplay)queuedItems.get(i)).setNeighborItemDownId("-1");
            }
            if (neighborsUp.get(i) != null) {
                ((QueuedWorkOrderDisplay)queuedItems.get(i)).setNeighborItemUpId(((QueuedWorkOrderDisplay)neighborsUp.get(i)).getQueueItemId());
                continue;
            }
            ((QueuedWorkOrderDisplay)queuedItems.get(i)).setNeighborItemUpId("-1");
        }
        rgDisplay.setQueuedItemList(queuedItems);
        rgDisplay.setQueueSize(Integer.toString(queuedItems.size()));
        rgQueueStatus.setRgDisplay(rgDisplay);
        rgQueueStatus.setId(strId);
        rgQueueStatus.setVisibleInUI(resourceGroup.isVisible());
        request.setAttribute("TabbedQueue", (Object)"TabbedQueue");
        request.setAttribute("Search_Criteria", (Object)allResourcesForm);
        logger.debug((Object)"Finished Populating RGForm...");
    }

    private ResourceGroupQueueForm prepareResourceGroupQueueForm(ResourceGroup resGroup, ResourceGroupQueueForm resGQForm) {
        logger.debug((Object)"Starting----->");
        ResourceType resourceType = null;
        resGQForm.setId(String.valueOf(resGroup.getId()));
        resGQForm.setName(resGroup.getName());
        resourceType = resGroup.getResourceType();
        resGQForm.setResourceTypeId(String.valueOf(resourceType.getId()));
        resGQForm.setResourceTypeName(resourceType.getName());
        logger.debug((Object)"prepareResourceGroupQueueForm()-->Ending");
        return resGQForm;
    }

    public ActionForward getResourceTypeDetails(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.debug((Object)"getResourceTypeDetails()--> Starting");
        ResourceForm resourceForm = (ResourceForm)actionForm;
        ResourceType resourceType = null;
        if (resourceForm.getResourceTypeId() != null) {
            resourceType = this.resourceManager.getResourceType(Long.parseLong(resourceForm.getResourceTypeId()));
        } else {
            String resourceTypeId;
            this.resourceManager = ResourceManager.getInstance();
            List<ResourceType> lsResourceTypes = this.resourceManager.getAllResourceTypes();
            HashMap hmResourceTypes = new HashMap();
            for (ResourceType resourceType1 : lsResourceTypes) {
                hmResourceTypes.put(String.valueOf(resourceType1.getId()), resourceType1.getName());
            }
            String string = resourceTypeId = (hmResourceTypes = (HashMap)CommonUtils.sort(hmResourceTypes)).entrySet().iterator().hasNext() ? (String)hmResourceTypes.entrySet().iterator().next().getKey() : null;
            if (resourceTypeId != null) {
                resourceType = this.resourceManager.getResourceType(Long.parseLong(resourceTypeId));
            }
        }
        ResourceConnectionType connectionType = null;
        connectionType = resourceType != null ? resourceType.getConnectionType() : null;
        resourceForm.setConnectionStringType(connectionType != null ? connectionType.getDisplayName() : "");
        connectionType = resourceType != null ? resourceType.getHeartbeatConnectionType() : null;
        resourceForm.setHeartBeatConnectionStringType(connectionType != null ? connectionType.getDisplayName() : "");
        logger.debug((Object)"getResourceTypeDetails()--> Ending");
        return actionMapping.findForward("resourceTypeDetails");
    }

    public ActionForward setMultipleResourceOffline(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceForm resourceForm = (ResourceForm)actionForm;
        String[] strResourceIds = resourceForm.getSelectedResources();
        logger.debug((Object)("Starting to Take [" + strResourceIds.length + "] number of resources offline"));
        ActionMessages messages = new ActionMessages();
        for (int i = 0; i < strResourceIds.length; ++i) {
            Resource resource = this.resourceManager.getResource(Long.parseLong(strResourceIds[i]));
            String statusflag = resource.getAdministrationState().getStateName();
            if (ResourceState.ONLINE.getStateName().equals(statusflag)) {
                try {
                    this.resourceManager.setResourceOffline(Long.parseLong(strResourceIds[i]));
                    logger.debug((Object)("Taking the resource [" + strResourceIds[i] + "] offline "));
                    messages.add("infoMessages", new ActionMessage(DISPLAY_MESSAGE, (Object)("Resource [" + resource.getId() + "] name: [" + resource.getName() + "] successfully taken offline")));
                }
                catch (Exception e) {
                    logger.error((Object)("Cannot bring the resource offline " + e.toString()));
                }
                continue;
            }
            messages.add("errorMessages", new ActionMessage(DISPLAY_ERRORS, (Object)("Resource [" + resource.getId() + "] name: [" + resource.getName() + "] can not be taken offline because it is already offline")));
        }
        this.saveErrors(request, messages);
        this.saveMessages(request, messages);
        logger.debug((Object)"setMultipleResourceOffline()----> Ending");
        return actionMapping.findForward("deleteResources");
    }

    public ActionForward bringMultipleResourcesOnline(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceForm resourceForm = (ResourceForm)actionForm;
        String[] strResourceIds = resourceForm.getSelectedResources();
        logger.debug((Object)("Starting to update [" + strResourceIds.length + "] number of resources"));
        ActionMessages messages = new ActionMessages();
        ArrayList<String> unChangedResources = new ArrayList<String>();
        for (int i = 0; i < strResourceIds.length; ++i) {
            Resource resource = this.resourceManager.getResource(Long.parseLong(strResourceIds[i]));
            String statusflag = resource.getAdministrationState().getStateName();
            if (ResourceState.OFFLINE.getStateName().equals(statusflag)) {
                try {
                    this.resourceManager.setResourceOnline(Long.parseLong(strResourceIds[i]));
                    logger.debug((Object)("Updating the resource [" + strResourceIds[i] + "]"));
                    messages.add("infoMessages", new ActionMessage(DISPLAY_MESSAGE, (Object)("Resource [" + resource.getId() + "] name: [" + resource.getName() + "] successfully brought online")));
                }
                catch (ValidationException validationException) {
                    ArrayList alErrorCodes = (ArrayList)validationException.getErrorCodes();
                    if (alErrorCodes == null || alErrorCodes.size() <= 0) continue;
                    unChangedResources.add(resource.getName());
                }
                catch (Exception e) {
                    logger.error((Object)("Cannot bring the resource online " + e.toString()));
                }
                continue;
            }
            messages.add("errorMessages", new ActionMessage(DISPLAY_ERRORS, (Object)("Resource [" + resource.getId() + "] name: [" + resource.getName() + "] can not be brought online because it is already online")));
        }
        this.saveErrors(request, messages);
        this.saveMessages(request, messages);
        request.setAttribute("unchanged.resources", unChangedResources);
        logger.debug((Object)"bringMultipleResourcesOnline()----> Ending");
        return actionMapping.findForward("deleteResources");
    }

    private SortingOrder getSortingOrder(String sortingOrder) {
        SortingOrder result;
        try {
            result = SortingOrder.valueOf(sortingOrder);
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }
}

