/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.actions;

import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.SelectorExistsException;
import com.tandbergtv.workflow.web.actions.BaseDispatchAction;
import com.tandbergtv.workflow.web.formbeans.TemplateSelectorKeyForm;
import com.tandbergtv.workflow.web.util.TemplateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class SelectorKeyDispatchAction
extends BaseDispatchAction {
    private static final Logger logger = Logger.getLogger(SelectorKeyDispatchAction.class);
    private static final String ERROR_MESSAGE = "error.templates.msg";
    private static final String INFO_MESSAGE = "infoMessages";

    public ActionForward getSelectorKeyDetails(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ITemplateLoaderService service = ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        ActionMessages errors = new ActionMessages();
        TemplateSelectorKeyForm form = (TemplateSelectorKeyForm)actionform;
        String id = form.getTemplateName();
        String name = request.getParameter("tempName");
        form.setTemplateList(new HashMap<String, String>());
        try {
            Collection ids;
            Iterator i$;
            List<WorkflowTemplate> templates = service.getLatestTemplates();
            LinkedHashMap<String, String> list = new LinkedHashMap<String, String>();
            for (WorkflowTemplate template : templates) {
                list.put(template.getFullName(), String.valueOf(template.getId()));
            }
            form.setTemplateList(list);
            if (id == null && (i$ = (ids = list.values()).iterator()).hasNext()) {
                String myid;
                id = myid = (String)i$.next();
            }
            ArrayList<String> selectKeyList = new ArrayList<String>();
            WorkflowTemplate selectedTemplate = service.getProcessDefinition(Long.valueOf(Long.parseLong(id)));
            if (selectedTemplate == null) {
                errors.add(INFO_MESSAGE, new ActionMessage(ERROR_MESSAGE, (Object)name));
                this.saveErrors(request, errors);
                Collection ids2 = list.values();
                Iterator<WorkflowTemplate> i$2 = ids2.iterator();
                if (i$2.hasNext()) {
                    String myid;
                    id = myid = (String)((Object)i$2.next());
                }
                selectedTemplate = service.getProcessDefinition(Long.valueOf(Long.parseLong(id)));
            }
            for (Selector selector : selectedTemplate.getSelectorKeys()) {
                selectKeyList.add(selector.getSelectionKey());
            }
            form.setSelectKeyList(selectKeyList);
            ArrayList<TemplateKey> templateKeysList = new ArrayList<TemplateKey>();
            for (WorkflowTemplate template : templates) {
                logger.debug((Object)template);
                Iterator<Selector> i = template.getSelectorKeys().iterator();
                String keys = "";
                while (i.hasNext()) {
                    Selector selector = i.next();
                    logger.debug((Object)selector.getSelectionKey());
                    keys = keys + selector.getSelectionKey();
                    if (!i.hasNext()) continue;
                    keys = keys + ",";
                }
                templateKeysList.add(new TemplateKey(template.getFullName(), keys));
            }
            Collections.reverse(templateKeysList);
            form.setTemplateKeysList(templateKeysList);
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("Failed to get list of template Selector Keys ", false));
            this.saveErrors(request, errors);
            logger.error((Object)"Failed to get list of template Selector Keys", (Throwable)e);
            return mapping.findForward("AddModifyDone");
        }
        return mapping.findForward("AddModifyDone");
    }

    public ActionForward addSelectorKey(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ITemplateLoaderService service = ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        ActionMessages errors = new ActionMessages();
        TemplateSelectorKeyForm form = (TemplateSelectorKeyForm)actionform;
        String key = form.getSelectorKeyName().trim();
        String id = form.getTemplateName();
        try {
            service.addSelector(Long.valueOf(Long.parseLong(id)), new Selector(key));
            form.setSelectorKeyName("");
        }
        catch (SelectorExistsException e) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(e.getMessage(), false));
            this.saveErrors(request, errors);
            logger.error((Object)("Failed to add selector key " + key), (Throwable)e);
            return mapping.findForward("AddSuccess");
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("Key could not be added: " + key, false));
            this.saveErrors(request, errors);
            logger.error((Object)"Failed to add Selector Key", (Throwable)e);
            return mapping.findForward("AddSuccess");
        }
        return mapping.findForward("AddSuccess");
    }

    public ActionForward deleteSelectorKey(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ITemplateLoaderService service = ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        ActionMessages errors = new ActionMessages();
        TemplateSelectorKeyForm form = (TemplateSelectorKeyForm)actionform;
        String id = form.getTemplateName();
        String key = request.getParameter("delSelectorKey").trim();
        try {
            service.removeSelector(Long.valueOf(Long.parseLong(id)), new Selector(key));
            form.setSelectorKeyName("");
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("Error while deleting the key: " + key, false));
            this.saveErrors(request, errors);
            logger.error((Object)"Failed to delete Selector Key", (Throwable)e);
            return mapping.findForward("DeleteSuccess");
        }
        return mapping.findForward("DeleteSuccess");
    }
}

