/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.actions;

import com.tandbergtv.workflow.auth.Credentials;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import com.tandbergtv.workflow.web.actions.BaseDispatchAction;
import com.tandbergtv.workflow.web.formbeans.UserTask;
import com.tandbergtv.workflow.web.formbeans.UserTaskGroup;
import com.tandbergtv.workflow.web.formbeans.UserTasksForm;
import com.tandbergtv.workflow.web.util.CommonUtils;
import com.tandbergtv.workflow.web.util.ExportUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.jbpm.taskmgmt.exe.TaskInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserTasksAction
extends BaseDispatchAction {
    private static final Logger logger = Logger.getLogger(UserTasksAction.class);
    private static final String HOUSE_MATERIAL_ID = "houseMaterialId";
    private static final String EMPTY_STRING = "";
    private static final String RESOURCE_NOT_FOUND_FOR = "No Resource Found for ";
    private static final String TASKS_NOT_FOUND_FOR = "No Tasks Found for ";
    private static final String NO_MATCHING_RECORD = "No Matching Record";

    public ActionForward getUserTasks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserTasksForm userTasksForm = (UserTasksForm)form;
        String userName = this.getUserName(request, form);
        logger.debug((Object)("User Name from ActionForm: " + userName));
        ActionMessages errors = new ActionMessages();
        Set<Resource> resourceList = this.getResourceList(request, errors);
        logger.debug((Object)("Resources List Size: " + resourceList.size()));
        if (resourceList.size() != 0) {
            userTasksForm.setResourceList(resourceList);
            this.populateUserTasks(userTasksForm, userName, userTasksForm.getTemplateName(), userTasksForm.getTaskName(), userTasksForm.getGroupKey());
            if (userTasksForm.getUserTaskGroups() == null) {
                if (userTasksForm.getTemplateName().equals(EMPTY_STRING) && userTasksForm.getTaskName().equals(EMPTY_STRING)) {
                    errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(TASKS_NOT_FOUND_FOR + userName, false));
                } else {
                    errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(NO_MATCHING_RECORD, false));
                }
            }
            if (request.getParameter("exportData") != null && request.getParameter("exportData").toString().equals("export")) {
                ExportUtility exportUtility = new ExportUtility();
                ArrayList<UserTask> allUserTasks = new ArrayList<UserTask>();
                if (userTasksForm.getUserTaskGroups() != null) {
                    for (UserTaskGroup userTaskGroup : userTasksForm.getUserTaskGroups()) {
                        allUserTasks.addAll(userTaskGroup.getUserTasks());
                    }
                }
                exportUtility.exportDataToExcel(request, response, userTasksForm, allUserTasks);
                return null;
            }
        }
        this.saveErrors(request, errors);
        String strForward = "userTasksView";
        return mapping.findForward(strForward);
    }

    private void populateUserTasks(UserTasksForm form, String userName, String filterTemplateName, String filterTaskName, String selectedGroupKey) throws Exception {
        HashMap<String, UserTaskGroup> userTaskGroupsMap = new HashMap<String, UserTaskGroup>();
        if (filterTemplateName != null && filterTemplateName.trim().length() == 0) {
            filterTemplateName = null;
        }
        if (filterTaskName != null && filterTaskName.trim().length() == 0) {
            filterTaskName = null;
        }
        IPersistenceService service = ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        ResourceManagement resourceManager = ResourceManager.getInstance();
        Resource resource = resourceManager.getResourceByUser(userName);
        Set<ResourceUser> resourceUsers = resource.getUsers();
        if (resourceUsers != null) {
            for (ResourceUser resourceUser : resourceUsers) {
                UserTaskGroup userTaskGroup;
                long tokenID = resourceUser.getId();
                long resourceGroupID = resourceUser.getResourceGroupId();
                CustomToken token = service.getToken(Long.valueOf(tokenID));
                WorkflowProcess process = (WorkflowProcess)token.getProcessInstance();
                String templateName = process.getProcessDefinition().getFullName();
                form.addTemplateName(templateName);
                String nodeName = token.getNode().getName();
                form.addTaskName(nodeName);
                if (filterTemplateName != null && !filterTemplateName.equals(templateName) || filterTaskName != null && !filterTaskName.equals(nodeName)) continue;
                long templateID = process.getProcessDefinition().getId();
                long nodeID = token.getNode().getId();
                String groupKey = templateID + ":" + nodeID;
                if (selectedGroupKey != null && !selectedGroupKey.equals(EMPTY_STRING) && !selectedGroupKey.equals(groupKey)) continue;
                UserTask userTask = new UserTask();
                userTask.setWorkflowProcess(process);
                userTask.setTaskName(nodeName);
                String resourceGroupName = resourceManager.getResourceGroup(resourceGroupID).getName();
                userTask.setResourceGroup(resourceGroupName);
                long taskInstanceID = this.getTaskInstanceID(process, token.getNode().getId());
                if (taskInstanceID == -1L) continue;
                userTask.setTaskInstanceID(taskInstanceID);
                Object houseMaterialID = process.getContextInstance().getVariable(HOUSE_MATERIAL_ID);
                userTask.setMaterialID(houseMaterialID == null ? EMPTY_STRING : houseMaterialID.toString());
                userTask.setAssignedDateTime(CommonUtils.formatTime(token.getNodeEnter()));
                if (userTaskGroupsMap.containsKey(groupKey)) {
                    userTaskGroup = (UserTaskGroup)userTaskGroupsMap.get(groupKey);
                } else {
                    userTaskGroup = new UserTaskGroup(groupKey, templateName + " : " + nodeName);
                    userTaskGroupsMap.put(groupKey, userTaskGroup);
                }
                userTaskGroup.addUserTask(userTask);
            }
        }
        if (userTaskGroupsMap.size() > 0) {
            form.setUserTaskGroups(userTaskGroupsMap.values());
        }
    }

    private long getTaskInstanceID(WorkflowProcess process, long nodeID) {
        Collection taskInstances = process.getTaskMgmtInstance().getTaskInstances();
        if (taskInstances != null) {
            for (TaskInstance t : taskInstances) {
                if (t.hasEnded() || t.getTask().getTaskNode().getId() != nodeID) continue;
                logger.debug((Object)("[" + process.getId() + "] current task instance " + t.getId()));
                return t.getId();
            }
        }
        return -1L;
    }

    public Set<Resource> getResourceList(HttpServletRequest request, ActionMessages errors) throws FinderException {
        HashSet<Resource> resourceSet = new HashSet<Resource>();
        Credentials credentials = this.getCredentials(request);
        String loggedInUser = credentials.getName();
        logger.debug((Object)("Logged-in User Name: " + loggedInUser));
        ResourceManagement resourceManager = ResourceManager.getInstance();
        Resource resource = resourceManager.getResourceByUser(loggedInUser);
        if (resource == null) {
            logger.debug((Object)("Resource for user: " + loggedInUser + " is null"));
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(RESOURCE_NOT_FOUND_FOR + loggedInUser, false));
        } else {
            logger.debug((Object)("Resource for user: " + loggedInUser + " is not null"));
            if (credentials.getSections().contains("Perform Tasks")) {
                for (ResourceGroup shallowResourceGroup : resource.getResourceGroups()) {
                    try {
                        ResourceGroup resourceGroup = ResourceManager.getInstance().getResourceGroup(shallowResourceGroup.getId());
                        resourceSet.addAll(resourceGroup.getResources());
                    }
                    catch (FinderException e) {
                        logger.error((Object)e);
                        throw e;
                    }
                }
            } else {
                resourceSet.add(resource);
            }
        }
        return resourceSet;
    }

    private String getUserName(HttpServletRequest request, ActionForm form) {
        String userName = null;
        UserTasksForm userTasksForm = (UserTasksForm)form;
        userName = userTasksForm.getResource();
        if (userName == null || userName.equals(EMPTY_STRING)) {
            userName = this.getCredentials(request).getName();
            userTasksForm.setResource(userName);
        }
        return userName;
    }

    private Credentials getCredentials(HttpServletRequest request) {
        return (Credentials)request.getSession().getAttribute("credentials");
    }
}

