/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.actions;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowProcessNote;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.web.actions.BaseDispatchAction;
import com.tandbergtv.workflow.web.formbeans.WorkOrderForm;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class WorkOrderAction
extends BaseDispatchAction {
    private static final String FORWARD_ACTION = "WorkOrderDetail";
    private static final String FORWARD_DASHBOARD_ACTION = "Dashboard";
    private ServiceRegistry registry = ServiceRegistry.getDefault();
    private static final Logger logger = Logger.getLogger(WorkOrderAction.class);

    public ActionForward getWorkOrder(ActionMapping map, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkOrderForm form = (WorkOrderForm)actionform;
        long id = form.getId();
        List<ProcessPriority> priorities = Arrays.asList(ProcessPriority.values());
        form.setPriorityList(priorities);
        logger.debug((Object)("Loading process " + id + " from the driver"));
        WorkflowProcess process = this.registry.lookup(IPersistenceService.class).get(Long.valueOf(form.getId()));
        form.setProcess(process);
        form.setPriority(process.getPriority().toString());
        if (process.getNote() != null) {
            form.setText(process.getNote().getText());
        }
        return map.findForward(FORWARD_ACTION);
    }

    public ActionForward pauseWorkOrder(ActionMapping map, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = FORWARD_DASHBOARD_ACTION;
        WorkOrderForm form = (WorkOrderForm)actionform;
        try {
            CustomToken token = this.registry.lookup(IPersistenceService.class).get(Long.valueOf(form.getId())).getRootToken();
            this.registry.lookup(IProcessManagerService.class).pause(token);
            forward = FORWARD_DASHBOARD_ACTION;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to pause", (Throwable)e);
        }
        return map.findForward(forward);
    }

    public ActionForward resumeWorkOrder(ActionMapping map, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = FORWARD_DASHBOARD_ACTION;
        WorkOrderForm form = (WorkOrderForm)actionform;
        try {
            CustomToken token = this.registry.lookup(IPersistenceService.class).get(Long.valueOf(form.getId())).getRootToken();
            this.registry.lookup(IProcessManagerService.class).resume(token);
            forward = FORWARD_DASHBOARD_ACTION;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to resume", (Throwable)e);
        }
        return map.findForward(forward);
    }

    public ActionForward restartWorkOrder(ActionMapping map, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = FORWARD_DASHBOARD_ACTION;
        WorkOrderForm form = (WorkOrderForm)actionform;
        try {
            WorkflowProcess process = this.registry.lookup(IPersistenceService.class).get(Long.valueOf(form.getId()));
            this.registry.lookup(IProcessManagerService.class).restart(Long.valueOf(process.getId()));
            forward = FORWARD_DASHBOARD_ACTION;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to restart", (Throwable)e);
        }
        return map.findForward(forward);
    }

    public ActionForward retryWorkOrder(ActionMapping map, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = FORWARD_DASHBOARD_ACTION;
        WorkOrderForm form = (WorkOrderForm)actionform;
        try {
            CustomToken token = this.registry.lookup(IPersistenceService.class).get(Long.valueOf(form.getId())).getRootToken();
            this.registry.lookup(IProcessManagerService.class).resume(token);
            forward = FORWARD_DASHBOARD_ACTION;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retry", (Throwable)e);
        }
        return map.findForward(forward);
    }

    public ActionForward cancelWorkOrder(ActionMapping map, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = FORWARD_DASHBOARD_ACTION;
        WorkOrderForm form = (WorkOrderForm)actionform;
        try {
            CustomToken token = this.registry.lookup(IPersistenceService.class).get(Long.valueOf(form.getId())).getRootToken();
            this.registry.lookup(IProcessManagerService.class).cancel(token);
            forward = FORWARD_DASHBOARD_ACTION;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to cancel work order", (Throwable)e);
        }
        return map.findForward(forward);
    }

    public ActionForward saveWorkOrder(ActionMapping map, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkOrderForm form = (WorkOrderForm)actionform;
        try {
            WorkflowProcess process = this.registry.lookup(IPersistenceService.class).get(Long.valueOf(form.getId()));
            ProcessPriority priority = ProcessPriority.valueOf(form.getPriority());
            this.registry.lookup(IProcessManagerService.class).setPriority(process, priority);
            String text = form.getText();
            if (text != null && text.trim().length() > 0) {
                WorkflowProcessNote note = process.getNote();
                if (note == null) {
                    note = new WorkflowProcessNote();
                    process.setNote(note);
                }
                note.setText(form.getText());
            }
            this.registry.lookup(IPersistenceService.class).save(process);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to save", (Throwable)e);
            throw e;
        }
        ActionMessages actionMessages = new ActionMessages();
        actionMessages.add("workorder.saved.successfully", new ActionMessage("workorder.saved.successfully", true));
        this.addMessages(request, actionMessages);
        return this.getWorkOrder(map, actionform, request, response);
    }

    public ActionForward deleteWorkOrder(ActionMapping map, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = FORWARD_DASHBOARD_ACTION;
        WorkOrderForm form = (WorkOrderForm)actionform;
        try {
            WorkflowProcess process = this.registry.lookup(IPersistenceService.class).get(Long.valueOf(form.getId()));
            this.registry.lookup(IProcessManagerService.class).delete(process);
            forward = FORWARD_DASHBOARD_ACTION;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to delete the work order", (Throwable)e);
        }
        return map.findForward(forward);
    }
}

