/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.tag;

import com.tandbergtv.workflow.auth.AuthorizationManager;
import com.tandbergtv.workflow.auth.IAuthorizationManager;
import com.tandbergtv.workflow.auth.Module;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.web.common.StaticCodes;
import com.tandbergtv.workflow.web.formbeans.ResourceForm;
import com.tandbergtv.workflow.web.page.Page;
import com.tandbergtv.workflow.web.page.PageConfig;
import com.tandbergtv.workflow.web.util.CommonUtils;
import com.tandbergtv.workflow.web.util.FormBeansHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;

public class PageLoader
extends TagSupport {
    private static final long serialVersionUID = 7602506287776510309L;
    private String methodName;
    private static final Logger logger = Logger.getLogger(PageLoader.class);

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public int doStartTag() {
        try {
            ((Object)((Object)this)).getClass().getMethod(this.getMethodName(), null).invoke((Object)this, (Object[])null);
        }
        catch (Exception exception) {
            logger.error((Object)"Exception occured during page initialization", (Throwable)exception);
        }
        return 0;
    }

    public void loadRolesPageData() {
        logger.debug((Object)"loadRolesPageData()-->Starting");
        IAuthorizationManager authorizationManager = AuthorizationManager.getInstance();
        List<Module> modules = authorizationManager.getModules();
        this.pageContext.getRequest().setAttribute("Modules", modules);
        logger.debug((Object)"loadRolesPageData()-->Ending");
    }

    public void loadWorkOrderSearchData() throws Exception {
        logger.debug((Object)"loadWorkOrderSearchData()-->Starting");
        Page page = PageConfig.getInstance().getPage(StaticCodes.WORKORDER_SEARCH_PAGE);
        this.pageContext.getRequest().setAttribute("page", (Object)page);
        logger.debug((Object)"loadWorkOrderSearchData()-->Ending");
    }

    public void loadTemplates() {
        List<String> templates = ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class).getAllProcessDefinitionNames();
        List<ProcessPriority> priorities = Arrays.asList(ProcessPriority.values());
        this.pageContext.getRequest().setAttribute("templates.list", templates);
        this.pageContext.getRequest().setAttribute("priorities.list", priorities);
    }

    public void loadResourceGroupsAndTypes() {
        try {
            this.cacheRequiredData();
        }
        catch (Exception ex) {
            logger.error((Object)("Exception when pre-fetching required data for resource form: " + ex.getMessage()), (Throwable)ex);
        }
    }

    private void cacheRequiredData() throws Exception {
        ResourceManagement resourceManager = ResourceManager.getInstance();
        Object formObj = this.pageContext.getRequest().getAttribute("resourceForm");
        ResourceForm form = formObj instanceof ResourceForm ? (ResourceForm)((Object)formObj) : null;
        boolean isUpdate = this.isResourceUpdate(form);
        long currentTypeId = this.cacheResourceTypes(form, isUpdate);
        ResourceType resourceType = currentTypeId != -1L ? resourceManager.getResourceType(currentTypeId) : null;
        this.cacheResourceGroups(form, currentTypeId);
        this.cacheHumanUsers(resourceType);
    }

    private long cacheResourceTypes(ResourceForm form, boolean isUpdate) throws Exception {
        Map<String, String> resourceTypeNames = new HashMap<String, String>();
        long currentResourceTypeId = -1L;
        ResourceManagement resourceManager = ResourceManager.getInstance();
        List<ResourceType> resourceTypes = resourceManager.getAllResourceTypes();
        for (ResourceType resourceType : resourceTypes) {
            String typeId = String.valueOf(resourceType.getId());
            String name = resourceType.getName();
            resourceTypeNames.put(typeId, name);
            if (form == null || !typeId.equals(form.getResourceTypeId())) continue;
            currentResourceTypeId = resourceType.getId();
        }
        if (isUpdate && !resourceTypeNames.containsKey(form.getResourceTypeId())) {
            currentResourceTypeId = Long.parseLong(form.getResourceTypeId());
            ResourceType resourceType = resourceManager.getResourceType(currentResourceTypeId);
            resourceTypeNames.put(form.getResourceTypeId(), resourceType.getName());
        }
        resourceTypeNames = CommonUtils.sort(resourceTypeNames);
        this.pageContext.getRequest().setAttribute("RESOURCETYPES", resourceTypeNames);
        if (currentResourceTypeId == -1L && resourceTypeNames.size() > 0) {
            String value = resourceTypeNames.entrySet().iterator().next().getKey();
            currentResourceTypeId = Long.parseLong(value);
        }
        return currentResourceTypeId;
    }

    private void cacheResourceGroups(ResourceForm form, long resourceTypeId) {
        logger.debug((Object)("Caching Resource Groups for resource type: " + resourceTypeId));
        ArrayList<String> functionalTypes = new ArrayList<String>();
        String currentFunctionalType = form != null ? form.getFunctionalType() : null;
        ResourceManagement resourceManager = ResourceManager.getInstance();
        List<ResourceGroup> groups = resourceManager.getResourceGroupsByResourceType(resourceTypeId);
        for (ResourceGroup group : groups) {
            String functionalType = group.getFunctionalType();
            if (functionalType == null) {
                functionalType = "";
            }
            if (functionalTypes.contains(functionalType)) continue;
            functionalTypes.add(functionalType);
        }
        if (functionalTypes.size() == 0) {
            functionalTypes.add("");
        }
        Collections.sort(functionalTypes);
        if (!functionalTypes.contains(currentFunctionalType)) {
            currentFunctionalType = (String)functionalTypes.get(0);
        }
        Map<String, String> filteredGroupNames = new HashMap<String, String>();
        for (ResourceGroup group : groups) {
            String functionalType = group.getFunctionalType();
            if (functionalType == null) {
                functionalType = "";
            }
            if (!functionalType.equals(currentFunctionalType)) continue;
            String groupId = String.valueOf(group.getId());
            String name = group.getName();
            filteredGroupNames.put(groupId, name);
        }
        filteredGroupNames = CommonUtils.sort(filteredGroupNames);
        this.pageContext.getRequest().setAttribute("FUNCTIONALTYPES", functionalTypes);
        this.pageContext.getRequest().setAttribute("RESOURCEGROUPS", filteredGroupNames);
    }

    private void cacheHumanUsers(ResourceType resourceType) {
        Set<Object> humanUsers = new HashSet();
        FormBeansHelper formBeansHelper = new FormBeansHelper();
        boolean isHumanType = resourceType != null ? "04".equals(resourceType.getSystemId()) : false;
        try {
            if (isHumanType) {
                humanUsers = formBeansHelper.populateUsersForResourceTypeHuman();
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Exception when fetching Human Users for Resource Form bean: " + ex.getMessage()), (Throwable)ex);
        }
        this.pageContext.getRequest().setAttribute("ISHUMANRESOURCETYPE", (Object)isHumanType);
        this.pageContext.getRequest().setAttribute("HUMANRESOUCES", humanUsers);
    }

    private boolean isResourceUpdate(ResourceForm form) {
        boolean isUpdate = false;
        if (form != null && form.getId() != null) {
            try {
                long resourceId = Long.parseLong(form.getId());
                isUpdate = resourceId >= 0L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isUpdate;
    }
}

