/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.n2bb.security.SecurityManager;
import com.n2bb.user.UserBean;
import com.n2bb.util.N2bbException;
import com.tandbergtv.workflow.auth.ACLEntry;
import com.tandbergtv.workflow.auth.AuthorizationException;
import com.tandbergtv.workflow.auth.AuthorizationManager;
import com.tandbergtv.workflow.auth.IAuthorizationManager;
import com.tandbergtv.workflow.auth.Role;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormBeansHelper {
    IAuthorizationManager authorizationManager = AuthorizationManager.getInstance();
    SecurityManager securityManager = SecurityManager.getInstance();
    public static final long PERFORM_OWN_TASK = 18L;
    public static final long PERFORM_OTHERS_TASK = 19L;
    public static final String REMOVE_SPACES = "RemoveSpaces";

    public String stringHelper(String originalString, String strOperation) {
        String modifiedString = null;
        if (strOperation.equals(REMOVE_SPACES)) {
            modifiedString = this.removeSpaces(originalString);
        }
        return modifiedString;
    }

    private String removeSpaces(String originalString) {
        String string = null;
        string = originalString.replaceAll(" ", "");
        return string;
    }

    public Set<UserBean> populateUsersForResourceTypeHuman() throws AuthorizationException, N2bbException {
        HashSet<UserBean> userSet = new HashSet<UserBean>();
        List<Role> roles = this.authorizationManager.getRoles();
        for (Role role : roles) {
            Set<ACLEntry> setAclEntry = role.getACL();
            for (ACLEntry aclEntry : setAclEntry) {
                if (aclEntry.getPermission().getId() != 18L && aclEntry.getPermission().getId() != 19L) continue;
                userSet.addAll(this.securityManager.getUserData(aclEntry.getRole().getName()));
            }
        }
        return userSet;
    }
}

