/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.util.CaseInsensitiveComparator;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ProcessInfo {
    private static final Logger logger = Logger.getLogger(ProcessInfo.class);

    public static Map getVariablesToShowInUI(WorkflowProcess process) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(new CaseInsensitiveComparator());
        Collection<TaskVariable> variables = process.getProcessDefinition().getStartTaskVariables();
        for (TaskVariable taskVar : variables) {
            if (!taskVar.isShowInUI()) continue;
            String variableName = taskVar.getVariableName();
            String variableValue = null;
            if (process.getContextInstance().getVariable(variableName) != null) {
                variableValue = process.getContextInstance().getVariable(variableName).toString();
            }
            logger.debug((Object)("Variable found to show in UI - Tasks Parameters section: " + variableName + " | " + variableValue));
            if (variableValue == null || variableValue.trim().equals("")) continue;
            sortedMap.put(variableName, variableValue);
        }
        return sortedMap;
    }
}

