/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;

public class IngresDialect
extends Dialect {
    public IngresDialect() {
        this.registerColumnType(-7, "tinyint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(7, "real");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "float");
        this.registerColumnType(2, "decimal(19, $l)");
        this.registerColumnType(3, "decimal(19, $l)");
        this.registerColumnType(-2, 32000, "byte($l)");
        this.registerColumnType(-2, "long byte");
        this.registerColumnType(-3, 32000, "varbyte($l)");
        this.registerColumnType(-3, "long byte");
        this.registerColumnType(-4, "long byte");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, 32000, "varchar($l)");
        this.registerColumnType(12, "long varchar");
        this.registerColumnType(-1, "long varchar");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "date");
        this.registerColumnType(93, "date");
        this.registerColumnType(2004, "long byte");
        this.registerColumnType(2005, "long varchar");
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("atan", new StandardSQLFunction("atan", Hibernate.DOUBLE));
        this.registerFunction("bit_add", new StandardSQLFunction("bit_add"));
        this.registerFunction("bit_and", new StandardSQLFunction("bit_and"));
        this.registerFunction("bit_length", new StandardSQLFunction("bit_length"));
        this.registerFunction("bit_not", new StandardSQLFunction("bit_not"));
        this.registerFunction("bit_or", new StandardSQLFunction("bit_or"));
        this.registerFunction("bit_xor", new StandardSQLFunction("bit_xor"));
        this.registerFunction("character_length", new StandardSQLFunction("character_length", Hibernate.LONG));
        this.registerFunction("charextract", new StandardSQLFunction("charextract", Hibernate.STRING));
        this.registerFunction("concat", new StandardSQLFunction("concat", Hibernate.STRING));
        this.registerFunction("cos", new StandardSQLFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("current_user", new NoArgSQLFunction("current_user", Hibernate.STRING, false));
        this.registerFunction("date_trunc", new StandardSQLFunction("date_trunc", Hibernate.TIMESTAMP));
        this.registerFunction("dba", new NoArgSQLFunction("dba", Hibernate.STRING, true));
        this.registerFunction("dow", new StandardSQLFunction("dow", Hibernate.STRING));
        this.registerFunction("exp", new StandardSQLFunction("exp", Hibernate.DOUBLE));
        this.registerFunction("gmt_timestamp", new StandardSQLFunction("gmt_timestamp", Hibernate.STRING));
        this.registerFunction("hash", new StandardSQLFunction("hash", Hibernate.INTEGER));
        this.registerFunction("hex", new StandardSQLFunction("hex", Hibernate.STRING));
        this.registerFunction("initial_user", new NoArgSQLFunction("initial_user", Hibernate.STRING, false));
        this.registerFunction("intextract", new StandardSQLFunction("intextract", Hibernate.INTEGER));
        this.registerFunction("left", new StandardSQLFunction("left", Hibernate.STRING));
        this.registerFunction("locate", new StandardSQLFunction("locate", Hibernate.LONG));
        this.registerFunction("length", new StandardSQLFunction("length", Hibernate.LONG));
        this.registerFunction("ln", new StandardSQLFunction("ln", Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("log", Hibernate.DOUBLE));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("lowercase", new StandardSQLFunction("lowercase"));
        this.registerFunction("octet_length", new StandardSQLFunction("octet_length", Hibernate.LONG));
        this.registerFunction("pad", new StandardSQLFunction("pad", Hibernate.STRING));
        this.registerFunction("position", new StandardSQLFunction("position", Hibernate.LONG));
        this.registerFunction("power", new StandardSQLFunction("power", Hibernate.DOUBLE));
        this.registerFunction("random", new NoArgSQLFunction("random", Hibernate.LONG, true));
        this.registerFunction("randomf", new NoArgSQLFunction("randomf", Hibernate.DOUBLE, true));
        this.registerFunction("right", new StandardSQLFunction("right", Hibernate.STRING));
        this.registerFunction("session_user", new NoArgSQLFunction("session_user", Hibernate.STRING, false));
        this.registerFunction("size", new NoArgSQLFunction("size", Hibernate.LONG, true));
        this.registerFunction("squeeze", new StandardSQLFunction("squeeze"));
        this.registerFunction("sin", new StandardSQLFunction("sin", Hibernate.DOUBLE));
        this.registerFunction("soundex", new StandardSQLFunction("soundex", Hibernate.STRING));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", Hibernate.DOUBLE));
        this.registerFunction("system_user", new NoArgSQLFunction("system_user", Hibernate.STRING, false));
        this.registerFunction("trim", new StandardSQLFunction("trim"));
        this.registerFunction("unhex", new StandardSQLFunction("unhex", Hibernate.STRING));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("uppercase", new StandardSQLFunction("uppercase"));
        this.registerFunction("user", new NoArgSQLFunction("user", Hibernate.STRING, false));
        this.registerFunction("usercode", new NoArgSQLFunction("usercode", Hibernate.STRING, true));
        this.registerFunction("username", new NoArgSQLFunction("username", Hibernate.STRING, true));
        this.registerFunction("uuid_create", new StandardSQLFunction("uuid_create", Hibernate.BYTE));
        this.registerFunction("uuid_compare", new StandardSQLFunction("uuid_compare", Hibernate.INTEGER));
        this.registerFunction("uuid_from_char", new StandardSQLFunction("uuid_from_char", Hibernate.BYTE));
        this.registerFunction("uuid_to_char", new StandardSQLFunction("uuid_to_char", Hibernate.STRING));
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean supportsForUpdateOf() {
        return true;
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getNullColumnString() {
        return " with null";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select nextval for " + sequenceName;
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName + " restrict";
    }

    public String getQuerySequencesString() {
        return "select seq_name from iisequence";
    }

    public String getLowercaseFunction() {
        return "lowercase";
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public String getLimitString(String querySelect, int offset, int limit) {
        if (offset > 0) {
            throw new UnsupportedOperationException("offset not supported");
        }
        return new StringBuffer(querySelect.length() + 16).append(querySelect).insert(6, " first " + limit).toString();
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public boolean useMaxForLimit() {
        return true;
    }
}

