/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.Application;
import org.java.plugin.boot.ApplicationInitializer;
import org.java.plugin.boot.BootErrorHandler;
import org.java.plugin.boot.BootErrorHandlerConsole;
import org.java.plugin.boot.BootErrorHandlerGui;
import org.java.plugin.boot.ControlThread;
import org.java.plugin.boot.DefaultApplicationInitializer;
import org.java.plugin.boot.ErrorDialog;
import org.java.plugin.boot.ServiceApplication;
import org.java.plugin.boot.SimpleSplashHandler;
import org.java.plugin.boot.SplashHandler;
import org.java.plugin.boot.SplashHandlerWrapper;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;
import org.java.plugin.util.ResourceManager;

public final class Boot {
    public static final String BOOT_ERROR_FILE_NAME = "jpf-boot-error.txt";
    public static final String PROP_BOOT_CONFIG = "jpf.boot.config";
    public static final String PROP_BOOT_MODE = "jpf.boot.mode";
    public static final String BOOT_MODE_SHELL = "shell";
    public static final String BOOT_MODE_START = "start";
    public static final String BOOT_MODE_STOP = "stop";
    public static final String BOOT_MODE_RESTART = "restart";
    public static final String BOOT_MODE_LOAD = "load";
    static final String PACKAGE_NAME = "org.java.plugin.boot";
    private static final String PARAM_CONTROL_HOST = "org.java.plugin.boot.controlHost";
    private static final String PARAM_CONTROL_PORT = "org.java.plugin.boot.controlPort";
    private static final String PARAM_ERROR_HANDLER = "org.java.plugin.boot.errorHandler";
    private static final String PARAM_APP_INITIALIZER = "org.java.plugin.boot.appInitializer";
    private static final String PARAM_SPLASH_HANDLER = "org.java.plugin.boot.splashHandler";
    private static final String PARAM_SPLASH_IMAGE = "org.java.plugin.boot.splashImage";
    private static final String PARAM_SPLASH_LEAVE_VISIBLE = "org.java.plugin.boot.splashLeaveVisible";
    private static final String PARAM_SPLASH_DISPOSE_ON_HIDE = "org.java.plugin.boot.splashDisposeOnHide";
    private static final String PARAM_SPLASH_CONFIG_PREFIX = "org.java.plugin.boot.splash.";
    static SplashHandler splashHandler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        Boot.clearBootLog();
        ExtendedProperties extendedProperties = new ExtendedProperties(System.getProperties());
        try {
            object = Boot.lookupConfig();
            try {
                extendedProperties.load((InputStream)object);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = extendedProperties.getProperty(PROP_BOOT_MODE);
        object = object != null ? ((String)object).trim().toLowerCase(Locale.ENGLISH) : BOOT_MODE_SHELL;
        extendedProperties.setProperty(PROP_BOOT_MODE, (String)object);
        System.setProperty(PROP_BOOT_MODE, (String)object);
        boolean bl = extendedProperties.containsKey((Object)PARAM_CONTROL_HOST) && extendedProperties.containsKey((Object)PARAM_CONTROL_PORT);
        BootErrorHandler bootErrorHandler = Boot.getErrorHandlerInstance(extendedProperties.getProperty(PARAM_ERROR_HANDLER), bl);
        try {
            if (extendedProperties.getProperty("applicationRoot") == null) {
                String string = new File(".").getCanonicalPath();
                extendedProperties.put((Object)"applicationRoot", (Object)string);
            }
            Boot.boot(extendedProperties, bl, (String)object, bootErrorHandler, stringArray);
        }
        catch (Throwable throwable) {
            if (splashHandler != null) {
                splashHandler.setVisible(false);
                splashHandler = null;
            }
            Boot.bootLog(throwable);
            bootErrorHandler.handleFatalError(ResourceManager.getMessage((String)PACKAGE_NAME, (String)"bootFailed"), throwable);
            System.exit(1);
        }
    }

    public static Application boot(ExtendedProperties extendedProperties, boolean bl, String string, BootErrorHandler bootErrorHandler, String[] stringArray) throws Exception {
        int n;
        InetAddress inetAddress = bl ? InetAddress.getByName(extendedProperties.getProperty(PARAM_CONTROL_HOST)) : null;
        int n2 = n = bl ? Integer.parseInt(extendedProperties.getProperty(PARAM_CONTROL_PORT), 10) : 0;
        if (bl && BOOT_MODE_STOP.equals(string)) {
            if (!ControlThread.stopRunningApplication(inetAddress, n)) {
                System.out.println("application not running");
            } else {
                System.out.println("application stopped");
            }
            return null;
        }
        if (bl && BOOT_MODE_START.equals(string)) {
            if (ControlThread.isApplicationRunning(inetAddress, n)) {
                bootErrorHandler.handleFatalError("Application already running.");
                return null;
            }
            Application application = Boot.initApplication(bootErrorHandler, extendedProperties, stringArray);
            if (!(application instanceof ServiceApplication)) {
                bootErrorHandler.handleFatalError("Application is not a service.");
                return null;
            }
            ControlThread controlThread = new ControlThread(inetAddress, n, (ServiceApplication)application);
            application.startApplication();
            controlThread.start();
            System.out.println("application started in BACKGROUND mode");
            return application;
        }
        if (bl && BOOT_MODE_RESTART.equals(string)) {
            Application application;
            if (ControlThread.stopRunningApplication(inetAddress, n)) {
                System.out.println("another instance of application stopped");
            }
            if (!((application = Boot.initApplication(bootErrorHandler, extendedProperties, stringArray)) instanceof ServiceApplication)) {
                bootErrorHandler.handleFatalError("Application is not a service.");
                return null;
            }
            ControlThread controlThread = new ControlThread(inetAddress, n, (ServiceApplication)application);
            application.startApplication();
            controlThread.start();
            System.out.println("application started in BACKGROUND mode");
            return application;
        }
        if (bl && ControlThread.stopRunningApplication(inetAddress, n)) {
            System.out.println("another instance of application stopped");
        }
        if (!BOOT_MODE_LOAD.equals(string)) {
            Boot.initSplashHandler(extendedProperties);
            if (splashHandler != null) {
                splashHandler.setVisible(true);
            }
        }
        Application application = Boot.initApplication(bootErrorHandler, extendedProperties, stringArray);
        if (!BOOT_MODE_LOAD.equals(string)) {
            application.startApplication();
            if (splashHandler != null && !"true".equalsIgnoreCase(extendedProperties.getProperty(PARAM_SPLASH_LEAVE_VISIBLE, "false"))) {
                splashHandler.setVisible(false);
            }
            if (application instanceof ServiceApplication && BOOT_MODE_SHELL.equals(string)) {
                System.out.println("application started in SHELL mode");
                Boot.runShell();
                Boot.stopApplication(application);
            }
        }
        return application;
    }

    public static void stopApplication(Application application) throws Exception {
        PluginManager pluginManager;
        if (application instanceof ServiceApplication) {
            ((ServiceApplication)application).stopApplication();
        }
        if ((pluginManager = PluginManager.lookup((Object)application)) != null) {
            pluginManager.shutdown();
        }
        LogFactory.getLog(Boot.class).info((Object)"logging system finalized");
        LogFactory.getLog(Boot.class).info((Object)"---------------------------------");
        LogFactory.releaseAll();
    }

    public static SplashHandler getSplashHandler() {
        return splashHandler;
    }

    public static void setSplashHandler(SplashHandler splashHandler) {
        if (splashHandler == null && Boot.splashHandler != null) {
            Boot.splashHandler.setVisible(false);
        }
        Boot.splashHandler = splashHandler;
    }

    private static InputStream lookupConfig() throws IOException {
        String string = System.getProperty(PROP_BOOT_CONFIG);
        if (string != null) {
            return IoUtil.getResourceInputStream((URL)Boot.str2url(string));
        }
        File file = new File("boot.properties");
        if (file.isFile()) {
            return new FileInputStream(file);
        }
        URL uRL = Boot.class.getClassLoader().getResource("boot.properties");
        if (uRL != null) {
            return IoUtil.getResourceInputStream((URL)uRL);
        }
        uRL = Boot.class.getResource("boot.properties");
        if (uRL != null) {
            return IoUtil.getResourceInputStream((URL)uRL);
        }
        throw new IOException("configuration file boot.properties not found");
    }

    private static URL str2url(String string) throws MalformedURLException {
        int n = string.indexOf("!/");
        if (n == -1) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return IoUtil.file2url((File)new File(string));
            }
        }
        if (string.startsWith("jar:")) {
            return new URL(string);
        }
        File file = new File(string.substring(0, n));
        if (file.isFile()) {
            return new URL("jar:" + IoUtil.file2url((File)file) + string.substring(n));
        }
        return new URL("jar:" + string);
    }

    private static BootErrorHandler getErrorHandlerInstance(String string, boolean bl) {
        if (string != null) {
            try {
                return (BootErrorHandler)Class.forName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
                System.err.println("failed instantiating error handler " + string);
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("failed instantiating error handler " + string);
                illegalAccessException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("failed instantiating error handler " + string);
                classNotFoundException.printStackTrace();
            }
        }
        return bl ? new BootErrorHandlerConsole() : new BootErrorHandlerGui();
    }

    private static void initSplashHandler(ExtendedProperties extendedProperties) throws Exception {
        boolean bl;
        String string = extendedProperties.getProperty(PARAM_SPLASH_HANDLER);
        String string2 = extendedProperties.getProperty(PARAM_SPLASH_IMAGE);
        URL uRL = null;
        if (string2 != null && string2.length() > 0) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL == null) {
                File file = new File(string2);
                if (file.isFile()) {
                    uRL = IoUtil.file2url((File)file);
                } else {
                    throw new FileNotFoundException("splash image file " + file + " not found");
                }
            }
        }
        boolean bl2 = bl = !"false".equalsIgnoreCase(extendedProperties.getProperty(PARAM_SPLASH_DISPOSE_ON_HIDE, "true"));
        if (string != null) {
            splashHandler = new SplashHandlerWrapper(bl, (SplashHandler)Class.forName(string).newInstance());
        }
        if (splashHandler == null && uRL != null) {
            splashHandler = new SplashHandlerWrapper(bl, new SimpleSplashHandler());
        }
        if (splashHandler != null) {
            if (uRL != null) {
                splashHandler.setImage(uRL);
            }
            splashHandler.configure(extendedProperties.getSubset(PARAM_SPLASH_CONFIG_PREFIX));
        }
    }

    private static Application initApplication(BootErrorHandler bootErrorHandler, ExtendedProperties extendedProperties, String[] stringArray) throws Exception {
        ApplicationInitializer applicationInitializer = null;
        String string = extendedProperties.getProperty(PARAM_APP_INITIALIZER);
        if (string != null) {
            try {
                applicationInitializer = (ApplicationInitializer)Class.forName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
                System.err.println("failed instantiating application initializer " + string);
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("failed instantiating application initializer " + string);
                illegalAccessException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("failed instantiating application initializer " + string);
                classNotFoundException.printStackTrace();
            }
        }
        if (applicationInitializer == null) {
            applicationInitializer = new DefaultApplicationInitializer();
        }
        applicationInitializer.configure(extendedProperties);
        Application application = applicationInitializer.initApplication(bootErrorHandler, stringArray);
        if (application == null) {
            throw new Exception(ResourceManager.getMessage((String)PACKAGE_NAME, (String)"bootAppInitFailed"));
        }
        return application;
    }

    private static void runShell() {
        int n;
        System.out.println("Press 'q' key to exit.");
        do {
            try {
                n = System.in.read();
            }
            catch (IOException iOException) {
                break;
            }
        } while ('q' != (char)n && 'Q' != (char)n);
    }

    private static void clearBootLog() {
        File file = new File(BOOT_ERROR_FILE_NAME);
        if (file.isFile()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bootLog(Throwable throwable) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(BOOT_ERROR_FILE_NAME, false), "UTF-8");
            try {
                outputStreamWriter.write("JPF Application boot failed.");
                outputStreamWriter.write(System.getProperty("line.separator"));
                outputStreamWriter.write(ErrorDialog.getErrorDetails(throwable));
            }
            finally {
                ((Writer)outputStreamWriter).close();
            }
        }
        catch (Throwable throwable2) {
            throw new Error("boot failed", throwable);
        }
    }

    private Boot() {
    }
}

