/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;

final class SplashWindow
extends Window {
    private static final long serialVersionUID = 7264517933349367876L;
    private static SplashWindow instance;
    private Image image;
    boolean paintCalled = false;

    private SplashWindow(Frame frame, Image image) {
        super(frame);
        this.image = image;
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = this.image.getWidth(this);
        int n2 = this.image.getHeight(this);
        this.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent mouseEvent) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.paintCalled = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.this.dispose();
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void splash(Image image) {
        if (instance == null && image != null) {
            Frame frame = new Frame();
            instance = new SplashWindow(frame, image);
            instance.setVisible(true);
            if (!EventQueue.isDispatchThread() && Runtime.getRuntime().availableProcessors() == 1) {
                SplashWindow splashWindow = instance;
                synchronized (splashWindow) {
                    while (!SplashWindow.instance.paintCalled) {
                        try {
                            instance.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    static void splash(URL uRL) {
        if (uRL != null) {
            SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(uRL));
        }
    }

    static void disposeSplash() {
        if (instance != null) {
            instance.getOwner().dispose();
            instance = null;
        }
    }
}

