/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.adi;

import com.n2bb.commons.exceptions.MetadataException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.dom.XPath;
import org.saxpath.SAXPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdiUtil {
    protected static Log n2bbLog = LogFactory.getLog((Class)(class$com$n2bb$commons$adi$AdiUtil == null ? (class$com$n2bb$commons$adi$AdiUtil = AdiUtil.class$("com.n2bb.commons.adi.AdiUtil")) : class$com$n2bb$commons$adi$AdiUtil));
    public static final String DEFAULT_SPEC_TAG = "Metadata_Spec_Version";
    private Node context;
    static /* synthetic */ Class class$com$n2bb$commons$adi$AdiUtil;

    public AdiUtil(Document document) {
        this.context = document;
    }

    public AdiUtil(Node node) {
        this.context = node;
    }

    public Map getAMSData(String string) throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(8, 10.0f);
        try {
            String string2 = "//AMS[@Asset_Name=\"" + AdiUtil.escapeQuotes(string) + "\"]";
            XPath xPath = new XPath(string2);
            Node node = (Node)xPath.selectSingleNode((Object)this.context);
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string3 = attr.getNodeName();
                String string4 = attr.getNodeValue();
                hashtable.put(string3, string4);
            }
        }
        catch (Exception exception) {
            n2bbLog.error((Object)exception);
            throw new Exception("Error retrieving AMS data", exception);
        }
        return hashtable;
    }

    public Map getAppData(String string) throws Exception {
        Hashtable<String, Object> hashtable = null;
        try {
            String string2 = "//AMS[@Asset_Name=\"" + AdiUtil.escapeQuotes(string) + "\"]/../../Metadata//App_Data";
            XPath xPath = new XPath(string2);
            List list = xPath.selectNodes((Object)this.context);
            if (list.size() > 0) {
                hashtable = new Hashtable<String, Object>(15, 10.0f);
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        Vector<String> vector;
                        Element element = (Element)list.get(i);
                        String string3 = element.getAttribute("Name");
                        String string4 = element.getAttribute("Value");
                        try {
                            String string5 = (String)hashtable.get(string3);
                            if (string5 != null) {
                                vector = new Vector<String>(5, 5);
                                vector.add(string5);
                                vector.add(string4);
                                hashtable.put(string3, vector);
                                continue;
                            }
                            hashtable.put(string3, string4);
                        }
                        catch (ClassCastException classCastException) {
                            vector = (Vector<String>)hashtable.get(string3);
                            vector.add(string4);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        n2bbLog.error((Object)exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            n2bbLog.error((Object)exception);
            throw new Exception("Error retrieving app data", exception);
        }
        return hashtable;
    }

    public String getAssetType(String string) throws Exception {
        String string2 = null;
        try {
            string2 = this.getValue("//AMS[@Asset_Name=\"" + AdiUtil.escapeQuotes(string) + "\"]/..//App_Data[@Name='type' or @Name='Type']/@Value");
        }
        catch (Exception exception) {
            n2bbLog.error((Object)exception);
        }
        return string2;
    }

    public Collection getAssetNames() throws Exception {
        List list = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            XPath xPath = new XPath("//AMS/@Asset_Name");
            list = xPath.selectNodes((Object)this.context);
            for (int i = 0; i < list.size(); ++i) {
                Attr attr = (Attr)list.get(i);
                arrayList.add(attr.getNodeValue());
            }
        }
        catch (Exception exception) {
            n2bbLog.error((Object)exception);
            throw new Exception("Error retrieving Assets", exception);
        }
        return arrayList;
    }

    public String getContent(String string) throws Exception {
        try {
            Attr attr = (Attr)this.getNode("//AMS[@Asset_Name=\"" + AdiUtil.escapeQuotes(string) + "\"]/../../Content/@Value");
            return attr.getNodeValue();
        }
        catch (Exception exception) {
            n2bbLog.error((Object)exception);
            return null;
        }
    }

    public void setContext(Node node) {
        this.context = node;
    }

    public String getAppString() throws Exception {
        try {
            return this.getValue("//App_Data/@App");
        }
        catch (Exception exception) {
            n2bbLog.error((Object)exception);
            throw new Exception("Error retrieving app string", exception);
        }
    }

    public String getMetadataSpec() throws SAXPathException {
        String string = "//App_Data[@Name='Metadata_Spec_Version']/@Value";
        XPath xPath = new XPath(string);
        String string2 = xPath.valueOf((Object)this.context);
        n2bbLog.debug((Object)("TAG=" + string2));
        if (string2.equals("")) {
            n2bbLog.warn((Object)"Metadata Spec tag not found");
        }
        return string2;
    }

    public int getNumChildAssets() throws Exception {
        try {
            XPath xPath = new XPath("//Asset");
            return xPath.selectNodes((Object)this.context).size();
        }
        catch (Exception exception) {
            n2bbLog.error((Object)exception);
            throw new Exception("Error retrieving count(childAssets)", exception);
        }
    }

    public String getProduct() throws MetadataException {
        try {
            return this.getValue("/ADI/Metadata/AMS/@Product");
        }
        catch (Exception exception) {
            throw new MetadataException("Error retrieving product", exception);
        }
    }

    public String getProvider() throws MetadataException {
        try {
            return this.getValue("/ADI/Metadata/AMS/@Provider");
        }
        catch (Exception exception) {
            throw new MetadataException("Error retrieving prodvider", exception);
        }
    }

    public String getValue(String string) throws Exception {
        try {
            XPath xPath = new XPath(string);
            return xPath.valueOf((Object)this.context);
        }
        catch (Exception exception) {
            n2bbLog.error((Object)exception);
            throw new Exception("Error in xpath expr=" + string, exception);
        }
    }

    public Node getNode(String string) throws Exception {
        try {
            XPath xPath = new XPath(string);
            return (Node)xPath.selectSingleNode((Object)this.context);
        }
        catch (Exception exception) {
            n2bbLog.error((Object)exception);
            throw new Exception("Error in xpath expr=" + string, exception);
        }
    }

    public static Document stripEmptyAppData(Document document, String string) {
        try {
            Element element = (Element)AdiUtil.getAssetNode(document, string);
            NodeList nodeList = element.getChildNodes();
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                Attr attr;
                String string2;
                Node node = nodeList.item(i);
                if (!node.getNodeName().equalsIgnoreCase("App_Data") || (string2 = (attr = ((Element)node).getAttributeNode("Value")).getValue()) != null && !string2.equals("") && !string2.equals(" ")) continue;
                n2bbLog.debug((Object)("STRIPPING EMPTY APP NODE " + node.getNodeName()));
                element.removeChild(node);
            }
        }
        catch (Exception exception) {
            n2bbLog.error((Object)"ERROR removing empty nodes", (Throwable)exception);
        }
        return document;
    }

    private static String escapeQuotes(String string) {
        return string.replaceAll("\"", "\\\"");
    }

    public static Node getAssetNode(Document document, String string) {
        Node node = null;
        try {
            String string2 = "//AMS[@Asset_Name=\"" + AdiUtil.escapeQuotes(string) + "\"]/..";
            XPath xPath = new XPath(string2);
            node = (Node)xPath.selectSingleNode((Object)document);
        }
        catch (Exception exception) {
            n2bbLog.error((Object)("ERROR retrieving asset Element asset=" + string), (Throwable)exception);
        }
        return node;
    }

    public List xSelectNodes(String string) throws Exception {
        List list = null;
        try {
            XPath xPath = new XPath(string);
            list = xPath.selectNodes((Object)this.context);
        }
        catch (Exception exception) {
            n2bbLog.error((Object)exception);
            throw new Exception("Error retrieving xpath expr=" + string, exception);
        }
        return list;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

