/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.data;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class MpaaRating {
    private static final String[] ADVISORIES_TV = new String[]{"D", "L", "S", "V", "FV"};
    private static final Collection ADV_TV_COLL = new Vector(ADVISORIES_TV.length);
    private static final Hashtable RATING = new Hashtable(15);
    private String rating;
    private Collection tvRatings;

    private MpaaRating(String string) {
        this.rating = string;
        this.tvRatings = new Vector(5);
    }

    public MpaaRating(String string, Collection collection) {
        this.rating = string;
        this.tvRatings = collection;
    }

    public void setTvRatings(Collection collection) {
        this.tvRatings = collection;
    }

    public static MpaaRating parse(String string) throws ParseException {
        MpaaRating mpaaRating = null;
        try {
            if (string != null) {
                String[] stringArray = (string = string.trim()).split(new Character(' ').toString(), 2);
                if (stringArray.length == 1) {
                    mpaaRating = new MpaaRating(stringArray[0]);
                } else {
                    mpaaRating = new MpaaRating(stringArray[0]);
                    String string2 = stringArray[1].replaceAll(" ", "");
                    Vector<String> vector = new Vector<String>(Arrays.asList(string2.split(",")));
                    mpaaRating.setTvRatings(vector);
                }
            }
        }
        catch (Exception exception) {
            throw new ParseException("Error parsing MPAA Rating, string=" + string + ", e=" + exception + ":" + exception.getMessage(), -1);
        }
        if (mpaaRating == null) {
            throw new ParseException("Error parsing MPAA Rating, string=" + string, -1);
        }
        return mpaaRating;
    }

    public boolean validateRating() {
        return RATING.containsKey(this.rating);
    }

    public boolean validateTvRating() {
        Iterator iterator = this.tvRatings.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (ADV_TV_COLL.contains(string)) continue;
            return false;
        }
        return true;
    }

    public boolean validate() {
        if (!RATING.containsKey(this.rating)) {
            return false;
        }
        Iterator iterator = this.tvRatings.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Vector vector = (Vector)RATING.get(this.rating);
            if (vector.contains(string)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.rating);
        Iterator iterator = this.tvRatings.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(" ");
        }
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(MpaaRating.parse("TV-Y7 V").validate());
            System.out.println(MpaaRating.parse("TV-14 D,L,S,FV").validate());
            System.out.println(MpaaRating.parse("TV-G").validate());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        for (int i = 0; i < ADVISORIES_TV.length; ++i) {
            ADV_TV_COLL.add(ADVISORIES_TV[i]);
        }
        RATING.put("G", new Vector(0));
        RATING.put("PG", new Vector(0));
        RATING.put("PG-13", new Vector(0));
        RATING.put("R", new Vector(0));
        RATING.put("NC-17", new Vector(0));
        RATING.put("X", new Vector(0));
        RATING.put("XX", new Vector(0));
        RATING.put("XXX", new Vector(0));
        RATING.put("Unrated", new Vector(0));
        Vector<String> vector = new Vector<String>(1);
        vector.add(ADVISORIES_TV[4]);
        RATING.put("TV-Y", vector);
        Vector<String> vector2 = new Vector<String>(1);
        vector2.add(ADVISORIES_TV[4]);
        RATING.put("TV-Y7", vector2);
        RATING.put("TV-G", new Vector(0));
        Vector<String> vector3 = new Vector<String>(4);
        vector3.add(ADVISORIES_TV[0]);
        vector3.add(ADVISORIES_TV[1]);
        vector3.add(ADVISORIES_TV[2]);
        vector3.add(ADVISORIES_TV[3]);
        RATING.put("TV-PG", vector3);
        Vector<String> vector4 = new Vector<String>(4);
        vector4.add(ADVISORIES_TV[0]);
        vector4.add(ADVISORIES_TV[1]);
        vector4.add(ADVISORIES_TV[2]);
        vector4.add(ADVISORIES_TV[3]);
        RATING.put("TV-14", vector4);
        Vector<String> vector5 = new Vector<String>(3);
        vector5.add(ADVISORIES_TV[1]);
        vector5.add(ADVISORIES_TV[2]);
        vector5.add(ADVISORIES_TV[3]);
        RATING.put("TV-MA", vector5);
    }
}

