/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.xml;

import com.n2bb.commons.exceptions.N2bbException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class PrettyXML {
    private static final Log n2bbLog = LogFactory.getLog((Class)(class$com$n2bb$commons$xml$PrettyXML == null ? (class$com$n2bb$commons$xml$PrettyXML = PrettyXML.class$("com.n2bb.commons.xml.PrettyXML")) : class$com$n2bb$commons$xml$PrettyXML));
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    static /* synthetic */ Class class$com$n2bb$commons$xml$PrettyXML;

    public static void prettyXML(File file, String string) throws N2bbException {
        n2bbLog.debug((Object)"enter.");
        try {
            n2bbLog.debug((Object)("xml file=" + file.getAbsolutePath()));
            n2bbLog.debug((Object)("encoding=" + string));
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            if (string != null) {
                outputFormat.setEncoding(string);
            }
            Document document = PrettyXML.parse(file);
            XMLWriter xMLWriter = new XMLWriter((OutputStream)new FileOutputStream(file), outputFormat);
            xMLWriter.write(document);
            xMLWriter.flush();
        }
        catch (Exception exception) {
            String string2 = "Error while formatting XML file=" + file.getAbsolutePath() + ", e=" + exception + ", re-throwing ...";
            n2bbLog.error((Object)string2);
            throw new N2bbException(string2, exception);
        }
    }

    public static void prettyXML(org.w3c.dom.Document document, File file, String string) throws N2bbException {
        n2bbLog.debug((Object)"enter.");
        try {
            n2bbLog.debug((Object)("target file=" + file.getAbsolutePath()));
            n2bbLog.debug((Object)("encoding=" + string));
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            if (string != null) {
                outputFormat.setEncoding(string);
            }
            DOMReader dOMReader = new DOMReader();
            Document document2 = dOMReader.read(document);
            XMLWriter xMLWriter = new XMLWriter((OutputStream)new FileOutputStream(file), outputFormat);
            xMLWriter.write(document2);
            xMLWriter.flush();
        }
        catch (Exception exception) {
            String string2 = "Error while formatting XML to file=" + file.getAbsolutePath() + ", e=" + exception + ", re-throwing ...";
            n2bbLog.error((Object)string2);
            throw new N2bbException(string2, exception);
        }
    }

    public static void prettyXML(org.w3c.dom.Document document, OutputStream outputStream) throws N2bbException {
        PrettyXML.prettyXML(document, outputStream, DEFAULT_ENCODING, false);
    }

    public static void prettyXML(org.w3c.dom.Document document, OutputStream outputStream, String string) throws N2bbException {
        PrettyXML.prettyXML(document, outputStream, string, false);
    }

    public static void prettyXML(org.w3c.dom.Document document, OutputStream outputStream, String string, boolean bl) throws N2bbException {
        n2bbLog.debug((Object)"enter.");
        try {
            n2bbLog.debug((Object)("encoding=" + string));
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            if (string != null) {
                outputFormat.setEncoding(string);
            }
            DOMReader dOMReader = new DOMReader();
            Document document2 = dOMReader.read(document);
            if (bl) {
                document2.setDocType(null);
            }
            XMLWriter xMLWriter = new XMLWriter(outputStream, outputFormat);
            xMLWriter.write(document2);
            xMLWriter.flush();
        }
        catch (Exception exception) {
            String string2 = "Error while formatting XML, e=" + exception + ", re-throwing ...";
            n2bbLog.error((Object)string2);
            throw new N2bbException(string2, exception);
        }
    }

    private static Document parse(File file) throws N2bbException {
        n2bbLog.debug((Object)"enter.");
        try {
            n2bbLog.debug((Object)("xml file=" + file.getAbsolutePath()));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document document = documentBuilder.parse(file);
            DOMReader dOMReader = new DOMReader();
            Document document2 = dOMReader.read(document);
            document2.normalize();
            return document2;
        }
        catch (Exception exception) {
            String string = "Error while parsing file=" + file.getAbsolutePath() + " XML, e=" + exception + ", re-throwing ...";
            n2bbLog.error((Object)string);
            throw new N2bbException(string, exception);
        }
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File("F:\\n2bb\\WebPluginInstaller\\files\\output2.xml");
            PrettyXML.prettyXML(file, DEFAULT_ENCODING);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

