/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.displayer;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import net.sf.navigator.displayer.MenuDisplayerMapping;
import net.sf.navigator.displayer.MessageResourcesMenuDisplayer;
import net.sf.navigator.menu.MenuComponent;
import org.apache.commons.lang.StringUtils;

public class ListMenuDisplayer
extends MessageResourcesMenuDisplayer {
    public void init(PageContext pageContext, MenuDisplayerMapping mapping) {
        super.init(pageContext, mapping);
        String id = (String)pageContext.getAttribute("menuId");
        try {
            this.out.println(this.displayStrings.getMessage("lmd.begin", (Object)(id != null ? "id=\"" + id + "\" " : "")));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
    }

    public void display(MenuComponent menu) throws JspException, IOException {
        if (this.isAllowed(menu)) {
            this.out.println(this.displayStrings.getMessage("lmd.menu.top"));
            this.displayComponents(menu, 0);
            this.out.println(this.displayStrings.getMessage("lmd.menu.bottom"));
        }
    }

    protected void displayComponents(MenuComponent menu, int level) throws JspException, IOException {
        MenuComponent[] components = menu.getMenuComponents();
        if (components.length > 0) {
            String domId = StringUtils.deleteWhitespace((String)this.getMessage(menu.getName()));
            String menuClass = "menu";
            if (level >= 1) {
                menuClass = "submenu";
            }
            if (menu.getUrl() != null) {
                this.out.println(this.displayStrings.getMessage("lmd.menu.actuator.link", (Object)domId, (Object)this.getMessage(menu.getTitle()), (Object)menuClass, (Object)this.getMessage(menu.getUrl())));
            } else {
                this.out.println(this.displayStrings.getMessage("lmd.menu.actuator.top", (Object)domId, (Object)this.getMessage(menu.getTitle()), (Object)menuClass));
            }
            int i = 0;
            while (i < components.length) {
                if (this.isAllowed(components[i])) {
                    if (components[i].getMenuComponents().length > 0) {
                        this.out.println("<li>");
                        this.displayComponents(components[i], level + 1);
                        this.out.println(this.displayStrings.getMessage("lmd.menu.actuator.bottom"));
                    } else {
                        this.out.println(this.displayStrings.getMessage("lmd.menu.item", (Object)components[i].getUrl(), (Object)super.getMenuToolTip(components[i]), (Object)this.getExtra(components[i]), (Object)this.getMessage(components[i].getTitle())));
                    }
                }
                ++i;
            }
            if (menuClass.equals("menu")) {
                this.out.println("</ul>");
            }
        } else if (menu.getParent() == null) {
            this.out.println(this.displayStrings.getMessage("lmd.menu.standalone", (Object)menu.getUrl(), (Object)super.getMenuToolTip(menu), (Object)this.getExtra(menu), (Object)this.getMessage(menu.getTitle())));
        } else {
            this.out.println(this.displayStrings.getMessage("lmd.menu.item", (Object)menu.getUrl(), (Object)super.getMenuToolTip(menu), (Object)this.getExtra(menu), (Object)this.getMessage(menu.getTitle())));
        }
    }

    public void end(PageContext context) {
        try {
            this.out.print(this.displayStrings.getMessage("lmd.end"));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
    }

    public String getExtra(MenuComponent menu) {
        StringBuffer extra = new StringBuffer();
        if (menu.getTarget() != null) {
            extra.append(" target=\"").append(menu.getTarget()).append("\"");
        }
        if (menu.getOnclick() != null) {
            extra.append(" onclick=\"").append(menu.getOnclick()).append("\"");
        }
        if (menu.getOnmouseover() != null) {
            extra.append(" onmouseover=\"").append(menu.getOnmouseover()).append("\"");
        }
        if (menu.getOnmouseout() != null) {
            extra.append(" onmouseout=\"").append(menu.getOnmouseout()).append("\"");
        }
        return extra.length() > 0 ? extra.toString() : "";
    }
}

