/*
 * Decompiled with CFR 0.152.
 */
package org.webtree.data;

import java.io.File;
import org.webtree.TreeNode;
import org.webtree.data.BaseTreeNode;

public class FileSystemNode
extends BaseTreeNode {
    protected File file;
    protected boolean fullyLoaded = false;

    public FileSystemNode(String basePathStr) {
        this.file = new File(basePathStr);
        this.id = this.file.getAbsolutePath();
        this.name = this.file.getName();
        if (this.name == null || this.name.length() < 1) {
            this.name = this.id;
        }
    }

    public TreeNode[] getChildren() {
        if (!this.file.isDirectory()) {
            TreeNode[] nochildren = new TreeNode[]{};
            return nochildren;
        }
        File[] files = this.file.listFiles();
        TreeNode[] childNodes = new FileSystemNode[files.length];
        int i = 0;
        while (i < files.length) {
            childNodes[i] = new FileSystemNode(files[i].getAbsolutePath());
            ++i;
        }
        return childNodes;
    }

    public int getChildCount() {
        return this.getChildren().length;
    }

    public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    public boolean isLeaf() {
        return !this.hasChildren();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.getId() + "=" + this.getName());
        return sbuf.toString();
    }
}

