/*
 * Decompiled with CFR 0.152.
 */
package org.webtree.renderer;

import org.apache.log4j.Category;
import org.webtree.TreeData;
import org.webtree.TreeMessage;
import org.webtree.TreeNode;
import org.webtree.TreeRenderer;
import org.webtree.TreeView;

public class ConsoleRenderer
implements TreeRenderer {
    public static String T = "\u00c3";
    public static String T_PLUS = "\u00c3+";
    public static String T_MINUS = "\u00c3-";
    public static String L = "\u00c0";
    public static String L_PLUS = "\u00c0+";
    public static String L_MINUS = "\u00c0-";
    public static String I = "\u00b3";
    public static String I_PLUS = "\u00b3+";
    public static String I_MINUS = "\u00b3-";
    public static String PLUS = "+";
    public static String MINUS = "-";
    public static String SITE = "*";
    public static String SITE_PLUS = "*+";
    public static String SITE_MINUS = "*-";
    public static String FOLDER = "\u00dd";
    public static String FOLDER_PLUS = "\u00dd+";
    public static String FOLDER_MINUS = "\u00dd-";
    public static String FOLDER_HIGH = "\u00db";
    public static String FOLDER_HIGH_PLUS = "\u00db+";
    public static String FOLDER_HIGH_MINUS = "\u00db-";
    public static String FILE = "-";
    public static String CRLF = "\r\n";
    public static String EMPTY = " ";
    private static Category log = Category.getInstance((String)(class$org$webtree$renderer$ConsoleRenderer == null ? (class$org$webtree$renderer$ConsoleRenderer = ConsoleRenderer.class$("org.webtree.renderer.ConsoleRenderer")) : class$org$webtree$renderer$ConsoleRenderer).getName());
    static /* synthetic */ Class class$org$webtree$renderer$ConsoleRenderer;

    public static void main(String[] args) {
        ConsoleRenderer consoleRenderer = new ConsoleRenderer();
    }

    private StringBuffer showNavigation(TreeNode current, TreeView tview, int level, int childOrder, int totalSiblings, String background) throws Exception {
        log.debug((Object)"entering showNavigation()");
        StringBuffer sbuf = new StringBuffer();
        TreeNode[] children = null;
        try {
            children = current.getChildren();
        }
        catch (Exception excGetRoot) {
            System.out.println("could not get current children: " + excGetRoot);
        }
        log.debug((Object)"got children for node");
        int nChildren = children != null ? children.length : 0;
        String currentNodeId = current.getId();
        boolean firstChild = childOrder == 0;
        boolean lastChild = childOrder == totalSiblings - 1;
        boolean selected = tview.isNodeSelected(currentNodeId);
        boolean open = tview.isNodeOpen(currentNodeId);
        boolean descend = nChildren > 0 && open;
        int i = 0;
        while (i < background.length()) {
            if (background.charAt(i) == 'I') {
                sbuf.append(I);
            } else {
                sbuf.append(EMPTY);
            }
            ++i;
        }
        if (nChildren > 0) {
            if (level == 0) {
                if (descend) {
                    sbuf.append(SITE_MINUS);
                } else {
                    sbuf.append(SITE_PLUS);
                }
            } else if (descend) {
                if (lastChild) {
                    sbuf.append(L_MINUS);
                } else {
                    sbuf.append(T_MINUS);
                }
            } else if (lastChild) {
                sbuf.append(L_PLUS);
            } else {
                sbuf.append(T_PLUS);
            }
        } else if (lastChild) {
            sbuf.append(L);
        } else {
            sbuf.append(T);
        }
        if (descend) {
            if (selected) {
                sbuf.append(FOLDER_HIGH);
            } else {
                sbuf.append(FOLDER);
            }
        } else if (current.isLeaf()) {
            sbuf.append(FILE);
        } else if (selected) {
            sbuf.append(FOLDER_HIGH_MINUS);
        } else {
            sbuf.append(FOLDER_MINUS);
        }
        sbuf.append(current.getName());
        sbuf.append("\r\n");
        if (descend) {
            String dropDownI = " ";
            if (level > 0 && !lastChild) {
                dropDownI = "I";
            }
            int childCount = 0;
            int i2 = 0;
            while (i2 < children.length) {
                sbuf.append(this.showNavigation(children[i2], tview, level + 1, childCount, nChildren, background + dropDownI));
                ++childCount;
                ++i2;
            }
        }
        return sbuf;
    }

    public String render(TreeData tdata, TreeView tview, TreeMessage tevent) {
        StringBuffer sbuf = new StringBuffer();
        TreeNode rootNode = tdata.getRoot();
        TreeNode[] children = null;
        try {
            children = rootNode.getChildren();
            log.debug((Object)("got " + children.length + " children for this node"));
        }
        catch (Exception excGetRoot) {
            System.err.println("error while getting root children for tree " + rootNode.getName() + ": " + excGetRoot);
            return sbuf.toString();
        }
        int nChildren = children.length;
        try {
            sbuf.append(this.showNavigation(rootNode, tview, 0, 0, nChildren, ""));
        }
        catch (Exception exc) {
            sbuf.append("ERROR while creating tree: " + exc);
        }
        return sbuf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

