/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.AlertsModule.actions;

import com.n2bb.AlertsModule.actions.MaxActionThreadsExceededException;
import com.n2bb.LogModule.N2BB_LogClient;
import org.apache.log4j.Logger;

public abstract class ActionManager {
    private static final String TOO_MANY_THREADS_MSG = "TOO MANY THREADS RUNNING; CHECK CONFIGURATION";
    protected static Logger logger = Logger.getLogger(ActionManager.class);
    protected String m_className;
    private int m_threadMax;
    private int m_threadCount = 0;

    public ActionManager(String className, int maxThreads) {
        this.m_className = className;
        this.m_threadMax = maxThreads;
        logger.info((Object)(this.m_className + " created - max threads... " + this.m_threadMax));
    }

    protected abstract void processAction(Object[] var1);

    public void doAction(Object[] objs) {
        try {
            this.incrementThreadCount();
            ActionThread a = new ActionThread(objs);
            a.start();
        }
        catch (MaxActionThreadsExceededException e) {
            logger.error((Object)(this.m_className + " - " + TOO_MANY_THREADS_MSG));
            N2BB_LogClient.instance().logMessage(this.m_className, "doAction", TOO_MANY_THREADS_MSG, 3);
        }
        catch (Exception e) {
            logger.error((Object)(this.m_className + " exception... "), (Throwable)e);
            N2BB_LogClient.instance().logStackTrace(this.m_className, "doAction", "error processing alert action", (Throwable)e, 3);
        }
    }

    private synchronized void incrementThreadCount() throws MaxActionThreadsExceededException {
        logger.debug((Object)(this.m_className + " current threads - " + this.m_threadCount));
        if (this.m_threadCount < this.m_threadMax) {
            ++this.m_threadCount;
        } else {
            throw new MaxActionThreadsExceededException();
        }
    }

    private synchronized void decrementThreadCount() {
        --this.m_threadCount;
    }

    private class ActionThread
    extends Thread {
        Object[] m_objs;

        public ActionThread(Object[] objs) {
            this.m_objs = objs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.debug((Object)(ActionManager.this.m_className + " thread starting"));
            try {
                ActionManager.this.processAction(this.m_objs);
            }
            catch (Exception e) {
                logger.fatal((Object)"sleep error", (Throwable)e);
            }
            finally {
                ActionManager.this.decrementThreadCount();
            }
            logger.debug((Object)(ActionManager.this.m_className + " thread stopping"));
        }
    }
}

