/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.AlertsModule.actions;

import com.n2bb.AlertsModule.actions.ActionManager;
import com.n2bb.LogModule.N2BB_LogClient;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailActionManager
extends ActionManager {
    private static final String TIME_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private static final String EMAIL_FILE = "/usr/local/n2bb/alerts/conf/AlertEmail.template";

    public EmailActionManager(String className, int maxThreads) {
        super(className, maxThreads);
    }

    protected void processAction(Object[] objs) {
        try {
            String emailHost = (String)objs[0];
            String emailFromAddr = (String)objs[1];
            String emailToAddr = (String)objs[2];
            String alertId = (String)objs[3];
            String alertName = (String)objs[4];
            String logMessage = (String)objs[5];
            Date date = (Date)objs[6];
            SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
            String local = format.format(date);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            String gmt = format.format(date);
            Properties props = new Properties();
            props.put("mail.smtp.host", emailHost);
            Session session = Session.getDefaultInstance((Properties)props, null);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(emailFromAddr));
            InternetAddress[] ia = new InternetAddress[]{new InternetAddress(emailToAddr)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])ia);
            String[] params = new String[]{alertId, local, gmt, alertName, logMessage};
            BufferedReader in = new BufferedReader(new FileReader(EMAIL_FILE));
            String subject = in.readLine();
            subject = MessageFormat.format(subject, params);
            msg.setSubject(subject);
            StringBuffer textSB = new StringBuffer();
            String temp = "";
            while ((temp = in.readLine()) != null) {
                textSB.append(temp).append("\n");
            }
            String text = MessageFormat.format(textSB.toString(), params);
            msg.setText(text);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            logger.error((Object)("email error - message... " + e.getMessage()), (Throwable)e);
            N2BB_LogClient.instance().logStackTrace(this.m_className, "processAction", "error sending email", (Throwable)e, 3);
            do {
                Address[] validSent;
                Address[] validUnsent;
                if (!(e instanceof SendFailedException)) continue;
                SendFailedException sfe = (SendFailedException)e;
                Address[] invalid = sfe.getInvalidAddresses();
                if (invalid != null) {
                    logger.error((Object)"  invalid addresses...");
                    for (int i = 0; i < invalid.length; ++i) {
                        logger.error((Object)("    " + invalid[i]));
                    }
                }
                if ((validUnsent = sfe.getValidUnsentAddresses()) != null) {
                    logger.error((Object)"  valid unsent addresses...");
                    for (int i = 0; i < validUnsent.length; ++i) {
                        logger.error((Object)("    " + validUnsent[i]));
                    }
                }
                if ((validSent = sfe.getValidSentAddresses()) == null) continue;
                logger.error((Object)"  valid sent addresses...");
                for (int i = 0; i < validSent.length; ++i) {
                    logger.error((Object)("    " + validSent[i]));
                }
            } while ((e = e instanceof MessagingException ? ((MessagingException)e).getNextException() : null) != null);
        }
    }
}

