/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.utils;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class Formats {
    private static final double kilo = 1024.0;
    private static final double mega = 1048576.0;
    private static final double giga = 1.073741824E9;

    public static String getRunTime(Long l) {
        return l == null ? "" : Formats.getRunTime((long)l);
    }

    public static boolean isName(String string) {
        string = string.trim();
        String string2 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789' -_.";
        for (int i = 0; i < string.length(); ++i) {
            if (string2.indexOf(string.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isDigits(String string) {
        string = string.trim();
        String string2 = "0123456789";
        for (int i = 0; i < string.length(); ++i) {
            if (string2.indexOf(string.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isLoginName(String string) {
        String string2 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.-_";
        for (int i = 0; i < string.length(); ++i) {
            if (string2.indexOf(string.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String getRunTime(long l) {
        DecimalFormat decimalFormat = new DecimalFormat("00");
        int n = (int)l / 3600;
        int n2 = (int)(l - (long)(n * 3600)) / 60;
        int n3 = (int)l % 60;
        return decimalFormat.format(n) + ":" + decimalFormat.format(n2) + ":" + decimalFormat.format(n3);
    }

    public static long getRunTimeSeconds(String string, boolean bl) throws RuntimeException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() > 3 || stringTokenizer.countTokens() < 1) {
            throw new RuntimeException("bad runtime format");
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        if (bl) {
            l = Long.parseLong(stringTokenizer.nextToken());
            l2 = Long.parseLong(stringTokenizer.nextToken());
        } else {
            if (stringTokenizer.countTokens() == 3) {
                l = Long.parseLong(stringTokenizer.nextToken());
            }
            if (stringTokenizer.countTokens() == 2) {
                l2 = Long.parseLong(stringTokenizer.nextToken());
            }
            if (stringTokenizer.countTokens() == 1) {
                l3 = Long.parseLong(stringTokenizer.nextToken());
            }
        }
        long l4 = l * 3600L + l2 * 60L + l3;
        return l4;
    }

    public static String getTruncated(String string, int n) {
        if (string != null && string.length() > n) {
            return string.substring(0, n) + "...";
        }
        return string;
    }

    public static String getFileSize(long l) {
        if ((double)l < 1024.0) {
            return l + " bytes";
        }
        if ((double)l < 1048576.0) {
            return Formats.formatFileSize((double)l / 1024.0) + " KB";
        }
        if ((double)l < 1.073741824E9) {
            return Formats.formatFileSize((double)l / 1048576.0) + " MB";
        }
        return Formats.formatFileSize((double)l / 1.073741824E9) + " GB";
    }

    private static String formatFileSize(double d) {
        int n = 0;
        if (d < 10.0) {
            n = 2;
        } else if (d < 100.0) {
            n = 1;
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat.format(d);
    }

    public static int getCents(String string) throws NumberFormatException {
        if (string.startsWith("$")) {
            string = string.substring(1);
        }
        return Math.round(Float.parseFloat(string) * 100.0f);
    }

    public static String getDollarsCents(int n) {
        NumberFormat numberFormat = Formats.getPriceFormat();
        return numberFormat.format((double)n / 100.0);
    }

    private static NumberFormat getPriceFormat() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat;
    }

    public static boolean isValidPrice(String string) {
        try {
            Formats.getCents(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

