/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.menu;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import net.sf.navigator.menu.MenuRepository;
import net.sf.navigator.util.LoadableResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;

public class MenuPlugIn
implements PlugIn {
    private static Log log = LogFactory.getLog(MenuPlugIn.class);
    private MenuRepository repository;
    private String menuConfig = "/WEB-INF/menu-config.xml";
    private HttpServlet servlet;

    public String getMenuConfig() {
        return this.menuConfig;
    }

    public void setMenuConfig(String menuConfig) {
        this.menuConfig = menuConfig;
    }

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting struts-menu initialization");
        }
        this.servlet = servlet;
        this.repository = new MenuRepository();
        this.repository.setLoadParam(this.menuConfig);
        this.repository.setServletContext(servlet.getServletContext());
        try {
            this.repository.load();
            this.repository.buildBreadCrumbs("/");
            servlet.getServletContext().setAttribute("net.sf.navigator.menu.MENU_REPOSITORY", (Object)this.repository);
            if (log.isDebugEnabled()) {
                log.debug((Object)"struts-menu initialization successful");
            }
        }
        catch (LoadableResourceException lre) {
            throw new ServletException("Failure initializing struts-menu: " + lre.getMessage());
        }
    }

    public void destroy() {
        this.repository = null;
        this.servlet.getServletContext().removeAttribute("net.sf.navigator.menu.MENU_REPOSITORY");
        this.menuConfig = null;
        this.servlet = null;
    }
}

