/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.servlet;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.tools.view.DataInfo;
import org.apache.velocity.tools.view.ToolInfo;
import org.apache.velocity.tools.view.XMLToolboxManager;
import org.apache.velocity.tools.view.context.ToolboxContext;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.servlet.ServletToolInfo;
import org.dom4j.Element;
import org.dom4j.Node;

public class ServletToolboxManager
extends XMLToolboxManager {
    public static final String ELEMENT_SCOPE = "scope";
    public static final String ELEMENT_CREATE_SESSION = "create-session";
    public static final String VALUE_YES = "yes";
    public static final String VALUE_NO = "no";
    public static final String SESSION_TOOLS_KEY = "org.apache.velocity.tools.view.tools.ServletToolboxManager.SessionTools";
    private ServletContext servletContext;
    private Map appTools;
    private ArrayList sessionToolInfo;
    private ArrayList requestToolInfo;
    private boolean createSession;
    private static HashMap managersMap = new HashMap();

    private ServletToolboxManager(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.appTools = new HashMap();
        this.sessionToolInfo = new ArrayList();
        this.requestToolInfo = new ArrayList();
        this.createSession = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized ServletToolboxManager getInstance(ServletContext servletContext, String toolboxFile) {
        ServletToolboxManager toolboxManager;
        block14: {
            String pathname;
            if (!toolboxFile.startsWith("/")) {
                toolboxFile = "/" + toolboxFile;
            }
            if ((toolboxManager = (ServletToolboxManager)managersMap.get(pathname = servletContext.getRealPath(toolboxFile))) == null) {
                InputStream is;
                block13: {
                    is = null;
                    is = servletContext.getResourceAsStream(toolboxFile);
                    if (is == null) break block13;
                    Velocity.info((Object)("Using toolbox configuration file '" + toolboxFile + "'"));
                    toolboxManager = new ServletToolboxManager(servletContext);
                    toolboxManager.load(is);
                    managersMap.put(pathname, toolboxManager);
                    Velocity.info((Object)"Toolbox setup complete.");
                }
                Object var8_5 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                    break block14;
                }
                catch (Exception ee) {}
                break block14;
                {
                    catch (Exception e) {
                        Velocity.error((Object)("Problem loading toolbox '" + toolboxFile + "' : " + e));
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        Velocity.error((Object)sw.toString());
                        Object var8_6 = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                            break block14;
                        }
                        catch (Exception ee) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return toolboxManager;
    }

    public void setCreateSession(boolean b) {
        this.createSession = b;
    }

    protected void log(String s) {
        Velocity.info((Object)("ServletToolboxManager: " + s));
    }

    protected boolean readElement(Element e) throws Exception {
        String name = e.getName();
        ToolInfo info = null;
        if (name.equalsIgnoreCase("tool")) {
            info = this.readToolInfo(e);
        } else if (name.equalsIgnoreCase("data")) {
            info = this.readDataInfo(e);
        } else {
            if (name.equalsIgnoreCase(ELEMENT_CREATE_SESSION)) {
                this.readCreateSession(e);
                return true;
            }
            this.log("Unreadable element: " + name);
            return false;
        }
        this.addTool(info);
        this.log("Added " + info.getClassname() + " as " + info.getKey());
        return true;
    }

    protected boolean readCreateSession(Element e) throws Exception {
        String csValue = e.getText();
        if (VALUE_YES.equalsIgnoreCase(csValue)) {
            this.setCreateSession(true);
        } else if (VALUE_NO.equalsIgnoreCase(csValue)) {
            this.setCreateSession(false);
        } else {
            this.log("Unknown value for create-session.  Valid options are 'yes' or 'no'.");
            return false;
        }
        this.log("create-session is set to " + this.createSession);
        return true;
    }

    protected ToolInfo readToolInfo(Element e) throws Exception {
        Node n = e.selectSingleNode("key");
        String key = n.getText();
        n = e.selectSingleNode("class");
        String classname = n.getText();
        String scope = "request";
        n = e.selectSingleNode(ELEMENT_SCOPE);
        if (n != null) {
            scope = n.getText();
        }
        return new ServletToolInfo(key, classname, scope);
    }

    public void addTool(ToolInfo info) {
        if (info instanceof DataInfo) {
            this.appTools.put(info.getKey(), info.getInstance(null));
        } else if (info instanceof ServletToolInfo) {
            ServletToolInfo stInfo = (ServletToolInfo)info;
            if (stInfo.getScope().equalsIgnoreCase("request")) {
                this.requestToolInfo.add(stInfo);
            } else if (stInfo.getScope().equalsIgnoreCase("session")) {
                this.sessionToolInfo.add(stInfo);
            } else if (stInfo.getScope().equalsIgnoreCase("application")) {
                this.appTools.put(stInfo.getKey(), stInfo.getInstance(this.servletContext));
            } else {
                this.log("Unknown scope: " + stInfo.getScope() + " " + stInfo.getKey() + " will be request scoped.");
                this.requestToolInfo.add(stInfo);
            }
        } else {
            this.requestToolInfo.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToolboxContext getToolboxContext(Object initData) {
        HttpSession session;
        ViewContext ctx = (ViewContext)initData;
        HashMap toolbox = new HashMap(this.appTools);
        if (!this.sessionToolInfo.isEmpty() && (session = ctx.getRequest().getSession(this.createSession)) != null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                HashMap<String, Object> stmap = (HashMap<String, Object>)session.getAttribute(SESSION_TOOLS_KEY);
                if (stmap == null) {
                    stmap = new HashMap<String, Object>(this.sessionToolInfo.size());
                    Iterator i = this.sessionToolInfo.iterator();
                    while (i.hasNext()) {
                        ToolInfo info = (ToolInfo)i.next();
                        stmap.put(info.getKey(), info.getInstance(ctx));
                    }
                    session.setAttribute(SESSION_TOOLS_KEY, stmap);
                }
                toolbox.putAll(stmap);
            }
        }
        Iterator i = this.requestToolInfo.iterator();
        while (i.hasNext()) {
            ToolInfo info = (ToolInfo)i.next();
            toolbox.put(info.getKey(), info.getInstance(ctx));
        }
        return new ToolboxContext(toolbox);
    }
}

