/*
 * Decompiled with CFR 0.152.
 */
package org.webtree.renderer;

import org.apache.log4j.Category;
import org.webtree.TreeData;
import org.webtree.TreeMessage;
import org.webtree.TreeNode;
import org.webtree.TreeRenderer;
import org.webtree.TreeView;

public class JavascriptRenderer
implements TreeRenderer {
    public String CELLSPACING = "0";
    public String CELLPADDING = "0";
    public String TABLEWIDTH = "600";
    public String TABLEBORDER = "0";
    public String TEXTSPACE = "&nbsp;";
    public String ICONWIDTH = "19";
    public String ICONHEIGHT = "20";
    public String CELLSTYLE = "treecell";
    public String SELECT_CELLSTYLE = "selecttreecell";
    public String[] SPECIAL_CELLSTYLE = new String[]{"boldtreecell", "italictreecell", "plaintreecell", "plaintreecell"};
    public String[] SPECIAL_COLOR = new String[]{"", "", "", ""};
    public String EMPTY_ICON = "blank.gif";
    public String T_ICON = "T.gif";
    public String I_ICON = "I.gif";
    public String L_ICON = "L.gif";
    public String TMINUS_ICON = "Tminus.gif";
    public String TPLUS_ICON = "Tplus.gif";
    public String LMINUS_ICON = "Lminus.gif";
    public String LPLUS_ICON = "Lplus.gif";
    public String MINUS_ICON = "minus.gif";
    public String PLUS_ICON = "plus.gif";
    public String MINUSFOLDER_ICON = "foldericon.gif";
    public String FOLDER_ICON = "firstfoldericon.gif";
    public String FILE_ICON = "fileicon.gif";
    public String MINUSFOLDERHIGH_ICON = "foldericon_high.gif";
    public String FOLDERHIGH_ICON = "firstfoldericon_high.gif";
    public String ROOTSITE_ICON = "rootsiteicon.gif";
    public String SITE_ICON = "firstsiteicon.gif";
    public String MINUSSITE_ICON = "siteicon.gif";
    public String CRLF = "\r\n";
    private static Category log = Category.getInstance((String)(class$org$webtree$renderer$JavascriptRenderer == null ? (class$org$webtree$renderer$JavascriptRenderer = JavascriptRenderer.class$("org.webtree.renderer.JavascriptRenderer")) : class$org$webtree$renderer$JavascriptRenderer).getName());
    static /* synthetic */ Class class$org$webtree$renderer$JavascriptRenderer;

    public static void main(String[] args) {
        JavascriptRenderer javascriptRenderer = new JavascriptRenderer();
    }

    private String getImagePath(TreeView view) {
        String themeValue = "";
        if (view.getTheme() != null) {
            themeValue = "/" + view.getTheme();
        }
        return view.getImagePath() + themeValue;
    }

    private StringBuffer renderScript(TreeView tview) {
        String[] all = new String[]{"blank.gif", "firstfoldericon.gif", "firstfoldericon_high.gif", "firstsite.gif", "foldericon.gif", "foldericon_high.gif", "I.gif", "L.gif", "Lminus.gif", "Lplus.gif", "minus.gif", "plus.gif", "T.gif", "Tminus.gif", "Tplus.gif", "rootfoldericon.gif", "rootsiteicon.gif", "siteicon.gif", "fileicon.gif"};
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<script language=JavaScript>").append(this.CRLF);
        sbuf.append("<!-- //").append(this.CRLF);
        sbuf.append("var DIR_IMAGES = '" + this.getImagePath(tview) + "/';").append(this.CRLF);
        int i = 0;
        while (i < all.length) {
            String index = i + "";
            if (i < 10) {
                index = "0" + index;
            }
            sbuf.append("im" + index + " = new Image();").append(this.CRLF);
            sbuf.append("im" + index + ".src = DIR_IMAGES + '" + all[i] + "';").append(this.CRLF);
            ++i;
        }
        sbuf.append("function jsTree() {").append(this.CRLF);
        sbuf.append("\tthis.root = null;\t//the root node of the tree").append(this.CRLF);
        sbuf.append("\tthis.nodes = new Array;\t//array for all nodes in the tree").append(this.CRLF);
        sbuf.append("\tthis.map = new Array;\t// associated array to resolve nodes array to node.id").append(this.CRLF);
        sbuf.append("\tthis.render = render;").append(this.CRLF);
        sbuf.append("} // jsTree").append(this.CRLF);
        sbuf.append("var myTree = new jsTree;").append(this.CRLF);
        sbuf.append("function jsTreeNode(csvString) {").append(this.CRLF);
        sbuf.append("   var fieldArray = csvString.split(',');").append(this.CRLF);
        sbuf.append("   var fcount = 0;").append(this.CRLF);
        sbuf.append("   this.id = fieldArray[fcount++];").append(this.CRLF);
        sbuf.append("   this.parent = fieldArray[fcount++];").append(this.CRLF);
        sbuf.append("   this.level = fieldArray[fcount++];").append(this.CRLF);
        sbuf.append("   this.descend = fieldArray[fcount++];").append(this.CRLF);
        sbuf.append("   this.selected = fieldArray[fcount++];").append(this.CRLF);
        sbuf.append("   this.prefixImages = new Array;").append(this.CRLF);
        sbuf.append("   for(var i=0;i<=this.level;i++) {").append(this.CRLF);
        sbuf.append("\t\t   this.prefixImages[i] = fieldArray[fcount++];").append(this.CRLF);
        sbuf.append("   }").append(this.CRLF);
        sbuf.append("   this.mode = fieldArray[fcount++];").append(this.CRLF);
        sbuf.append("   this.icon = fieldArray[fcount++];").append(this.CRLF);
        sbuf.append("   this.name = fieldArray[fcount++];").append(this.CRLF);
        sbuf.append("} // jsTreeNode").append(this.CRLF);
        sbuf.append("var counter = 0;").append(this.CRLF);
        sbuf.append("function addNode(s) {").append(this.CRLF);
        sbuf.append("\tvar newNode = new jsTreeNode(s);").append(this.CRLF);
        sbuf.append("\tmyTree.nodes[counter] = newNode;").append(this.CRLF);
        sbuf.append("\tmyTree.map['' + newNode.id] = counter;").append(this.CRLF);
        sbuf.append("\tcounter++;").append(this.CRLF);
        sbuf.append("}").append(this.CRLF);
        sbuf.append("function expand(s) {").append(this.CRLF);
        sbuf.append("   alert('expanding ' + s + ' with index at ' + myTree.map[s]);").append(this.CRLF);
        sbuf.append("   location.href = '").append(tview.getSelfHref()).append("';").append(this.CRLF);
        sbuf.append("}").append(this.CRLF);
        sbuf.append("function collapse(s) {").append(this.CRLF);
        sbuf.append("\talert('collapsing ' + s + ' with index at ' + myTree.map[s]);").append(this.CRLF);
        sbuf.append("}").append(this.CRLF);
        sbuf.append("function select(s) {").append(this.CRLF);
        sbuf.append("  alert('selecting ' + s + ' with index at ' + myTree.map[s]);").append(this.CRLF);
        sbuf.append("}").append(this.CRLF);
        sbuf.append("function render() {").append(this.CRLF);
        sbuf.append("\t\tfor(var i=0;i<myTree.nodes.length;i++) {").append(this.CRLF);
        sbuf.append("\t\t\tnode = myTree.nodes[i];").append(this.CRLF);
        sbuf.append("\t\t\tdocument.write('<table cellspacing=0 cellpadding=0 border=0><tr>');").append(this.CRLF);
        sbuf.append("\t\t\tmodeHref = '<a href=\\\"';").append(this.CRLF);
        sbuf.append("\t\t\tif(node.mode=='collapse') {").append(this.CRLF);
        sbuf.append("\t\t\t\tmodeHref = modeHref + \"JavaScript:collapse('\" + node.id + \"');\";").append(this.CRLF);
        sbuf.append("\t\t\t}else if(node.mode=='expand') {").append(this.CRLF);
        sbuf.append("\t\t\t\tmodeHref = modeHref + \"JavaScript:expand('\" + node.id + \"');\";").append(this.CRLF);
        sbuf.append("\t\t\t}else {").append(this.CRLF);
        sbuf.append("\t\t\t\tmodeHref = modeHref + \"JavaScript:alert('do nothing');\";").append(this.CRLF);
        sbuf.append("\t\t\t}").append(this.CRLF);
        sbuf.append("\t\t\tmodeHref = modeHref + '\\\">';").append(this.CRLF);
        sbuf.append("\t\t\tfor(var j=0;j<node.prefixImages.length;j++) {").append(this.CRLF);
        sbuf.append("\t\t\t\tif(j==node.prefixImages.length-1) {").append(this.CRLF);
        sbuf.append("\t\t\t\t\tdocument.write('<td>' + modeHref + '<img width=19 height=20 border=0 src=' + DIR_IMAGES + node.prefixImages[j] + '></a></td>');").append(this.CRLF);
        sbuf.append("\t\t\t\t}else {").append(this.CRLF);
        sbuf.append("\t\t\t\t\tdocument.write('<td><img width=19 height=20 border=0 src=' + DIR_IMAGES + node.prefixImages[j] + '></td>');").append(this.CRLF);
        sbuf.append("\t\t\t\t}").append(this.CRLF);
        sbuf.append("\t\t\t}").append(this.CRLF);
        sbuf.append("\t\t\tselectHref = \"<a href=\\\"JavaScript:select('\" + node.id + \"');\\\">\";").append(this.CRLF);
        sbuf.append("\t\t\tdocument.write('<td>' + selectHref + '<img width=19 height=20 border=0 src=' + DIR_IMAGES + node.icon + '></a></td>');").append(this.CRLF);
        sbuf.append("\t\t\tdocument.write('<td> &nbsp;' + selectHref + node.name + '</a></td>');").append(this.CRLF);
        sbuf.append("\t\t\tdocument.write('</tr></table>');").append(this.CRLF);
        sbuf.append("\t\t} // each node in tree").append(this.CRLF);
        sbuf.append("} // render").append(this.CRLF);
        return sbuf;
    }

    private StringBuffer showNavigation(TreeNode current, String parentId, TreeView tview, int level, int childOrder, int totalSiblings, String background) throws Exception {
        log.debug((Object)"entering showNavigation()");
        StringBuffer sbuf = new StringBuffer();
        TreeNode[] children = null;
        try {
            children = current.getChildren();
        }
        catch (Exception excGetRoot) {
            System.out.println("could not get current children: " + excGetRoot);
        }
        log.debug((Object)"got children for node");
        int nChildren = children.length;
        String currentNodeId = current.getId().replace('\\', '/');
        boolean open = tview.isNodeOpen(currentNodeId);
        boolean descend = nChildren > 0 && open;
        boolean firstChild = childOrder == 0;
        boolean lastChild = childOrder == totalSiblings - 1;
        boolean selected = tview.isNodeSelected(currentNodeId);
        StringBuffer selectURL = new StringBuffer();
        StringBuffer branchURL = new StringBuffer();
        if (descend) {
            branchURL.append("collapse,");
        } else {
            branchURL.append("expand");
        }
        sbuf.append("addNode('");
        sbuf.append(currentNodeId).append(",").append(parentId).append(",").append(level).append(",");
        sbuf.append(descend).append(",").append(selected).append(",");
        int i = 0;
        while (i < background.length()) {
            if (background.charAt(i) == 'I') {
                sbuf.append(this.I_ICON);
            } else {
                sbuf.append(this.EMPTY_ICON);
            }
            sbuf.append(",");
            ++i;
        }
        if (nChildren > 0) {
            if (level == 0) {
                if (descend) {
                    sbuf.append(this.MINUS_ICON);
                } else {
                    sbuf.append(this.PLUS_ICON);
                }
            } else if (descend) {
                if (lastChild) {
                    sbuf.append(this.LMINUS_ICON);
                } else {
                    sbuf.append(this.TMINUS_ICON);
                }
            } else if (lastChild) {
                sbuf.append(this.LPLUS_ICON);
            } else {
                sbuf.append(this.TPLUS_ICON);
            }
        } else if (lastChild) {
            sbuf.append(this.L_ICON);
        } else {
            sbuf.append(this.T_ICON);
        }
        sbuf.append(",");
        if (nChildren < 1) {
            sbuf.append("none,");
            sbuf.append(this.FOLDER_ICON);
        } else if (descend) {
            sbuf.append("collapse,");
            if (selected) {
                sbuf.append(this.FOLDERHIGH_ICON);
            } else {
                sbuf.append(this.FOLDER_ICON);
            }
        } else {
            sbuf.append("expand,");
            if (selected) {
                sbuf.append(this.MINUSFOLDERHIGH_ICON);
            } else {
                sbuf.append(this.MINUSFOLDER_ICON);
            }
        }
        sbuf.append(",");
        sbuf.append(current.getName());
        sbuf.append("');").append(this.CRLF);
        if (descend) {
            String dropDownI = " ";
            if (level > 0 && !lastChild) {
                dropDownI = "I";
            }
            int childCount = 0;
            int i2 = 0;
            while (i2 < children.length) {
                sbuf.append(this.showNavigation(children[i2], currentNodeId, tview, level + 1, childCount, nChildren, background + dropDownI));
                ++childCount;
                ++i2;
            }
        }
        return sbuf;
    }

    public String render(TreeData tdata, TreeView tview, TreeMessage tevent) {
        TreeNode rootNode = tdata.getRoot();
        try {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("<head>");
            sbuf.append(this.renderScript(tview)).append(this.CRLF);
            log.debug((Object)("operating on tree: " + rootNode.getName()));
            TreeNode[] children = null;
            try {
                children = rootNode.getChildren();
                log.debug((Object)("got " + children.length + " children for this node"));
            }
            catch (Exception excGetRoot) {
                System.err.println("error while getting root children for tree " + rootNode.getName() + ": " + excGetRoot);
                return sbuf.toString();
            }
            int nChildren = children.length;
            log.debug((Object)("# children: " + nChildren));
            sbuf.append(this.showNavigation(rootNode, null, tview, 0, 0, nChildren, ""));
            sbuf.append("// -->").append(this.CRLF);
            sbuf.append("</script>").append(this.CRLF);
            sbuf.append("</head>");
            sbuf.append("<body>");
            sbuf.append("<script language=javascript>");
            sbuf.append("myTree.render();");
            sbuf.append("</script>");
            sbuf.append("</body>");
            return sbuf.toString();
        }
        catch (Exception excGetRoot) {
            System.out.println("error while getting root and displaying tree: " + excGetRoot);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

