/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.message.HTTPAttachment;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMSAssetDetailsResponseHandler
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(AMSAssetDetailsResponseHandler.class);

    public AMSAssetDetailsResponseHandler() {
    }

    public AMSAssetDetailsResponseHandler(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage process(IMessage msg) throws HandlerException {
        logger.debug((Object)("Processing message: " + msg));
        String messageContent = msg.getPayload().getContent();
        try {
            messageContent = this.transformMessage(messageContent);
        }
        catch (Exception e) {
            throw new HandlerException("Cannot convert list parameters to simple parameters. Message Content: " + messageContent, (Throwable)e);
        }
        HTTPMessage result = this.constructMessage(messageContent, msg);
        logger.debug((Object)("Processed Message: " + result));
        return result;
    }

    public IMessage postProcess(IMessage msg) throws HandlerException {
        return msg;
    }

    private String transformMessage(String message) throws Exception {
        Document doc = XMLDocumentUtility.loadXml((String)message);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node wfsMessageNode = (Node)xpath.evaluate("//WFSMessage", doc, XPathConstants.NODE);
        NamedNodeMap attributes = wfsMessageNode.getAttributes();
        Node typeAttribute = attributes.getNamedItem("Type");
        if (typeAttribute != null && typeAttribute.getNodeValue().equals("ack")) {
            String title = this.getListParameter(xpath, doc, "Title");
            String titleBrief = this.getListParameter(xpath, doc, "Title_Brief");
            String licenseStart = this.getListParameter(xpath, doc, "Licensing_Window_Start");
            String licenseEnd = this.getListParameter(xpath, doc, "Licensing_Window_End");
            String hdContent = this.getListParameter(xpath, doc, "HDContent");
            String description = this.getListParameter(xpath, doc, "Description");
            this.removeListParameters(xpath, doc);
            Node parameterListNode = (Node)xpath.evaluate("//WFSMessage/MessageBody/ParameterList", doc, XPathConstants.NODE);
            this.createAndAddWPCLParamElement(doc, parameterListNode, "Title", title);
            this.createAndAddWPCLParamElement(doc, parameterListNode, "Title_Brief", titleBrief);
            this.createAndAddWPCLParamElement(doc, parameterListNode, "Licensing_Window_Start", licenseStart);
            this.createAndAddWPCLParamElement(doc, parameterListNode, "Licensing_Window_End", licenseEnd);
            this.createAndAddWPCLParamElement(doc, parameterListNode, "HDContent", hdContent);
            this.createAndAddWPCLParamElement(doc, parameterListNode, "Description", description);
        }
        wfsMessageNode.appendChild(this.createCommandParameter(doc, "task-complete"));
        return XMLDocumentUtility.convertToString((Node)doc);
    }

    private String getListParameter(XPath xpath, Document doc, String paramName) throws XPathExpressionException {
        return (String)xpath.evaluate("//List/ListItem[Parameter/Value='" + paramName + "']/Parameter[@Name='value']/Value", doc, XPathConstants.STRING);
    }

    private void removeListParameters(XPath xpath, Document doc) throws XPathExpressionException {
        NodeList listNodes = (NodeList)xpath.evaluate("//WFSMessage/MessageBody/ParameterList/List", doc, XPathConstants.NODESET);
        if (listNodes != null) {
            for (int i = 0; i < listNodes.getLength(); ++i) {
                Node listNode = listNodes.item(i);
                listNode.getParentNode().removeChild(listNode);
            }
        }
    }

    private void createAndAddWPCLParamElement(Document doc, Node parameterListNode, String name, String value) {
        Element paramElement = doc.createElement("Parameter");
        paramElement.setAttribute("DataType", "String");
        paramElement.setAttribute("Name", name);
        Element valueElement = doc.createElement("Value");
        valueElement.setTextContent(value);
        paramElement.appendChild(valueElement);
        parameterListNode.appendChild(paramElement);
    }

    private Element createCommandParameter(Document doc, String commandName) {
        Element commandElement = doc.createElement("Command");
        commandElement.setAttribute("Name", commandName);
        return commandElement;
    }

    private HTTPMessage constructMessage(String content, IMessage originalMessage) {
        HTTPPayload payload = new HTTPPayload(content);
        HTTPAttachment attachment = null;
        if (originalMessage.getAttachment() != null) {
            Object attachContent = originalMessage.getAttachment().getContent();
            String attachType = originalMessage.getAttachment().getContentType();
            attachment = new HTTPAttachment(attachContent, attachType);
        }
        return new HTTPMessage(payload, attachment);
    }
}

