/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.executionhandlers;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.executionhandler.handlers.ExecutionHandlerException;
import com.tandbergtv.workflow.plugins.directv.DirecTVConstants;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeExecutionHandler
implements ActionHandler {
    private static final long serialVersionUID = 5504973734715150711L;
    private static final Logger logger = Logger.getLogger(PurgeExecutionHandler.class);
    private static final String VAR_PATHLIST = "PathList";
    private static final String VAR_ARE_PATHS_FOUND = "arePathsFound";
    private static final String PATHS_FOUND = "true";
    private static final String PATHS_NOT_FOUND = "false";
    private static final String HOUSE_MATERIAL_ID_VARIABLES = "houseMaterialId.variables";
    private static final String BROADCAST_MATERIAL_ID_VARIABLES = "broadcastMaterialId.variables";
    private static final String METADATA_FILE_EXTENSION = "metadataFileExtension";
    private static final String TITLE_BRIEF_PROC_VAR_NAME = "titleBrief";

    public void execute(ExecutionContext context) {
        String[] pathvariables;
        String[] names;
        boolean broadcast;
        String houseMaterialId = (String)context.getVariable("houseMaterialId");
        String broadcastMaterialId = (String)context.getVariable("broadcastMaterialId");
        boolean house = houseMaterialId != null && houseMaterialId.length() > 0;
        boolean bl = broadcast = broadcastMaterialId != null && broadcastMaterialId.length() > 0;
        if (!house && !broadcast) {
            throw new ExecutionHandlerException("Either house or broadcast material id must be specified");
        }
        logger.info((Object)("House material id: " + houseMaterialId));
        logger.info((Object)("Broadcast material id: " + broadcastMaterialId));
        HashSet<String> paths = new HashSet<String>();
        if (house) {
            for (String name : names = DirecTVConstants.getString(HOUSE_MATERIAL_ID_VARIABLES).split(",")) {
                pathvariables = DirecTVConstants.getString(name).split(",");
                paths.addAll(this.getPaths(houseMaterialId, name, pathvariables, false, context));
            }
        }
        if (broadcast) {
            for (String name : names = DirecTVConstants.getString(BROADCAST_MATERIAL_ID_VARIABLES).split(",")) {
                pathvariables = DirecTVConstants.getString(name).split(",");
                paths.addAll(this.getPaths(broadcastMaterialId, name, pathvariables, true, context));
            }
        }
        logger.debug((Object)("Paths: " + paths));
        if (paths.size() > 0) {
            String pathList = this.convertPathsCollectionToPathList(paths);
            context.setVariable(VAR_PATHLIST, (Object)pathList);
            context.setVariable(VAR_ARE_PATHS_FOUND, (Object)PATHS_FOUND);
        } else {
            logger.warn((Object)"Failed to find any files to purge");
            context.setVariable(VAR_PATHLIST, null);
            context.setVariable(VAR_ARE_PATHS_FOUND, (Object)PATHS_NOT_FOUND);
        }
    }

    private String convertPathsCollectionToPathList(Collection<String> paths) {
        StringBuffer pathListSB = new StringBuffer();
        if (paths != null) {
            int i = 0;
            int pathsSize = paths.size();
            for (String path : paths) {
                pathListSB.append(path);
                if (++i == pathsSize) continue;
                pathListSB.append(",");
            }
        }
        return pathListSB.toString();
    }

    private Collection<String> getPaths(String materialId, String name, String[] pathvariables, boolean broadcast, ExecutionContext context) {
        HashSet<String> paths = new HashSet<String>();
        String mfExtension = DirecTVConstants.getString(METADATA_FILE_EXTENSION);
        List<WorkflowProcess> processes = this.search(name, materialId);
        logger.info((Object)("Found " + processes.size() + " process(es)"));
        for (WorkflowProcess process : processes) {
            String titleBrief = (String)process.getContextInstance().getVariable(TITLE_BRIEF_PROC_VAR_NAME);
            context.setVariable(TITLE_BRIEF_PROC_VAR_NAME, (Object)titleBrief);
            WorkflowTemplate template = process.getProcessDefinition();
            logger.info((Object)("Found process " + process.getId() + ", template " + template.getName()));
            for (String variable : pathvariables) {
                String path = (String)process.getContextInstance().getVariable(variable);
                if (path == null || path.length() <= 0) continue;
                logger.info((Object)("Path: " + path));
                paths.add(path);
                if (!broadcast) continue;
                String mfPath = path.substring(0, path.lastIndexOf(".") + 1) + mfExtension;
                logger.info((Object)("Path: " + mfPath));
                paths.add(mfPath);
            }
        }
        return paths;
    }

    private List<WorkflowProcess> search(String name, String value) {
        SearchCriteria criteria = new SearchCriteria();
        ListParameter parameter = new ListParameter("status", SearchType.PROCESSSTATUS);
        parameter.addValue((Object)ProcessStatus.COMPLETED);
        parameter.addValue((Object)ProcessStatus.CANCELLED);
        parameter.addValue((Object)ProcessStatus.ERROR);
        criteria.addParameter((SearchParameterBase)parameter);
        criteria.addParameter((SearchParameterBase)new ValueParameter(name, SearchType.STRING, true, (Object)value));
        return ((IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class)).search(criteria);
    }
}

