/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.templateselectors;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.messageprocessor.templateselector.AbstractTemplateSelector;
import com.tandbergtv.workflow.messageprocessor.templateselector.SelectorOutput;
import com.tandbergtv.workflow.messageprocessor.templateselector.TemplateSelectionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetTypeSelector
extends AbstractTemplateSelector {
    private static final String NON_ADULT_SD_MOVIE_KEY = "Non-Adult Movie SD Template";
    private static final String NON_ADULT_HD_MOVIE_KEY = "Non-Adult Movie HD Template";
    private static final String NON_ADULT_TRAILER_KEY = "Non-Adult Trailer Template";
    private static final String NON_ADULT_POSTER_KEY = "Non-Adult Poster Template";
    private static final String NON_ADULT_ROWAD_KEY = "Non-Adult RowAd Template";
    private static final String NON_ADULT_HOMEPAGE_KEY = "Non-Adult HomePage Template";
    private static final String NON_ADULT_MOBILE_KEY = "Non-Adult Mobile Template";
    private static final String ADULT_SD_MOVIE_KEY = "Adult Movie SD Template";
    private static final String ADULT_HD_MOVIE_KEY = "Adult Movie HD Template";
    private static final String ADULT_TRAILER_KEY = "Adult Trailer Template";
    private static final String ADULT_POSTER_KEY = "Adult Poster Template";
    private static final String ADULT_ROWAD_KEY = "Adult RowAd Template";
    private static final String ADULT_HOMEPAGE_KEY = "Adult HomePage Template";
    private static final String ADULT_MOBILE_KEY = "Adult Mobile Template";
    private static final String ASSET_TYPE = "assetType";
    private static final String CONTENT_TYPE = "contentType";
    private static final String ADULT_FLAG = "isAdultContent";
    private static final String HD_ASSET_FLAG = "HDContent";
    private static final String MOVIE_ASSET_TYPE = "movie";
    private static final String TRAILER_ASSET_TYPE = "preview";
    private static final String POSTER_ASSET_TYPE = "poster";
    private static final String ROWAD_ASSET_TYPE = "rowad";
    private static final String HOMEPAGE_ASSET_TYPE = "homepage";
    private static final String MOBILE_ASSET_TYPE = "clip";
    private static final String ASSET_HD_TRUE_VALUE = "Y";
    private static final String ADULT_TYPE_VALUE = "true";
    private static final String NON_ADULT_TYPE_VALUE = "false";

    public List<SelectorOutput> selectTemplates(WorkflowMessage message) throws TemplateSelectionException {
        String selectionKey = null;
        String assetType = message.getValue(ASSET_TYPE);
        if (assetType == null || assetType.length() == 0) {
            assetType = message.getValue(CONTENT_TYPE);
        }
        String assetHDFlag = message.getValue(HD_ASSET_FLAG);
        String adultFlag = message.getValue(ADULT_FLAG);
        boolean isHDAssetType = assetHDFlag != null && assetHDFlag.equals(ASSET_HD_TRUE_VALUE);
        Boolean isAdultAssetType = null;
        if (adultFlag != null && adultFlag.equals(ADULT_TYPE_VALUE)) {
            isAdultAssetType = Boolean.TRUE;
        } else if (adultFlag != null && adultFlag.equals(NON_ADULT_TYPE_VALUE)) {
            isAdultAssetType = Boolean.FALSE;
        }
        if (assetType == null) {
            String msg = "The Workflow Message has an invalid value[null] for the Asset Type parameter: assetType";
            throw new TemplateSelectionException(msg);
        }
        if (isAdultAssetType == null) {
            String msg = "The Workflow Message has an invalid value[null] for the Adult Flag parameter: isAdultContent";
            throw new TemplateSelectionException(msg);
        }
        boolean isAdult = isAdultAssetType;
        if (assetType.equals(MOVIE_ASSET_TYPE)) {
            selectionKey = isHDAssetType ? (isAdult ? ADULT_HD_MOVIE_KEY : NON_ADULT_HD_MOVIE_KEY) : (isAdult ? ADULT_SD_MOVIE_KEY : NON_ADULT_SD_MOVIE_KEY);
        } else if (assetType.equals(TRAILER_ASSET_TYPE)) {
            selectionKey = isAdult ? ADULT_TRAILER_KEY : NON_ADULT_TRAILER_KEY;
        } else if (assetType.equals(POSTER_ASSET_TYPE)) {
            selectionKey = isAdult ? ADULT_POSTER_KEY : NON_ADULT_POSTER_KEY;
        } else if (assetType.equals(ROWAD_ASSET_TYPE)) {
            selectionKey = isAdult ? ADULT_ROWAD_KEY : NON_ADULT_ROWAD_KEY;
        } else if (assetType.equals(HOMEPAGE_ASSET_TYPE)) {
            selectionKey = isAdult ? ADULT_HOMEPAGE_KEY : NON_ADULT_HOMEPAGE_KEY;
        } else if (assetType.equals(MOBILE_ASSET_TYPE)) {
            selectionKey = isAdult ? ADULT_MOBILE_KEY : NON_ADULT_MOBILE_KEY;
        } else {
            String msg = "The Workflow Message has an invalid value [" + assetType + "] for " + "Asset Type parameter: " + ASSET_TYPE;
            throw new TemplateSelectionException(msg);
        }
        Map templateVariables = this.getAllParamsFromMessage(message);
        SelectorOutput so = new SelectorOutput(selectionKey, templateVariables);
        ArrayList<SelectorOutput> soList = new ArrayList<SelectorOutput>();
        soList.add(so);
        return soList;
    }
}

