/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.templateselectors;

import com.tandbergtv.workflow.auth.AuthorizationManager;
import com.tandbergtv.workflow.auth.ProtectionKey;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.messageprocessor.templateselector.AbstractTemplateSelector;
import com.tandbergtv.workflow.messageprocessor.templateselector.SelectorOutput;
import com.tandbergtv.workflow.messageprocessor.templateselector.TemplateSelectionException;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceURLSelector
extends AbstractTemplateSelector {
    private static Logger logger = Logger.getLogger(SourceURLSelector.class);

    public List<SelectorOutput> selectTemplates(WorkflowMessage message) throws TemplateSelectionException {
        String resourceConnStr = message.getSource().toString();
        logger.debug((Object)("Resource Connection String: " + resourceConnStr));
        Resource resource = ResourceManager.getInstance().getResourceByConnectionString(resourceConnStr);
        if (resource == null) {
            throw new TemplateSelectionException("No resource exists for " + resourceConnStr);
        }
        Set resourceGroups = resource.getResourceGroups();
        if (resourceGroups != null && !resourceGroups.isEmpty()) {
            Iterator rgIter = resourceGroups.iterator();
            ResourceGroup resourceGroup = (ResourceGroup)rgIter.next();
            int protectionKeyID = resourceGroup.getProtectionKeyId();
            ProtectionKey protectionKey = AuthorizationManager.getInstance().getProtectionKey(protectionKeyID);
            if (protectionKey == null) {
                String errMsg = "No protection key found for protection key id: " + protectionKeyID;
                logger.error((Object)errMsg);
                throw new TemplateSelectionException(errMsg);
            }
            String protectionKeyName = protectionKey.getName();
            logger.debug((Object)("Protection Key associated with resource: " + resource.getName() + " is: " + protectionKeyName));
            SelectorOutput so = new SelectorOutput(message.getMessageUID().getUID() + "_" + protectionKeyName, this.getAllParamsFromMessage(message));
            ArrayList<SelectorOutput> soList = new ArrayList<SelectorOutput>();
            soList.add(so);
            return soList;
        }
        String errMsg = "No resource groups associated with resource: " + resource.getName();
        logger.error((Object)errMsg);
        throw new TemplateSelectionException(errMsg);
    }
}

