/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.security;

import com.n2bb.action.AbstractAction;
import com.n2bb.security.ChangeExpiredPasswordForm;
import com.n2bb.security.IdenticalPasswordException;
import com.n2bb.security.SecurityManager;
import com.n2bb.util.N2bbException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ChangeExpiredPasswordAction
extends AbstractAction {
    public static final String CHPASS_PREFIX = "chpass_";

    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Principal principal = request.getUserPrincipal();
        String username = principal.getName().substring(CHPASS_PREFIX.length());
        ChangeExpiredPasswordForm editForm = (ChangeExpiredPasswordForm)form;
        if (editForm.getAction().equals("save")) {
            if (editForm.getUsername() == null || !username.equals(editForm.getUsername())) {
                request.getSession().invalidate();
                return mapping.findForward("home");
            }
            try {
                SecurityManager.getInstance().changeExpiredPassword(username, editForm.getPassword());
            }
            catch (IdenticalPasswordException e) {
                editForm.setPassword("");
                editForm.setConfirmPassword("");
                throw new N2bbException("error.userManager.passwordNotChanged");
            }
            HttpSession session = request.getSession();
            String originalURI = (String)session.getAttribute("originalURI");
            request.getSession().invalidate();
            session = request.getSession();
            session.setAttribute("username", (Object)username);
            session.setAttribute("password", (Object)editForm.getPassword());
            if (originalURI != null) {
                response.sendRedirect(response.encodeRedirectURL(originalURI));
                return null;
            }
            return mapping.findForward("home");
        }
        ActionErrors errors = new ActionErrors();
        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.login.passwordExpired"));
        this.saveErrors(request, errors);
        editForm.setUsername(username);
        return mapping.findForward("enterPassword");
    }
}

