/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.security;

import com.n2bb.action.N2bbAction;
import com.n2bb.security.RoleForm;
import com.n2bb.security.SecurityManager;
import com.n2bb.user.UserBean;
import com.tandbergtv.workflow.auth.ACLEntry;
import com.tandbergtv.workflow.auth.AuthorizationManager;
import com.tandbergtv.workflow.auth.IAuthorizationManager;
import com.tandbergtv.workflow.auth.Permission;
import com.tandbergtv.workflow.auth.Role;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public final class RolesAction
extends N2bbAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defaultAction = "add";
        HttpSession session = request.getSession();
        String action = request.getParameter("actionType");
        if (request.getAttribute("actionType") != null) {
            action = (String)request.getAttribute("actionType");
        }
        if (action == null || action.equals("")) {
            action = defaultAction;
        }
        this.n2bbLog.debug((Object)("action... " + action));
        ActionErrors errors = new ActionErrors();
        ActionForward fwd = new ActionForward("home");
        try {
            RoleForm rf = (RoleForm)form;
            if (action.equals("add")) {
                fwd = this.addRole(errors, session) ? mapping.findForward("success") : mapping.findForward("failure");
            } else if (action.equals("save")) {
                if (this.saveRole(errors, rf)) {
                    request.setAttribute("save", (Object)"save");
                    return mapping.findForward("success");
                }
                fwd = mapping.findForward("failure");
            } else if (action.equals("edit")) {
                if (this.editRole(errors, session, request, form)) {
                    request.setAttribute("TabbedModify", (Object)"TabbedModify");
                    fwd = mapping.findForward("success");
                } else {
                    fwd = mapping.findForward("failure");
                }
            } else if (action.equals("update")) {
                if (this.updateRole(errors, rf)) {
                    request.setAttribute("update", (Object)"update");
                    return mapping.findForward("success");
                }
                ActionMessages actionMessages = new ActionMessages();
                actionMessages.add("role.permissions.performTask.required", new ActionMessage("role.permissions.performTask.required", true));
                this.saveMessages(request, actionMessages);
                request.setAttribute("actionType", (Object)"edit");
                return mapping.findForward("failure");
            }
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)("exception - message... " + e.getMessage()), (Throwable)e);
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other"));
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
        }
        return fwd;
    }

    private boolean addRole(ActionErrors errors, HttpSession session) {
        this.n2bbLog.debug((Object)"enter");
        try {
            session.setAttribute("moduleAreaLists", (Object)SecurityManager.getInstance().getModuleAreaLists());
            return true;
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.roleAction.add"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other"));
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean saveRole(ActionErrors errors, RoleForm form) {
        this.n2bbLog.debug((Object)"enter");
        try {
            IAuthorizationManager authorizationManager = AuthorizationManager.getInstance();
            Map<String, String> permissionsMap = form.getPermissionMap();
            this.n2bbLog.debug((Object)("Permissions Map -->" + permissionsMap));
            this.n2bbLog.debug((Object)("Role Name-->" + form.getN2RoleName() + ":: Description--->" + form.getDescription()));
            Role role = new Role(form.getN2RoleName(), form.getDescription());
            Set<Map.Entry<String, String>> permissions = permissionsMap.entrySet();
            for (Map.Entry<String, String> element : permissions) {
                role.addACL(new ACLEntry(role, new Permission(Long.parseLong(element.getValue().toString()))));
            }
            List<Role> roles = authorizationManager.getRoles();
            for (Role temprole : roles) {
                if (!temprole.getName().equals(role.getName())) continue;
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.roleAction.duplicate"));
                return false;
            }
            authorizationManager.createRole(role);
            return true;
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.roleAction.save"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other"));
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean editRole(ActionErrors errors, HttpSession session, HttpServletRequest request, ActionForm actionForm) {
        this.n2bbLog.debug((Object)"enter");
        try {
            String n2RoleName = request.getParameter("n2RoleName");
            this.n2bbLog.debug((Object)("role name... " + n2RoleName));
            if (n2RoleName == null) {
                n2RoleName = ((RoleForm)actionForm).getN2RoleName();
            }
            try {
                IAuthorizationManager authorizationManager = AuthorizationManager.getInstance();
                Role role = authorizationManager.getRole((Serializable)((Object)n2RoleName));
                String[] permissions = new String[role.getACL().size()];
                this.n2bbLog.debug((Object)("The permissions size --->" + role.getACL().size()));
                Iterator<ACLEntry> aclEntryIterator = role.getACL().iterator();
                int count = 0;
                while (aclEntryIterator.hasNext()) {
                    permissions[count++] = String.valueOf(aclEntryIterator.next().getPermission().getId());
                }
                RoleForm form = new RoleForm();
                form.setN2RoleName(role.getName());
                form.setDescription(role.getDescription());
                form.setPermissions(permissions);
                form.setAction("edit");
                SecurityManager securityManager = SecurityManager.getInstance();
                form.setUsers(securityManager.getUserData(role.getName()));
                request.setAttribute("roleForm", (Object)form);
            }
            catch (Exception e) {
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.roleAction.edit"));
                this.n2bbLog.error((Object)("failed to get role exception - message... " + e.getMessage()), (Throwable)e);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.roleAction.edit"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other"));
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean updateRole(ActionErrors errors, RoleForm form) {
        this.n2bbLog.debug((Object)"enter");
        try {
            ResourceManagement resourceManager = ResourceManager.getInstance();
            IAuthorizationManager authorizationManager = AuthorizationManager.getInstance();
            SecurityManager securityManager = SecurityManager.getInstance();
            Role role = authorizationManager.getRole((Serializable)((Object)form.getN2RoleName()));
            role.setDescription(form.getDescription());
            Set<ACLEntry> setACLEntries = role.getACL();
            long performTaskId = 0L;
            for (ACLEntry entry : setACLEntries) {
                if (!entry.getPermission().getName().equalsIgnoreCase("Perform Task")) continue;
                performTaskId = entry.getPermission().getId();
                break;
            }
            role.getACL().clear();
            this.n2bbLog.debug((Object)"Permission IDs-->");
            Map<String, String> permissionsMap = form.getPermissionMap();
            boolean performTaskPermissionStatus = false;
            boolean isResourceExists = false;
            if (performTaskId != 0L) {
                Set<UserBean> users = securityManager.getUserData(role.getName());
                for (UserBean userBean : users) {
                    if (resourceManager.getResourceByUser(userBean.getUserName()) == null) continue;
                    isResourceExists = true;
                    break;
                }
                if (isResourceExists) {
                    for (Map.Entry entry : permissionsMap.entrySet()) {
                        if (Long.parseLong(((String)entry.getValue()).toString()) != performTaskId) continue;
                        performTaskPermissionStatus = true;
                        break;
                    }
                    if (!performTaskPermissionStatus) {
                        return false;
                    }
                }
            }
            this.n2bbLog.debug((Object)("Permissions Map -->" + permissionsMap));
            this.n2bbLog.debug((Object)("Role Name-->" + form.getN2RoleName() + ":: Description--->" + form.getDescription()));
            Set<Map.Entry<String, String>> permissions = permissionsMap.entrySet();
            for (Map.Entry<String, String> entry : permissions) {
                role.addACL(new ACLEntry(role, new Permission(Long.parseLong(entry.getValue().toString()))));
            }
            authorizationManager.updateRole(role);
            return true;
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.roleAction.update"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other"));
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

