/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.sysmonui.alerts;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public final class FilterAlertHistoryForm
extends ActionForm {
    private static Log n2bbLog = LogFactory.getLog(FilterAlertHistoryForm.class);
    public String startDate = null;
    public String endDate = null;
    public String identifier = null;
    public String pattern = null;
    public String actionTaken = null;

    public FilterAlertHistoryForm() {
        n2bbLog.debug((Object)"enter");
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.endDate = this.startDate = sdf.format(cal.getTime());
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            format.setLenient(false);
            ParsePosition pos = new ParsePosition(0);
            Date start = null;
            if (!this.getStartDate().trim().equals("") && (start = format.parse(this.getStartDate(), pos)) == null) {
                n2bbLog.debug((Object)("startDate parse failed at position... " + pos.getIndex()));
                errors.add("startDate", new ActionError("error.invalid", (Object)"Start Date"));
            }
            pos.setIndex(0);
            Date end = null;
            if (!this.getEndDate().trim().equals("") && (end = format.parse(this.getEndDate(), pos)) == null) {
                n2bbLog.debug((Object)("endDate parse failed at position... " + pos.getIndex()));
                errors.add("endDate", new ActionError("error.invalid", (Object)"End Date"));
            }
            if (start != null && end != null && end.before(start)) {
                errors.add("startDate", new ActionError("error.date.order", (Object)"End Date", (Object)"Start Date"));
            }
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other.validation"));
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
        }
        return errors;
    }

    public String getStartDate() {
        return this.startDate == null ? "" : this.startDate;
    }

    public String getEndDate() {
        return this.endDate == null ? "" : this.endDate;
    }

    public String getIdentifier() {
        return this.identifier == null ? "" : this.identifier;
    }

    public String getPattern() {
        return this.pattern == null ? "" : this.pattern;
    }

    public String getActionTaken() {
        return this.actionTaken == null ? "" : this.actionTaken;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setActionTaken(String actionTaken) {
        this.actionTaken = actionTaken;
    }
}

